/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.util.ServerUtils;
import codechicken.lib.vec.Vector3;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mrtjp.projectred.core.inventory.BaseInventory;
import mrtjp.projectred.core.tile.IPacketReceiverTile;
import mrtjp.projectred.core.tile.ProjectRedTile;
import mrtjp.projectred.expansion.CraftingHelper;
import mrtjp.projectred.expansion.init.ExpansionBlocks;
import mrtjp.projectred.expansion.inventory.container.ProjectBenchContainer;
import mrtjp.projectred.expansion.item.RecipePlanItem;
import mrtjp.projectred.lib.InventoryLib;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ProjectBenchTile
extends ProjectRedTile
implements IPacketReceiverTile,
CraftingHelper.InventorySource {
    private static final int KEY_WRITE_PLAN = 2;
    private static final int KEY_CLEAR_GRID = 3;
    private final BaseInventory planInventory = new BaseInventory(1){

        public boolean m_7013_(int slot, ItemStack stack) {
            return stack.m_41720_() instanceof RecipePlanItem;
        }
    };
    private final BaseInventory craftingGrid = new BaseInventory(9);
    private final BaseInventory storageInventory = new BaseInventory(18);
    private final BaseInventory planCraftingGrid = new BaseInventory(9);
    private final CraftingHelper craftingHelper = new CraftingHelper(this);
    private final LazyOptional<?> storageInventoryCap = LazyOptional.of(this::createStorageInventoryCap);
    private boolean isPlanRecipe = false;
    private boolean recipeNeedsUpdate = true;

    public ProjectBenchTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ExpansionBlocks.PROJECT_BENCH_TILE.get(), pos, state);
        this.planInventory.m_19164_(this::onInventoryChanged);
        this.craftingGrid.m_19164_(this::onInventoryChanged);
        this.storageInventory.m_19164_(this::onInventoryChanged);
    }

    public void saveToNBT(CompoundTag tag) {
        this.planInventory.saveTo(tag, "plan_inv");
        this.craftingGrid.saveTo(tag, "crafting_inv");
        this.storageInventory.saveTo(tag, "storage_inv");
        this.planCraftingGrid.saveTo(tag, "plan_crafting_inv");
    }

    public void loadFromNBT(CompoundTag tag) {
        this.planInventory.loadFrom(tag, "plan_inv");
        this.craftingGrid.loadFrom(tag, "crafting_inv");
        this.storageInventory.loadFrom(tag, "storage_inv");
        this.planCraftingGrid.loadFrom(tag, "plan_crafting_inv");
    }

    public void writeDesc(MCDataOutput out) {
    }

    public void readDesc(MCDataInput in) {
    }

    public void receiveUpdateFromServer(int key, MCDataInput input) {
    }

    public void receiveUpdateFromClient(int key, MCDataInput input, ServerPlayer player) {
        switch (key) {
            case 2: {
                this.writePlan();
                break;
            }
            case 3: {
                this.clearGrid(player);
                break;
            }
        }
    }

    public void sendWriteButtonPressed() {
        this.sendUpdateToServer(2, out -> {});
    }

    public void sendGridClearButtonPressed() {
        this.sendUpdateToServer(3, out -> {});
    }

    public InteractionResult onBlockActivated(Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.m_58904_().f_46443_) {
            ServerUtils.openContainer((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inv, p) -> new ProjectBenchContainer(inv, this, id), (Component)this.m_58900_().m_60734_().m_49954_()), p -> p.writePos(this.m_58899_()));
        }
        return InteractionResult.m_19078_((boolean)this.m_58904_().f_46443_);
    }

    public void onBlockRemoved() {
        Vector3 pos = Vector3.fromTileCenter((BlockEntity)this);
        ProjectBenchTile.dropInventory((Container)this.craftingGrid, (Level)this.m_58904_(), (Vector3)pos);
        ProjectBenchTile.dropInventory((Container)this.planInventory, (Level)this.m_58904_(), (Vector3)pos);
        ProjectBenchTile.dropInventory((Container)this.storageInventory, (Level)this.m_58904_(), (Vector3)pos);
    }

    public void tick() {
        this.updateRecipeIfNeeded();
        if (!this.m_58904_().f_46443_) {
            this.transferExcessToStorage();
        }
    }

    public void updateRecipeIfNeeded() {
        if (this.recipeNeedsUpdate) {
            ItemStack plan;
            this.recipeNeedsUpdate = false;
            this.isPlanRecipe = false;
            boolean gridEmpty = true;
            for (int i = 0; i < 9; ++i) {
                if (this.craftingGrid.m_8020_(i).m_41619_()) continue;
                gridEmpty = false;
                break;
            }
            if (gridEmpty && RecipePlanItem.hasRecipeInside(plan = this.planInventory.m_8020_(0))) {
                this.isPlanRecipe = true;
                RecipePlanItem.loadPlanInputsToGrid((Container)this.planCraftingGrid, plan);
            }
            this.craftingHelper.onInventoryChanged();
        }
    }

    private void onInventoryChanged(Container inventory) {
        this.recipeNeedsUpdate = true;
        this.m_6596_();
    }

    private void transferExcessToStorage() {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.craftingGrid.m_8020_(i);
            if (stack.m_41619_() || stack.m_41613_() <= 1) continue;
            int toMove = Math.max(1, stack.m_41613_() / 4);
            ItemStack removed = this.craftingGrid.m_7407_(i, toMove);
            InventoryLib.injectItemStack((Container)this.storageInventory, (ItemStack)removed, (boolean)false);
            if (removed.m_41619_()) continue;
            this.craftingGrid.m_8020_(i).m_41769_(removed.m_41613_());
            this.craftingGrid.m_6596_();
        }
    }

    private void writePlan() {
        this.updateRecipeIfNeeded();
        if (this.craftingHelper.hasRecipe() && !this.isPlanRecipe) {
            ItemStack planStack = this.planInventory.m_8020_(0);
            ItemStack result = this.craftingHelper.getRecipeOutout();
            if (!planStack.m_41619_() && !result.m_41619_()) {
                ItemStack[] inputs = new ItemStack[9];
                for (int i = 0; i < 9; ++i) {
                    inputs[i] = this.craftingGrid.m_8020_(i).m_41777_();
                }
                RecipePlanItem.savePlan(planStack, inputs, result);
            }
        }
    }

    private void clearGrid(ServerPlayer player) {
        AbstractContainerMenu container = player.f_36096_;
        if (container instanceof ProjectBenchContainer) {
            ((ProjectBenchContainer)container).transferAllFromGrid();
            this.updateRecipeIfNeeded();
        }
    }

    @Override
    public Container getCraftingMatrix() {
        return this.isPlanRecipe ? this.planCraftingGrid : this.craftingGrid;
    }

    @Override
    public Container getStorage() {
        return this.storageInventory;
    }

    @Override
    public boolean canConsumeFromCraftingMatrix() {
        return !this.isPlanRecipe;
    }

    @Override
    public Level getWorld() {
        return this.m_58904_();
    }

    public SimpleContainer getPlanInventory() {
        return this.planInventory;
    }

    public SimpleContainer getCraftingGridInventory() {
        return this.craftingGrid;
    }

    public SimpleContainer getStorageInventory() {
        return this.storageInventory;
    }

    public boolean isPlanRecipe() {
        return this.isPlanRecipe;
    }

    public CraftingHelper getCraftingHelper() {
        return this.craftingHelper;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.storageInventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.storageInventoryCap.invalidate();
    }

    private IItemHandler createStorageInventoryCap() {
        return new InvWrapper((Container)this.storageInventory);
    }
}

