/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import de.mrjulsen.trafficcraft.block.AsphaltSlope;
import de.mrjulsen.trafficcraft.block.PaintedAsphaltSlope;
import de.mrjulsen.trafficcraft.block.data.IPaintableBlock;
import de.mrjulsen.trafficcraft.block.data.RoadBlock;
import de.mrjulsen.trafficcraft.block.data.RoadType;
import de.mrjulsen.trafficcraft.item.BrushItem;
import de.mrjulsen.trafficcraft.registry.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;

public class AsphaltBlock
extends Block
implements IPaintableBlock {
    private RoadType defaultRoadType;

    public AsphaltBlock(RoadType type) {
        super(AsphaltBlock.properties(type));
        this.defaultRoadType = type;
    }

    public static BlockBehaviour.Properties properties(RoadType type) {
        BlockBehaviour.Properties props = BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60999_();
        switch (type) {
            case ASPHALT: {
                props.m_155949_(MaterialColor.f_76419_);
                break;
            }
            case CONCRETE: {
                props.m_155949_(MaterialColor.f_76407_);
                break;
            }
        }
        return props;
    }

    public RoadType getDefaultRoadType() {
        return this.defaultRoadType;
    }

    @Override
    public InteractionResult onSetColor(UseOnContext pContext) {
        Object id = "";
        Level level = pContext.m_43725_();
        BlockPos pos = pContext.m_8083_();
        BlockState state = pContext.m_43725_().m_8055_(pos);
        ItemStack stack = pContext.m_43722_();
        Player player = pContext.m_43723_();
        if (state.m_60734_() instanceof AsphaltSlope) {
            id = this.getDefaultRoadType().getRoadType() + "_slope_pattern_" + BrushItem.getPatternId(stack);
        } else if (state.m_60734_() instanceof AsphaltBlock) {
            id = this.getDefaultRoadType().getRoadType() + "_pattern_" + BrushItem.getPatternId(stack);
        }
        if (!ModBlocks.ROAD_BLOCKS.containsKey(id) || !(ModBlocks.ROAD_BLOCKS.get(id).get() instanceof RoadBlock)) {
            return InteractionResult.FAIL;
        }
        RoadBlock road = (RoadBlock)ModBlocks.ROAD_BLOCKS.get(id).get();
        BlockState newState = (BlockState)road.m_49966_().m_61124_((Property)RoadBlock.FACING, (Comparable)player.m_6350_());
        if (state.m_60734_() instanceof AsphaltSlope) {
            newState = (BlockState)newState.m_61124_((Property)PaintedAsphaltSlope.LAYERS, (Comparable)((Integer)state.m_61143_((Property)AsphaltSlope.LAYERS)));
        }
        level.m_46597_(pos, newState);
        road.onSetColor(pContext);
        return InteractionResult.CONSUME;
    }
}

