/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.block.data.ColorableBlock;
import de.mrjulsen.trafficcraft.block.data.IColorBlockEntity;
import de.mrjulsen.trafficcraft.block.entity.ColoredBlockEntity;
import de.mrjulsen.trafficcraft.data.PaintColor;
import de.mrjulsen.trafficcraft.item.BrushItem;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PaintBucketBlock
extends ColorableBlock
implements SimpleWaterloggedBlock {
    public static final int MAX_PAINT = 8;
    public static final IntegerProperty PAINT = IntegerProperty.m_61631_((String)"paint", (int)0, (int)8);
    public static final DirectionProperty DIRECTION = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape PAINT_BUCKET = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);

    public PaintBucketBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(2.0f).m_60955_().m_60918_(SoundType.f_56762_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)PAINT, (Comparable)Integer.valueOf(0))).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return PAINT_BUCKET;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{PAINT, DIRECTION, WATERLOGGED});
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return PaintBucketBlock.m_49863_((LevelReader)pLevel, (BlockPos)pPos.m_7495_(), (Direction)Direction.UP);
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)DIRECTION, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)DIRECTION)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)DIRECTION)));
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos pos = pContext.m_8083_();
        FluidState fluidState = pContext.m_43725_().m_6425_(pos);
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)PAINT, (Comparable)Integer.valueOf(0))).m_61124_((Property)DIRECTION, (Comparable)pContext.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            player.m_5661_((Component)TextUtils.translate((String)"block.trafficcraft.paint_bucket.message.underwater").m_130940_(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        if (!(level.m_7702_(pos) instanceof ColoredBlockEntity)) {
            return InteractionResult.FAIL;
        }
        IColorBlockEntity blockEntity = (IColorBlockEntity)level.m_7702_(pos);
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof BrushItem) {
            BrushItem item2 = (BrushItem)item;
            int paint = (Integer)state.m_61143_((Property)PAINT);
            if (paint <= 0) {
                if (!level.f_46443_) {
                    player.m_5661_((Component)TextUtils.translate((String)"block.trafficcraft.paint_bucket.message.empty").m_130940_(ChatFormatting.RED), true);
                }
                return InteractionResult.FAIL;
            }
            if (!stack.m_41782_()) {
                stack.m_41751_(BrushItem.checkNbt(stack));
            }
            if (stack.m_41783_().m_128451_("paint") < item2.getMaxPaint() && paint > 0 || stack.m_41783_().m_128451_("paint") == item2.getMaxPaint() && stack.m_41783_().m_128451_("color") != blockEntity.getColor().getIndex()) {
                if (!level.f_46443_) {
                    if (!player.m_7500_()) {
                        level.m_46597_(pos, (BlockState)state.m_61124_((Property)PAINT, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)PAINT) - 1)));
                    }
                    stack.m_41783_().m_128405_("paint", item2.getMaxPaint());
                    stack.m_41783_().m_128405_("color", blockEntity.getColor().getIndex());
                    level.m_5594_(player, pos, SoundEvents.f_11780_, SoundSource.BLOCKS, 0.8f, 1.0f);
                }
                return InteractionResult.SUCCESS;
            }
        } else {
            item = stack.m_41720_();
            if (item instanceof DyeItem) {
                DyeItem dye = (DyeItem)item;
                if ((Integer)state.m_61143_((Property)PAINT) > 0 && !blockEntity.getColor().equals((Object)PaintColor.getByDye(dye))) {
                    if (!level.f_46443_) {
                        player.m_5661_((Component)TextUtils.translate((String)"block.trafficcraft.paint_bucket.message.wrong_color").m_130940_(ChatFormatting.RED), true);
                    }
                    return InteractionResult.FAIL;
                }
                if ((Integer)state.m_61143_((Property)PAINT) >= 8) {
                    if (!level.f_46443_) {
                        player.m_5661_((Component)TextUtils.translate((String)"block.trafficcraft.paint_bucket.message.full").m_130940_(ChatFormatting.YELLOW), true);
                    }
                    return InteractionResult.FAIL;
                }
                if ((Integer)state.m_61143_((Property)PAINT) < 8) {
                    blockEntity.setColor(PaintColor.getByDye(dye));
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)PAINT, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)PAINT) + 1)));
                    if (!level.f_46443_) {
                        if (!player.m_7500_()) {
                            player.m_21120_(hand).m_41774_(1);
                        }
                        level.m_5594_(null, pos, SoundEvents.f_11783_, SoundSource.BLOCKS, 0.8f, 0.9f);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.FAIL;
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    @Override
    public void onRemoveColor(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
    }

    @Override
    public InteractionResult onSetColor(UseOnContext pContext) {
        return InteractionResult.SUCCESS;
    }
}

