/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import de.mrjulsen.trafficcraft.block.StreetLampBaseBlock;
import de.mrjulsen.trafficcraft.block.data.ITrafficPostLike;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StreetLightBlock
extends StreetLampBaseBlock {
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final BooleanProperty UP = PipeBlock.f_55152_;
    protected static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.f_55154_.entrySet().stream().collect(Util.m_137448_());
    protected static final VoxelShape SHAPE_BASE_SN = Block.m_49796_((double)5.0, (double)5.75, (double)3.0, (double)11.0, (double)9.3, (double)13.0);
    protected static final VoxelShape SHAPE_BASE_EW = Block.m_49796_((double)3.0, (double)5.75, (double)5.0, (double)13.0, (double)9.3, (double)11.0);
    protected static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)7.0);
    protected static final VoxelShape SHAPE_EAST = Block.m_49796_((double)9.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0, (double)16.0);
    protected static final VoxelShape SHAPE_WEST = Block.m_49796_((double)0.0, (double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0);
    protected static final VoxelShape SHAPE_UP = Block.m_49796_((double)7.0, (double)9.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);

    public StreetLightBlock() {
        super(StreetLampBaseBlock.LampType.SINGLE_LIGHT);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public VoxelShape m_7952_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return SHAPE_COMMON;
    }

    @Override
    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        VoxelShape shape;
        VoxelShape voxelShape = shape = pState.m_61143_((Property)FACING) == Direction.NORTH || pState.m_61143_((Property)FACING) == Direction.SOUTH ? SHAPE_BASE_SN : SHAPE_BASE_EW;
        if (Boolean.TRUE.equals(pState.m_61143_((Property)NORTH))) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_NORTH);
        }
        if (Boolean.TRUE.equals(pState.m_61143_((Property)EAST))) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_EAST);
        }
        if (Boolean.TRUE.equals(pState.m_61143_((Property)SOUTH))) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_SOUTH);
        }
        if (Boolean.TRUE.equals(pState.m_61143_((Property)WEST))) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_WEST);
        }
        if (Boolean.TRUE.equals(pState.m_61143_((Property)UP))) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_UP);
        }
        return shape;
    }

    @Override
    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        BlockState state = super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        return this.canConnect(pState, pFacing) ? (BlockState)state.m_61124_((Property)PROPERTY_BY_DIRECTION.get(pFacing), (Comparable)Boolean.valueOf(this.connectsTo(pState, pFacingState, pFacingState.m_60783_((BlockGetter)pLevel, pFacingPos, pFacing.m_122424_()), pFacing.m_122424_()))) : state;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Level blockgetter = pContext.m_43725_();
        BlockPos blockpos = pContext.m_8083_();
        BlockPos blockpos1 = blockpos.m_122012_();
        BlockPos blockpos2 = blockpos.m_122029_();
        BlockPos blockpos3 = blockpos.m_122019_();
        BlockPos blockpos4 = blockpos.m_122024_();
        BlockPos blockpos5 = blockpos.m_7494_();
        BlockState blockstate1 = blockgetter.m_8055_(blockpos1);
        BlockState blockstate2 = blockgetter.m_8055_(blockpos2);
        BlockState blockstate3 = blockgetter.m_8055_(blockpos3);
        BlockState blockstate4 = blockgetter.m_8055_(blockpos4);
        BlockState blockstate5 = blockgetter.m_8055_(blockpos5);
        BlockState newState = super.m_5573_(pContext);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)newState.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.connectsTo(newState, blockstate1, blockstate1.m_60783_((BlockGetter)blockgetter, blockpos1, Direction.SOUTH), Direction.SOUTH)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.connectsTo(newState, blockstate2, blockstate2.m_60783_((BlockGetter)blockgetter, blockpos2, Direction.WEST), Direction.WEST)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.connectsTo(newState, blockstate3, blockstate3.m_60783_((BlockGetter)blockgetter, blockpos3, Direction.NORTH), Direction.NORTH)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.connectsTo(newState, blockstate4, blockstate4.m_60783_((BlockGetter)blockgetter, blockpos4, Direction.EAST), Direction.EAST)))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(this.connectsTo(newState, blockstate5, blockstate5.m_60783_((BlockGetter)blockgetter, blockpos3, Direction.UP), Direction.UP)));
    }

    private boolean isSameBlock(BlockState pState) {
        return pState.m_60713_((Block)this);
    }

    public boolean connectsTo(BlockState pState, BlockState pTargetState, boolean pIsSideSolid, Direction pDirection) {
        boolean flag = this.isSameBlock(pTargetState);
        boolean canConnect = false;
        Block block = pTargetState.m_60734_();
        if (block instanceof ITrafficPostLike) {
            ITrafficPostLike postLike = (ITrafficPostLike)block;
            canConnect = postLike.canConnect(pTargetState, pDirection);
        }
        return !StreetLightBlock.m_152463_((BlockState)pTargetState) && (canConnect || pState.m_61143_((Property)FACING) == pDirection && pIsSideSolid) || flag;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{NORTH, SOUTH, WEST, EAST, UP});
    }

    @Override
    public boolean canAttach(BlockState pState, BlockPos pPos, Direction pDirection) {
        return false;
    }

    @Override
    public boolean canConnect(BlockState pState, Direction pDirection) {
        return pDirection != Direction.DOWN;
    }
}

