/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import de.mrjulsen.trafficcraft.block.WritableTrafficSign;
import de.mrjulsen.trafficcraft.block.data.ITrafficPostLike;
import de.mrjulsen.trafficcraft.block.data.TownSignVariant;
import de.mrjulsen.trafficcraft.block.entity.TownSignBlockEntity;
import de.mrjulsen.trafficcraft.client.ClientWrapper;
import de.mrjulsen.trafficcraft.item.BrushItem;
import de.mrjulsen.trafficcraft.item.WrenchItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TownSignBlock
extends WritableTrafficSign
implements ITrafficPostLike {
    private static final VoxelShape SHAPE_COMMON = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SHAPE_SOUTH = Shapes.m_83110_((VoxelShape)SHAPE_COMMON, (VoxelShape)Block.m_49796_((double)0.0, (double)4.0, (double)9.0, (double)16.0, (double)16.0, (double)9.5));
    private static final VoxelShape SHAPE_NORTH = Shapes.m_83110_((VoxelShape)SHAPE_COMMON, (VoxelShape)Block.m_49796_((double)0.0, (double)4.0, (double)6.5, (double)16.0, (double)16.0, (double)7.0));
    private static final VoxelShape SHAPE_EAST = Shapes.m_83110_((VoxelShape)SHAPE_COMMON, (VoxelShape)Block.m_49796_((double)9.0, (double)4.0, (double)0.0, (double)9.5, (double)16.0, (double)16.0));
    private static final VoxelShape SHAPE_WEST = Shapes.m_83110_((VoxelShape)SHAPE_COMMON, (VoxelShape)Block.m_49796_((double)6.5, (double)4.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0));
    public static final EnumProperty<TownSignVariant> VARIANT = EnumProperty.m_61587_((String)"variant", TownSignVariant.class);

    public TownSignBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(1.0f).m_60999_().m_60918_(SoundType.f_56762_));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(VARIANT, (Comparable)((Object)TownSignVariant.FRONT)));
    }

    @Override
    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((Direction)pState.m_61143_((Property)FACING)) {
            case NORTH: {
                return pState.m_61143_(VARIANT) == TownSignVariant.BOTH ? Shapes.m_83110_((VoxelShape)SHAPE_NORTH, (VoxelShape)SHAPE_SOUTH) : SHAPE_NORTH;
            }
            case SOUTH: {
                return pState.m_61143_(VARIANT) == TownSignVariant.BOTH ? Shapes.m_83110_((VoxelShape)SHAPE_NORTH, (VoxelShape)SHAPE_SOUTH) : SHAPE_SOUTH;
            }
            case EAST: {
                return pState.m_61143_(VARIANT) == TownSignVariant.BOTH ? Shapes.m_83110_((VoxelShape)SHAPE_EAST, (VoxelShape)SHAPE_WEST) : SHAPE_EAST;
            }
            case WEST: {
                return pState.m_61143_(VARIANT) == TownSignVariant.BOTH ? Shapes.m_83110_((VoxelShape)SHAPE_EAST, (VoxelShape)SHAPE_WEST) : SHAPE_WEST;
            }
        }
        return SHAPE_COMMON;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{VARIANT});
    }

    @Override
    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity;
        ETownSignSide editSide;
        Item item = pPlayer.m_150109_().m_36056_().m_41720_();
        if (item instanceof BrushItem) {
            return InteractionResult.FAIL;
        }
        switch ((TownSignVariant)((Object)pState.m_61143_(VARIANT))) {
            case BACK: {
                editSide = ETownSignSide.BACK;
                break;
            }
            case BOTH: {
                if (pHit.m_82434_() == pState.m_61143_((Property)FACING)) {
                    editSide = ETownSignSide.FRONT;
                    break;
                }
                if (pHit.m_82434_() == ((Direction)pState.m_61143_((Property)FACING)).m_122424_()) {
                    editSide = ETownSignSide.BACK;
                    break;
                }
                return InteractionResult.FAIL;
            }
            default: {
                editSide = ETownSignSide.FRONT;
            }
        }
        if (pLevel.f_46443_ && item instanceof WrenchItem && (blockEntity = pLevel.m_7702_(pPos)) instanceof TownSignBlockEntity) {
            TownSignBlockEntity blockEntity2 = (TownSignBlockEntity)blockEntity;
            if (!pPlayer.m_6144_()) {
                ClientWrapper.showTownSignScreen(blockEntity2, editSide);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new TownSignBlockEntity(pPos, pState);
    }

    @Override
    public boolean canAttach(BlockState pState, BlockPos pPos, Direction pDirection) {
        return pState.m_61143_(VARIANT) != TownSignVariant.BOTH && pDirection == ((Direction)pState.m_61143_((Property)FACING)).m_122424_();
    }

    public static enum ETownSignSide implements StringRepresentable
    {
        FRONT("front", 0),
        BACK("back", 1);

        private String side;
        private int index;

        private ETownSignSide(String variant, int index) {
            this.side = variant;
            this.index = index;
        }

        public String getSide() {
            return this.side;
        }

        public int getIndex() {
            return this.index;
        }

        public String getTranslationKey() {
            return String.format("gui.trafficcraft.town_sign.variant.%s", this.side);
        }

        public static ETownSignSide getSideByIndex(int index) {
            for (ETownSignSide shape : ETownSignSide.values()) {
                if (shape.getIndex() != index) continue;
                return shape;
            }
            return FRONT;
        }

        public String m_7912_() {
            return this.side;
        }
    }
}

