/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import de.mrjulsen.trafficcraft.block.data.ColorableBlock;
import de.mrjulsen.trafficcraft.block.data.ITrafficPostLike;
import de.mrjulsen.trafficcraft.block.data.TrafficLightColor;
import de.mrjulsen.trafficcraft.block.data.TrafficLightModel;
import de.mrjulsen.trafficcraft.block.data.TrafficLightTrigger;
import de.mrjulsen.trafficcraft.block.data.compat.TrafficLightDirection;
import de.mrjulsen.trafficcraft.block.data.compat.TrafficLightMode;
import de.mrjulsen.trafficcraft.block.data.compat.TrafficLightVariant;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightBlockEntity;
import de.mrjulsen.trafficcraft.client.ClientWrapper;
import de.mrjulsen.trafficcraft.item.BrushItem;
import de.mrjulsen.trafficcraft.item.WrenchItem;
import de.mrjulsen.trafficcraft.registry.ModBlockEntities;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TrafficLightBlock
extends ColorableBlock
implements SimpleWaterloggedBlock,
ITrafficPostLike {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<TrafficLightModel> MODEL = EnumProperty.m_61587_((String)"model", TrafficLightModel.class);
    @Deprecated
    public static final EnumProperty<TrafficLightVariant> VARIANT = EnumProperty.m_61587_((String)"variant", TrafficLightVariant.class);
    @Deprecated
    public static final EnumProperty<TrafficLightDirection> DIRECTION = EnumProperty.m_61587_((String)"direction", TrafficLightDirection.class);
    @Deprecated
    public static final EnumProperty<TrafficLightMode> MODE = EnumProperty.m_61587_((String)"mode", TrafficLightMode.class);
    public static final VoxelShape SHAPE_COMMON = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final Map<TrafficLightModel, Map<Direction, VoxelShape>> shapes = new HashMap<TrafficLightModel, Map<Direction, VoxelShape>>();

    public TrafficLightBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(5.0f).m_60999_().m_60918_(SoundType.f_56749_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(MODEL, (Comparable)((Object)TrafficLightModel.THREE_LIGHTS)));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(MODEL, (Comparable)((Object)TrafficLightModel.THREE_LIGHTS)));
    }

    public VoxelShape m_7952_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return SHAPE_COMMON;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Shapes.m_83110_((VoxelShape)SHAPE_COMMON, (VoxelShape)shapes.get(pState.m_61143_(MODEL)).get((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{WATERLOGGED, FACING, MODEL});
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack stack = pPlayer.m_150109_().m_36056_();
        Item item = stack.m_41720_();
        if (item instanceof BrushItem) {
            return InteractionResult.FAIL;
        }
        if (pLevel.f_46443_ && item instanceof WrenchItem) {
            if (!pPlayer.m_6144_()) {
                ClientWrapper.showTrafficLightConfigScreen(pLevel, pPos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof TrafficLightBlockEntity) {
            TrafficLightBlockEntity blockEntity2 = (TrafficLightBlockEntity)blockEntity;
            if (pLevel.m_46753_(pPos)) {
                if (blockEntity2.getSchedule().getTrigger() == TrafficLightTrigger.REDSTONE && !blockEntity2.isPowered()) {
                    blockEntity2.setPowered(true);
                    blockEntity2.startSchedule(true);
                }
            } else {
                blockEntity2.setPowered(false);
                if (blockEntity2.getSchedule().getTrigger() == TrafficLightTrigger.REDSTONE) {
                    blockEntity2.stopSchedule();
                }
            }
        }
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    private static int calcStateFlag(Collection<TrafficLightColor> colors) {
        int flag = 0;
        if (colors.contains((Object)TrafficLightColor.GREEN) || colors.contains((Object)TrafficLightColor.F1_F2_F3_F5)) {
            flag |= 1;
        }
        if (colors.contains((Object)TrafficLightColor.YELLOW) || colors.contains((Object)TrafficLightColor.F4)) {
            flag |= 2;
        }
        if (colors.contains((Object)TrafficLightColor.RED) || colors.contains((Object)TrafficLightColor.F0)) {
            flag |= 4;
        }
        return flag;
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (!(blockEntity instanceof TrafficLightBlockEntity)) {
            return 0;
        }
        TrafficLightBlockEntity be = (TrafficLightBlockEntity)blockEntity;
        int flag = TrafficLightBlock.calcStateFlag(be.getEnabledColors()) * 2;
        return flag;
    }

    @Override
    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Override
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new TrafficLightBlockEntity(pPos, pState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return TrafficLightBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.TRAFFIC_LIGHT_BLOCK_ENTITY.get()), TrafficLightBlockEntity::tick);
    }

    @Override
    public boolean canAttach(BlockState pState, BlockPos pPos, Direction pDirection) {
        return pDirection != pState.m_61143_((Property)FACING);
    }

    static {
        Arrays.stream(TrafficLightModel.values()).forEach(x -> {
            HashMap<Direction, VoxelShape> voxelShapes = new HashMap<Direction, VoxelShape>();
            voxelShapes.put(Direction.NORTH, Block.m_49796_((double)4.0, (double)x.getHitboxBottom(), (double)1.0, (double)12.0, (double)x.getHitboxTop(), (double)6.0));
            voxelShapes.put(Direction.SOUTH, Block.m_49796_((double)4.0, (double)x.getHitboxBottom(), (double)10.0, (double)12.0, (double)x.getHitboxTop(), (double)15.0));
            voxelShapes.put(Direction.EAST, Block.m_49796_((double)10.0, (double)x.getHitboxBottom(), (double)4.0, (double)15.0, (double)x.getHitboxTop(), (double)12.0));
            voxelShapes.put(Direction.WEST, Block.m_49796_((double)1.0, (double)x.getHitboxBottom(), (double)4.0, (double)6.0, (double)x.getHitboxTop(), (double)12.0));
            shapes.put((TrafficLightModel)x, (Map<Direction, VoxelShape>)voxelShapes);
        });
    }
}

