/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import de.mrjulsen.trafficcraft.block.data.ITrafficPostLike;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TrafficSignPostBlock
extends Block
implements SimpleWaterloggedBlock,
ITrafficPostLike {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final BooleanProperty UP = PipeBlock.f_55152_;
    public static final BooleanProperty DOWN = PipeBlock.f_55153_;
    public static final BooleanProperty EXTEND_BOTTOM = BooleanProperty.m_61465_((String)"bottom_extension");
    protected static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.f_55154_.entrySet().stream().collect(Util.m_137448_());
    private static final VoxelShape SHAPE_BASE = Block.m_49796_((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0);
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)7.0);
    private static final VoxelShape SHAPE_EAST = Block.m_49796_((double)9.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    private static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)0.0, (double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0);
    private static final VoxelShape SHAPE_UP = Block.m_49796_((double)7.0, (double)9.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SHAPE_DOWN = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)7.0, (double)9.0);
    private static final VoxelShape SHAPE_EXTEND_DOWN = Block.m_49796_((double)7.0, (double)-16.0, (double)7.0, (double)9.0, (double)0.0, (double)9.0);

    public TrafficSignPostBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(1.0f).m_60999_().m_60918_(SoundType.f_56762_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(AXIS, (Comparable)Direction.Axis.Y)).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EXTEND_BOTTOM, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        VoxelShape shape = SHAPE_BASE;
        if (!(pState.m_61143_(AXIS) != Direction.Axis.X || ((Boolean)pState.m_61143_((Property)NORTH)).booleanValue() || ((Boolean)pState.m_61143_((Property)SOUTH)).booleanValue() || ((Boolean)pState.m_61143_((Property)UP)).booleanValue() || ((Boolean)pState.m_61143_((Property)DOWN)).booleanValue())) {
            shape = Shapes.m_83124_((VoxelShape)shape, (VoxelShape[])new VoxelShape[]{SHAPE_EAST, SHAPE_WEST});
        } else if (!(pState.m_61143_(AXIS) != Direction.Axis.Z || ((Boolean)pState.m_61143_((Property)EAST)).booleanValue() || ((Boolean)pState.m_61143_((Property)WEST)).booleanValue() || ((Boolean)pState.m_61143_((Property)UP)).booleanValue() || ((Boolean)pState.m_61143_((Property)DOWN)).booleanValue())) {
            shape = Shapes.m_83124_((VoxelShape)shape, (VoxelShape[])new VoxelShape[]{SHAPE_NORTH, SHAPE_SOUTH});
        } else if (!(pState.m_61143_(AXIS) != Direction.Axis.Y || ((Boolean)pState.m_61143_((Property)EAST)).booleanValue() || ((Boolean)pState.m_61143_((Property)WEST)).booleanValue() || ((Boolean)pState.m_61143_((Property)NORTH)).booleanValue() || ((Boolean)pState.m_61143_((Property)SOUTH)).booleanValue())) {
            shape = Shapes.m_83124_((VoxelShape)shape, (VoxelShape[])new VoxelShape[]{SHAPE_UP, SHAPE_DOWN});
        } else {
            if (((Boolean)pState.m_61143_((Property)NORTH)).booleanValue()) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_NORTH);
            }
            if (((Boolean)pState.m_61143_((Property)EAST)).booleanValue()) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_EAST);
            }
            if (((Boolean)pState.m_61143_((Property)SOUTH)).booleanValue()) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_SOUTH);
            }
            if (((Boolean)pState.m_61143_((Property)WEST)).booleanValue()) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_WEST);
            }
            if (((Boolean)pState.m_61143_((Property)UP)).booleanValue()) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_UP);
            }
            if (((Boolean)pState.m_61143_((Property)DOWN)).booleanValue()) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_DOWN);
            }
        }
        if (((Boolean)pState.m_61143_((Property)EXTEND_BOTTOM)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_EXTEND_DOWN);
        }
        return shape;
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return TrafficSignPostBlock.rotatePillar(pState, pRot);
    }

    public static BlockState rotatePillar(BlockState pState, Rotation pRotation) {
        switch (pRotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)pState.m_61143_(AXIS)) {
                    case X: {
                        return (BlockState)pState.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        return (BlockState)pState.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                return pState;
            }
        }
        return pState;
    }

    private static boolean needsBottomExtension(BlockState pState, BlockState belowBlock) {
        return ((Direction.Axis)pState.m_61143_(AXIS)).test(Direction.UP) && (belowBlock.m_61138_((Property)BlockStateProperties.f_61417_) || belowBlock.m_60734_() instanceof SlabBlock && belowBlock.m_61143_((Property)BlockStateProperties.f_61397_) == SlabType.BOTTOM);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        BlockState belowBlock = pLevel.m_8055_(pCurrentPos.m_7495_());
        return (BlockState)((BlockState)pState.m_61124_((Property)PROPERTY_BY_DIRECTION.get(pFacing), (Comparable)Boolean.valueOf(this.connectsTo(pLevel, pCurrentPos, pState, pFacingState, pFacingState.m_60783_((BlockGetter)pLevel, pFacingPos, pFacing.m_122424_()), pFacing.m_122424_())))).m_61124_((Property)EXTEND_BOTTOM, (Comparable)Boolean.valueOf(TrafficSignPostBlock.needsBottomExtension(pState, belowBlock)));
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        Level blockgetter = pContext.m_43725_();
        BlockPos blockpos = pContext.m_8083_();
        BlockPos blockpos1 = blockpos.m_122012_();
        BlockPos blockpos2 = blockpos.m_122029_();
        BlockPos blockpos3 = blockpos.m_122019_();
        BlockPos blockpos4 = blockpos.m_122024_();
        BlockPos blockpos5 = blockpos.m_7494_();
        BlockPos blockpos6 = blockpos.m_7495_();
        BlockState blockstate1 = blockgetter.m_8055_(blockpos1);
        BlockState blockstate2 = blockgetter.m_8055_(blockpos2);
        BlockState blockstate3 = blockgetter.m_8055_(blockpos3);
        BlockState blockstate4 = blockgetter.m_8055_(blockpos4);
        BlockState blockstate5 = blockgetter.m_8055_(blockpos5);
        BlockState blockstate6 = blockgetter.m_8055_(blockpos6);
        BlockState newState = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).m_61124_(AXIS, (Comparable)pContext.m_43719_().m_122434_());
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)newState.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.connectsTo((LevelAccessor)pContext.m_43725_(), pContext.m_8083_(), newState, blockstate1, blockstate1.m_60783_((BlockGetter)blockgetter, blockpos1, Direction.SOUTH), Direction.SOUTH.m_122424_())))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.connectsTo((LevelAccessor)pContext.m_43725_(), pContext.m_8083_(), newState, blockstate2, blockstate2.m_60783_((BlockGetter)blockgetter, blockpos2, Direction.WEST), Direction.WEST.m_122424_())))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.connectsTo((LevelAccessor)pContext.m_43725_(), pContext.m_8083_(), newState, blockstate3, blockstate3.m_60783_((BlockGetter)blockgetter, blockpos3, Direction.NORTH), Direction.NORTH.m_122424_())))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.connectsTo((LevelAccessor)pContext.m_43725_(), pContext.m_8083_(), newState, blockstate4, blockstate4.m_60783_((BlockGetter)blockgetter, blockpos4, Direction.EAST), Direction.EAST.m_122424_())))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(this.connectsTo((LevelAccessor)pContext.m_43725_(), pContext.m_8083_(), newState, blockstate5, blockstate5.m_60783_((BlockGetter)blockgetter, blockpos3, Direction.DOWN), Direction.DOWN)))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(this.connectsTo((LevelAccessor)pContext.m_43725_(), pContext.m_8083_(), newState, blockstate6, blockstate6.m_60783_((BlockGetter)blockgetter, blockpos4, Direction.UP), Direction.UP)))).m_61124_((Property)EXTEND_BOTTOM, (Comparable)Boolean.valueOf(TrafficSignPostBlock.needsBottomExtension(newState, blockstate6)));
    }

    private boolean isSameBlock(BlockState pState) {
        return pState.m_60713_((Block)this);
    }

    public boolean connectsTo(LevelAccessor level, BlockPos pos, BlockState pState, BlockState pTargetState, boolean pIsSideSolid, Direction pDirection) {
        boolean flag = this.isSameBlock(pTargetState);
        boolean canConnect = false;
        Block block = pTargetState.m_60734_();
        if (block instanceof ITrafficPostLike) {
            ITrafficPostLike postLike = (ITrafficPostLike)block;
            canConnect = postLike.canConnect(pTargetState, pDirection);
        }
        return !TrafficSignPostBlock.m_152463_((BlockState)pTargetState) && (canConnect || ((Direction.Axis)pState.m_61143_(AXIS)).test(pDirection) && pIsSideSolid) || flag || pDirection == Direction.UP && TrafficSignPostBlock.needsBottomExtension(pState, pTargetState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{WATERLOGGED, AXIS, NORTH, SOUTH, WEST, EAST, UP, DOWN, EXTEND_BOTTOM});
    }

    @Override
    public boolean canAttach(BlockState pState, BlockPos pPos, Direction pDirection) {
        return pState.m_61143_(AXIS) == Direction.Axis.Y && (Boolean)pState.m_61143_((Property)EAST) == false && (Boolean)pState.m_61143_((Property)WEST) == false && (Boolean)pState.m_61143_((Property)NORTH) == false && (Boolean)pState.m_61143_((Property)SOUTH) == false || (Boolean)pState.m_61143_((Property)UP) != false;
    }

    @Override
    public boolean canConnect(BlockState pState, Direction pDirection) {
        return true;
    }
}

