/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block.data;

import de.mrjulsen.trafficcraft.registry.ModBlocks;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;

public enum RoadType implements StringRepresentable
{
    NONE("none", 0, -1),
    ASPHALT("asphalt", 1, -13159374),
    CONCRETE("concrete", 2, -4607065);

    private String roadType;
    private int index;
    private int color;

    private RoadType(String roadType, int index, int color) {
        this.roadType = roadType;
        this.index = index;
        this.color = color;
    }

    public String getRoadType() {
        return this.roadType;
    }

    public int getIndex() {
        return this.index;
    }

    public int getColor() {
        return this.color;
    }

    public String getTranslationKey() {
        return String.format("gui.trafficcraft.road.roadtype.%s", this.roadType);
    }

    public static RoadType getRoadTypeByIndex(int index) {
        for (RoadType controlType : RoadType.values()) {
            if (controlType.getIndex() != index) continue;
            return controlType;
        }
        return NONE;
    }

    public String m_7912_() {
        return this.roadType;
    }

    public Block getBlock() {
        switch (this.ordinal()) {
            default: {
                return (Block)ModBlocks.ASPHALT.get();
            }
            case 2: 
        }
        return (Block)ModBlocks.CONCRETE.get();
    }

    public Block getSlope() {
        switch (this.ordinal()) {
            default: {
                return (Block)ModBlocks.ASPHALT_SLOPE.get();
            }
            case 2: 
        }
        return (Block)ModBlocks.CONCRETE_SLOPE.get();
    }
}

