/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.client;

import de.mrjulsen.mcdragonlib.client.ber.BERCube;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.trafficcraft.block.data.TrafficLightColor;
import de.mrjulsen.trafficcraft.block.data.TrafficLightIcon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;

public class TrafficLightTextureManager {
    private static final TrafficLightBulbModel FALLBACK_MODEL = TrafficLightBulbModel.create(null);
    private static final String TEXTURE_PATH = "block/traffic_light";
    private static final List<TrafficLightBulbModel> models = new ArrayList<TrafficLightBulbModel>();

    public static ResourceLocation getResourceLocation(TrafficLightIcon icon, TrafficLightColor color) {
        return TrafficLightTextureManager.getResourceLocation(new TrafficLightTextureKey(icon, color));
    }

    public static ResourceLocation getResourceLocation(TrafficLightTextureKey key) {
        if (key.isOffState()) {
            return new ResourceLocation("trafficcraft", String.format("textures/%s/off.png", TEXTURE_PATH));
        }
        return new ResourceLocation("trafficcraft", String.format("textures/%s/%s_%s.png", TEXTURE_PATH, (key.getIcon().isApplicableToColor(key.getColor()) ? key.getIcon() : TrafficLightIcon.NONE).getName(), key.getColor().getName()));
    }

    public static Collection<ResourceLocation> getAllTextureLocations() {
        return models.stream().map(x -> x.getKey().getTextureLocation()).toList();
    }

    public static void render(BERGraphics<?> graphics, BlockEntity be, TrafficLightIcon icon, TrafficLightColor color, int packedLight) {
        TrafficLightTextureManager.render(graphics, be, new TrafficLightTextureKey(icon, color), packedLight);
    }

    public static void render(BERGraphics<?> graphics, BlockEntity be, TrafficLightTextureKey key, int packedLight) {
        models.stream().filter(x -> x.getKey().equals(key)).findFirst().orElse(FALLBACK_MODEL).render(graphics, be, packedLight);
    }

    static {
        Arrays.stream(TrafficLightIcon.values()).forEach(x -> Arrays.stream(TrafficLightColor.values()).filter(y -> x.isApplicableToColor((TrafficLightColor)((Object)((Object)y)))).forEach(y -> {
            TrafficLightTextureKey key = new TrafficLightTextureKey((TrafficLightIcon)x, (TrafficLightColor)((Object)((Object)y)));
            models.add(TrafficLightBulbModel.create(key));
        }));
    }

    public static class TrafficLightTextureKey {
        private final TrafficLightIcon icon;
        private final TrafficLightColor color;

        public TrafficLightTextureKey(TrafficLightIcon icon, TrafficLightColor color) {
            this.color = color;
            this.icon = icon.isApplicableToColor(color) ? icon : TrafficLightIcon.NONE;
        }

        public TrafficLightIcon getIcon() {
            return this.icon;
        }

        public TrafficLightColor getColor() {
            return this.color;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TrafficLightTextureKey) {
                TrafficLightTextureKey other = (TrafficLightTextureKey)obj;
                return this.getColor() == other.getColor() && this.getIcon() == other.getIcon();
            }
            return false;
        }

        public ResourceLocation getTextureLocation() {
            return TrafficLightTextureManager.getResourceLocation(this.getIcon(), this.getColor());
        }

        public void render(BERGraphics<?> graphics, BlockEntity be, int packedLight) {
            TrafficLightTextureManager.render(graphics, be, this, packedLight);
        }

        public boolean isOffState() {
            return this.getIcon() == TrafficLightIcon.NONE && this.getColor() == TrafficLightColor.NONE;
        }
    }

    private static class TrafficLightBulbModel {
        private static final float pixel = 0.0625f;
        private final TrafficLightTextureKey key;
        private final BERCube cube;

        private TrafficLightBulbModel(TrafficLightTextureKey key) {
            this.key = key;
            this.cube = key != null ? BERCube.cube((ResourceLocation)key.getTextureLocation(), (float)0.25f, (float)0.25f, (float)0.0625f, dir -> dir != Direction.NORTH && dir != Direction.UP, dir -> {
                switch (dir) {
                    case WEST: 
                    case EAST: {
                        return Pair.of((Object)new Vec2(0.0f, 0.0f), (Object)new Vec2(0.0625f, 1.0f));
                    }
                    case DOWN: 
                    case UP: {
                        return Pair.of((Object)new Vec2(0.0f, 0.0f), (Object)new Vec2(1.0f, 0.0625f));
                    }
                }
                return Pair.of((Object)new Vec2(0.0f, 0.0f), (Object)new Vec2(1.0f, 1.0f));
            }) : new BERCube(0.0f, 0.0f, 0.0f);
        }

        protected static final TrafficLightBulbModel create(TrafficLightTextureKey key) {
            return new TrafficLightBulbModel(key);
        }

        private void render(BERGraphics<?> graphics, BlockEntity be, int light) {
            graphics.poseStack().m_85836_();
            graphics.poseStack().m_85837_(0.0, 0.0, 0.0625);
            this.cube.setLight(this.key.isOffState() ? light : 0xF000F0);
            this.cube.render(graphics);
            graphics.poseStack().m_85849_();
        }

        private TrafficLightTextureKey getKey() {
            return this.key;
        }
    }
}

