/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.client;

import com.mojang.blaze3d.platform.NativeImage;
import de.mrjulsen.mcdragonlib.core.IIdentifiable;
import de.mrjulsen.mcdragonlib.util.ColorUtils;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.trafficcraft.TrafficCraft;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

public class TrafficSignTextureCacheClient {
    public static final HashMap<String, DynamicTexture> textureCache = new HashMap();
    public static final HashMap<String, DynamicTexture> backgroundTextureCache = new HashMap();

    public static <B extends IIdentifiable> DynamicTexture setTexture(B id, boolean hasBg, DynamicTexture texture) {
        TrafficSignTextureCacheClient.clear(id);
        textureCache.put(id.getId(), texture);
        if (texture != null && hasBg) {
            try {
                NativeImage bg = NativeImage.m_85058_((InputStream)((Resource)Minecraft.m_91087_().m_91098_().m_213713_(new ResourceLocation("trafficcraft", "textures/block/sign/blank.png")).get()).m_215507_());
                for (int x = 0; x < 32; ++x) {
                    for (int y = 0; y < 32; ++y) {
                        if (texture.m_117991_().m_84985_(x, y) != 0) continue;
                        bg.m_84988_(31 - x, y, 0);
                    }
                }
                backgroundTextureCache.put(id.getId(), new DynamicTexture(bg));
            }
            catch (IOException e) {
                TrafficCraft.LOGGER.error("Unable to set dynamic texture.", (Throwable)e);
                e.printStackTrace();
            }
        }
        return texture;
    }

    public static <B extends IIdentifiable> DynamicTexture generateTexture(B id, String base64, boolean hasBg) {
        try {
            NativeImage img = NativeImage.m_85060_((String)base64);
            DynamicTexture tex = new DynamicTexture(img);
            return TrafficSignTextureCacheClient.setTexture(id, hasBg, tex);
        }
        catch (IOException e) {
            TrafficCraft.LOGGER.error("Unable to generate dynamic texture.", (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    public static <B extends IIdentifiable> DynamicTexture getTexture(B id, String newTexture64, boolean hasBg, Consumer<DynamicTexture> onCreateNewTexture) {
        if (newTexture64 == null) {
            return null;
        }
        if (!textureCache.containsKey(id.getId())) {
            DynamicTexture tex = TrafficSignTextureCacheClient.generateTexture(id, newTexture64, hasBg);
            if (tex == null) {
                return null;
            }
            textureCache.put(id.getId(), tex);
            onCreateNewTexture.accept(tex);
        }
        return textureCache.get(id.getId());
    }

    public static <B extends IIdentifiable> DynamicTexture getBackground(B id) {
        if (!TrafficSignTextureCacheClient.hasBackground(id) || !backgroundTextureCache.containsKey(id.getId())) {
            return null;
        }
        return backgroundTextureCache.get(id.getId());
    }

    public static <B extends IIdentifiable> void clear(B id) {
        if (textureCache.containsKey(id.getId())) {
            textureCache.get(id.getId()).close();
            textureCache.remove(id.getId());
        }
        if (backgroundTextureCache.containsKey(id.getId())) {
            backgroundTextureCache.get(id.getId()).close();
            backgroundTextureCache.remove(id.getId());
        }
    }

    public static void clear(String id) {
        if (textureCache.containsKey(id)) {
            textureCache.get(id).close();
            textureCache.remove(id);
        }
        if (backgroundTextureCache.containsKey(id)) {
            backgroundTextureCache.get(id).close();
            backgroundTextureCache.remove(id);
        }
    }

    public static <B extends IIdentifiable> boolean hasBackground(B id) {
        return backgroundTextureCache.containsKey(id.getId());
    }

    public static <B extends IIdentifiable> String textureToBase64(B id) {
        return TrafficSignTextureCacheClient.textureToBase64(textureCache.get(id.getId()).m_117991_());
    }

    public static String textureToBase64(NativeImage image) {
        return DLUtils.textureToBase64((NativeImage)image);
    }

    public static <B extends IIdentifiable> int[][] textureToIntArray(B id, boolean flipRgb) {
        DynamicTexture tex = textureCache.get(id.getId());
        int[][] a = new int[tex.m_117991_().m_84982_()][];
        for (int x = 0; x < tex.m_117991_().m_84982_(); ++x) {
            a[x] = new int[tex.m_117991_().m_85084_()];
            for (int y = 0; y < tex.m_117991_().m_85084_(); ++y) {
                a[x][y] = flipRgb ? ColorUtils.swapRedBlue((int)tex.m_117991_().m_84985_(x, y)) : tex.m_117991_().m_84985_(x, y);
            }
        }
        return a;
    }
}

