/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.client.screen;

import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLItemButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLSlider;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.client.util.WidgetsCollection;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.core.Location;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.TrafficCraft;
import de.mrjulsen.trafficcraft.block.data.RoadType;
import de.mrjulsen.trafficcraft.config.ModCommonConfig;
import de.mrjulsen.trafficcraft.item.RoadConstructionTool;
import de.mrjulsen.trafficcraft.network.packets.cts.RoadBuilderBuildRoadPacket;
import de.mrjulsen.trafficcraft.network.packets.cts.RoadBuilderDataPacket;
import de.mrjulsen.trafficcraft.network.packets.cts.RoadBuilderResetPacket;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RoadConstructionToolScreen
extends DLScreen {
    public static final Component title = TextUtils.translate((String)"gui.trafficcraft.road_builder.title");
    private static final ResourceLocation GUI = new ResourceLocation("trafficcraft", "textures/gui/road_construction_tool.png");
    private static final int GUI_WIDTH = 244;
    private static final int GUI_HEIGHT = 179;
    private static final int WORKING_AREA_X = 7;
    private static final int WORKING_AREA_Y = 17;
    private static final int WORKING_AREA_WIDTH = 230;
    private static final int WORKING_AREA_HEIGHT = 155;
    private static final int WORKING_AREA_BOTTOM = 172;
    private static final int WORKING_AREA_RIGHT = 237;
    private int guiTop;
    private int guiLeft;
    private final WidgetsCollection itemButtonCollection = new WidgetsCollection();
    private DLSlider widthSlider;
    private DLButton buildButton;
    private GuiAreaDefinition pos1Area;
    private GuiAreaDefinition pos2Area;
    private GuiAreaDefinition buildButtonArea;
    private byte roadWidth;
    private boolean replaceExistingBlocks;
    private RoadType roadType = RoadType.ASPHALT;
    private final ItemStack stack;
    private final Location pos1;
    private final Location pos2;
    private int blocksCount;
    private int slopesCount;
    private final Component resetText = TextUtils.translate((String)"gui.trafficcraft.road_builder.reset");
    private final Component buildText = TextUtils.translate((String)"gui.trafficcraft.road_builder.build").m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.BOLD);
    private final Component replaceBlocksText = TextUtils.translate((String)"gui.trafficcraft.road_builder.replace_blocks");
    private final Component roadWidthText = TextUtils.translate((String)"gui.trafficcraft.road_builder.road_width");
    private final Component roadBlocksText = TextUtils.translate((String)"gui.trafficcraft.road_builder.road_blocks");
    private final Component requiredResourcesText = TextUtils.translate((String)"gui.trafficcraft.road_builder.required_resources");
    private final Component noPositionDefined = TextUtils.translate((String)"gui.trafficcraft.road_builder.no_pos_defined");
    private final Component tooltipPos1 = TextUtils.translate((String)"gui.trafficcraft.road_builder.tooltip.pos1");
    private final Component tooltipPos2 = TextUtils.translate((String)"gui.trafficcraft.road_builder.tooltip.pos2");
    private final Component tooltipReplaceBlocks = TextUtils.translate((String)"gui.trafficcraft.road_builder.tooltip.replace_blocks");
    private final Component tooltipReset = TextUtils.translate((String)"gui.trafficcraft.road_builder.tooltip.reset");
    private final Component tooltipBuild = TextUtils.translate((String)"gui.trafficcraft.road_builder.tooltip.build");
    private final Component tooltipBuildMissingPos = TextUtils.translate((String)"gui.trafficcraft.road_builder.tooltip.build_missing_pos");

    public RoadConstructionToolScreen(ItemStack stack, int blocksCount, int slopesCount) {
        super(title);
        if (!(stack.m_41720_() instanceof RoadConstructionTool)) {
            throw new IllegalArgumentException(stack.m_41611_().getString() + " is not a valid item for screen 'RoadBuilderToolScreen'.");
        }
        CompoundTag nbt = stack.m_41784_();
        this.pos1 = Location.fromNbt((CompoundTag)nbt.m_128469_("Location1"));
        this.pos2 = Location.fromNbt((CompoundTag)nbt.m_128469_("Location2"));
        this.roadWidth = nbt.m_128445_("RoadWidth");
        this.replaceExistingBlocks = nbt.m_128471_("ReplaceBlocks");
        this.roadType = RoadType.getRoadTypeByIndex(nbt.m_128451_("RoadType"));
        this.stack = stack;
        this.blocksCount = blocksCount;
        this.slopesCount = slopesCount;
    }

    public void m_7856_() {
        super.m_7856_();
        this.guiLeft = this.f_96543_ / 2 - 122;
        this.guiTop = this.f_96544_ / 2 - 89;
        this.itemButtonCollection.components.clear();
        this.pos1Area = new GuiAreaDefinition(this.guiLeft + 7, this.guiTop + 17, 114, 18);
        this.pos2Area = new GuiAreaDefinition(this.guiLeft + 123, this.guiTop + 17, 114, 18);
        int btnSpace = 76;
        int btnWidth = btnSpace - 2;
        this.addButton(this.guiLeft + 7 + btnSpace * 0, this.guiTop + 172 - 20, btnWidth, 20, this.resetText, p -> {
            TrafficCraft.net().sendToServer((Object)new RoadBuilderResetPacket());
            this.m_7379_();
        }, DLTooltip.of((FormattedText)this.tooltipReset).withMaxWidth(this.f_96543_ / 4));
        this.buildButton = this.addButton(this.guiLeft + 7 + btnSpace * 1 + 2, this.guiTop + 172 - 20, btnWidth, 20, this.buildText, p -> {
            this.updateStackData();
            CompoundTag nbt = this.stack.m_41784_();
            Location pos1 = Location.fromNbt((CompoundTag)nbt.m_128469_("Location1"));
            Location pos2 = Location.fromNbt((CompoundTag)nbt.m_128469_("Location2"));
            byte roadWidth = nbt.m_128445_("RoadWidth");
            boolean replaceBlocks = nbt.m_128471_("ReplaceBlocks");
            RoadType roadType = RoadType.getRoadTypeByIndex(nbt.m_128451_("RoadType"));
            TrafficCraft.net().sendToServer((Object)new RoadBuilderBuildRoadPacket(pos1, pos2, roadWidth, replaceBlocks, roadType));
            RoadConstructionTool.reset(this.stack);
            TrafficCraft.net().sendToServer((Object)new RoadBuilderResetPacket());
            this.onDone();
        }, null);
        this.buildButton.f_93623_ = this.pos1 != null && this.pos2 != null && this.roadWidth > 0;
        this.buildButtonArea = new GuiAreaDefinition(this.buildButton.f_93620_, this.buildButton.f_93621_, this.buildButton.m_5711_(), this.buildButton.m_93694_());
        this.addButton(this.guiLeft + 7 + btnSpace * 2 + 4, this.guiTop + 172 - 20, btnWidth, 20, CommonComponents.f_130655_, p -> this.onDone(), null);
        this.addOnOffButton(this.guiLeft + 7, this.guiTop + 38, 114, 20, this.replaceBlocksText, this.replaceExistingBlocks, (btn, value) -> {
            this.replaceExistingBlocks = value;
            if (this.pos1 != null && this.pos2 != null) {
                RoadConstructionTool.RoadBuilderCountResult res = RoadConstructionTool.countBlocksNeeded((Level)this.f_96541_.f_91073_, this.pos1.getLocationVec3(), this.pos2.getLocationVec3(), this.roadWidth, this.replaceExistingBlocks);
                this.blocksCount = res.blocksCount;
                this.slopesCount = res.slopesCount;
            }
        }, DLTooltip.of((FormattedText)this.tooltipReplaceBlocks).withMaxWidth(this.f_96543_ / 4));
        this.widthSlider = this.addSlider(this.guiLeft + 7 + 116, this.guiTop + 38, 114, 20, this.roadWidthText, (Component)TextUtils.text((String)""), 1.0, ((Integer)ModCommonConfig.ROAD_BUILDER_MAX_ROAD_WIDTH.get()).intValue(), 1.0, this.roadWidth, true, (slider, value) -> {
            this.roadWidth = value.byteValue();
            if (this.pos1 != null && this.pos2 != null) {
                RoadConstructionTool.RoadBuilderCountResult res = RoadConstructionTool.countBlocksNeeded((Level)this.f_96541_.f_91073_, this.pos1.getLocationVec3(), this.pos2.getLocationVec3(), this.roadWidth, this.replaceExistingBlocks);
                this.blocksCount = res.blocksCount;
                this.slopesCount = res.slopesCount;
            }
        }, null, null);
        int blocksWidth = 228;
        int buttonWidth = blocksWidth / (RoadType.values().length - 1);
        for (int i = 1; i < RoadType.values().length; ++i) {
            RoadType type = RoadType.values()[i];
            DLItemButton btn2 = (DLItemButton)this.m_142416_((GuiEventListener)((DLItemButton)new DLItemButton(DLAbstractImageButton.ButtonType.RADIO_BUTTON, DynamicGuiRenderer.AreaStyle.BROWN, new ItemStack((ItemLike)type.getBlock().m_5456_()), this.itemButtonCollection, this.guiLeft + 7 + 1 + buttonWidth * (i - 1), this.guiTop + 84, buttonWidth, 18, null, p -> {
                this.roadType = type;
            }).withAlignment(EAlignment.LEFT)));
            if (type != this.roadType) continue;
            btn2.select();
        }
        this.addTooltip(DLTooltip.of((FormattedText)this.tooltipPos1).assignedTo(this.pos1Area));
        this.addTooltip(DLTooltip.of((FormattedText)this.tooltipPos2).assignedTo(this.pos2Area));
    }

    private void updateStackData() {
        this.roadWidth = (byte)this.widthSlider.getValue();
        CompoundTag nbt = this.stack.m_41784_();
        nbt.m_128344_("RoadWidth", this.roadWidth);
        nbt.m_128379_("ReplaceBlocks", this.replaceExistingBlocks);
        nbt.m_128405_("RoadType", this.roadType.getIndex());
        TrafficCraft.net().sendToServer((Object)new RoadBuilderDataPacket(this.replaceExistingBlocks, this.roadWidth, this.roadType));
    }

    protected void onDone() {
        this.updateStackData();
        this.m_7379_();
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderScreenBackground(graphics);
        GuiUtils.drawTexture((ResourceLocation)GUI, (Graphics)graphics, (int)this.guiLeft, (int)this.guiTop, (int)0, (int)0, (int)244, (int)179);
        GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)(this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)title) / 2), (int)(this.guiTop + 6), (FormattedText)title, (int)-12566464, (EAlignment)EAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)(this.guiLeft + 7), (int)(this.guiTop + 73), (FormattedText)this.roadBlocksText, (int)-12566464, (EAlignment)EAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)(this.guiLeft + 7 + 3), (int)(this.guiTop + 107), (FormattedText)this.requiredResourcesText, (int)-96, (EAlignment)EAlignment.LEFT, (boolean)false);
        String pos1Text = this.pos1 == null ? this.noPositionDefined.getString() : String.format("%s, %s, %s", MathUtils.round((double)this.pos1.x, (int)2), MathUtils.round((double)this.pos1.y, (int)2), MathUtils.round((double)this.pos1.z, (int)2));
        String pos2Text = this.pos2 == null ? this.noPositionDefined.getString() : String.format("%s, %s, %s", MathUtils.round((double)this.pos2.x, (int)2), MathUtils.round((double)this.pos2.y, (int)2), MathUtils.round((double)this.pos2.z, (int)2));
        GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)(this.guiLeft + 7 + 57), (int)(this.guiTop + 22), (String)pos1Text, (int)(this.pos1 == null ? -2285022 : -11184811), (EAlignment)EAlignment.CENTER, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)(this.guiLeft + 7 + 116 + 57), (int)(this.guiTop + 22), (String)pos2Text, (int)(this.pos2 == null ? -2285022 : -11184811), (EAlignment)EAlignment.CENTER, (boolean)false);
        if (this.pos1 != null && this.pos2 != null) {
            String blockCountText = String.format("x %s", this.blocksCount);
            String slopeCountText = String.format("x %s", this.slopesCount);
            int blockDisplayWidth = 20 + this.f_96547_.m_92895_(blockCountText);
            int slopeDisplayWidth = 20 + this.f_96547_.m_92895_(slopeCountText);
            int guiCenter = this.guiLeft + 7 + 115;
            this.f_96541_.m_91291_().m_115203_(new ItemStack((ItemLike)this.roadType.getBlock()), guiCenter - 57 - blockDisplayWidth / 2, this.guiTop + 122);
            this.f_96541_.m_91291_().m_115203_(new ItemStack((ItemLike)this.roadType.getSlope()), guiCenter + 57 - slopeDisplayWidth / 2, this.guiTop + 122);
            GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)(guiCenter - 57 - blockDisplayWidth / 2 + 20), (int)(this.guiTop + 127), (String)blockCountText, (int)-2368549, (EAlignment)EAlignment.LEFT, (boolean)false);
            GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)(guiCenter + 57 - slopeDisplayWidth / 2 + 20), (int)(this.guiTop + 127), (String)slopeCountText, (int)-2368549, (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
        if (this.buildButtonArea.isInBounds((double)mouseX, (double)mouseY)) {
            if (this.pos1 == null || this.pos2 == null) {
                GuiUtils.renderTooltip((Screen)this, (GuiAreaDefinition)this.buildButtonArea, List.of(this.tooltipBuildMissingPos), (int)(this.f_96543_ / 4), (Graphics)graphics, (int)mouseX, (int)mouseY);
            } else {
                GuiUtils.renderTooltip((Screen)this, (AbstractWidget)this.buildButton, List.of(this.tooltipBuild), (int)(this.f_96543_ / 4), (Graphics)graphics, (int)mouseX, (int)mouseY);
            }
        }
    }
}

