/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.client.screen;

import com.mojang.blaze3d.platform.NativeImage;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLVerticalScrollBar;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.client.util.WidgetsCollection;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.block.data.TrafficSignShape;
import de.mrjulsen.trafficcraft.client.screen.TrafficSignWorkbenchGui;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class SignPickerScreen
extends DLScreen {
    public static final Component title = TextUtils.translate((String)"gui.trafficcraft.signpicker.title");
    public static final Component titleOpenFileDialog = TextUtils.translate((String)"gui.trafficcraft.signpicker.openfiledialog");
    public static final Component btnDoneText = TextUtils.translate((String)"gui.trafficcraft.signpicker.load");
    public static final Component tooltipImport = TextUtils.translate((String)"gui.trafficcraft.signpicker.tooltip.import");
    private static final int WIDTH = 187;
    private static final int HEIGHT = 171;
    private static final int MAX_ENTRIES_IN_ROW = 9;
    private static final int MAX_ROWS = 6;
    private static final int ICON_BUTTON_WIDTH = 18;
    private static final int ICON_BUTTON_HEIGHT = 18;
    private int guiLeft;
    private int guiTop;
    private DynamicTexture preview;
    private double scroll = 0.0;
    private final Screen lastScreen;
    private final TrafficSignShape shape;
    private final WidgetsCollection groupPatterns = new WidgetsCollection();
    private DLVerticalScrollBar scrollbar;
    private boolean updateScrollableContent = true;
    private DLButton doneButton;
    private final ResourceLocation[] resources;
    private final int count;
    private final Consumer<NativeImage> result;

    public SignPickerScreen(Screen lastScreen, TrafficSignShape shape, Consumer<NativeImage> result) {
        super(title);
        this.lastScreen = lastScreen;
        this.shape = shape;
        this.result = result;
        int i = 1;
        ResourceLocation path = new ResourceLocation("trafficcraft:textures/block/sign/" + shape.getShape() + "/" + shape.getShape() + i + ".png");
        ArrayList<ResourceLocation> locs = new ArrayList<ResourceLocation>();
        while (Minecraft.m_91087_().m_91098_().m_213713_(path).isPresent()) {
            locs.add(path);
            path = new ResourceLocation("trafficcraft:textures/block/sign/" + shape.getShape() + "/" + shape.getShape() + ++i + ".png");
        }
        this.resources = (ResourceLocation[])locs.toArray(ResourceLocation[]::new);
        this.count = this.resources.length;
    }

    public void m_7379_() {
        if (this.lastScreen != null) {
            this.f_96541_.m_91152_(this.lastScreen);
        } else {
            super.m_7379_();
        }
    }

    public void m_86600_() {
        this.doneButton.set_active(this.preview != null);
        super.m_86600_();
    }

    public void m_7856_() {
        super.m_7856_();
        this.guiLeft = this.f_96543_ / 2 - 93;
        this.guiTop = this.f_96544_ / 2 - 97;
        this.groupPatterns.components.clear();
        this.doneButton = this.addButton(this.guiLeft + 93 - 67 + 20, this.guiTop + 171 - 28, 65, 20, btnDoneText, p -> this.onDone(), null);
        this.addButton(this.guiLeft + 93 + 2 + 20, this.guiTop + 171 - 28, 65, 20, CommonComponents.f_130656_, p -> this.m_7379_(), null);
        DLIconButton btn = (DLIconButton)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.BROWN, TrafficSignWorkbenchGui.ButtonIcons.IMPORT.getSprite(), this.groupPatterns, this.guiLeft + 9, this.guiTop + 36 + 0, 18, 18, (Component)TextUtils.empty(), button -> {
            this.groupPatterns.performForEach(x -> ((DLIconButton)x).deselect());
            PointerBuffer filterPatterns = MemoryUtil.memAllocPointer((int)5);
            filterPatterns.put(MemoryUtil.memUTF8((CharSequence)"*.png"));
            filterPatterns.put(MemoryUtil.memUTF8((CharSequence)"*.jpg"));
            filterPatterns.put(MemoryUtil.memUTF8((CharSequence)"*.jpeg"));
            filterPatterns.put(MemoryUtil.memUTF8((CharSequence)"*.gif"));
            filterPatterns.put(MemoryUtil.memUTF8((CharSequence)"*.bmp"));
            filterPatterns.flip();
            this.f_96541_.m_91106_().m_120391_();
            String s = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)titleOpenFileDialog.getString(), (CharSequence)null, (PointerBuffer)filterPatterns, (CharSequence)"Image Files", (boolean)false);
            if (s != null) {
                try (InputStream data = DLUtils.scaleImage((InputStream)new FileInputStream(s), (int)32, (int)32);){
                    if (this.preview != null) {
                        this.preview.close();
                        this.preview = null;
                    }
                    NativeImage img = NativeImage.m_85058_((InputStream)data);
                    Arrays.stream(this.shape.getInvalidPixels()).forEach(c -> {
                        byte[] coords = DLUtils.intToCoords((int)c);
                        byte x = coords[0];
                        byte y = coords[1];
                        img.m_84988_((int)x, (int)y, 0);
                    });
                    this.preview = new DynamicTexture(img);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.f_96541_.m_91106_().m_120407_();
        }).withAlignment(EAlignment.CENTER);
        this.addTooltip(DLTooltip.of((FormattedText)tooltipImport).assignedTo((AbstractWidget)btn)).withMaxWidth(this.f_96543_ / 4);
        this.m_142416_((GuiEventListener)btn);
        int i = 0;
        while (i < this.count) {
            int j = i++;
            Sprite sprite = new Sprite(this.resources[j], 32, 32, 0, 0, 32, 32, 16, 16);
            DLIconButton btnImport = (DLIconButton)new DLIconButton(DLAbstractImageButton.ButtonType.RADIO_BUTTON, DynamicGuiRenderer.AreaStyle.BROWN, sprite, this.groupPatterns, this.guiLeft + 9, this.guiTop + 36 + j * 18, 18, 18, (Component)TextUtils.empty(), button -> {
                if (this.preview != null) {
                    this.preview.close();
                    this.preview = null;
                }
                try {
                    this.preview = new DynamicTexture(NativeImage.m_85058_((InputStream)((Resource)this.f_96541_.m_91098_().m_213713_(this.resources[j]).get()).m_215507_()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }).withAlignment(EAlignment.CENTER);
            this.m_142416_((GuiEventListener)btnImport);
        }
        this.scrollbar = (DLVerticalScrollBar)this.m_142416_((GuiEventListener)((DLVerticalScrollBar)((DLVerticalScrollBar)new DLVerticalScrollBar(this.guiLeft + 171, this.guiTop + 16, 8, 110, new GuiAreaDefinition(this.guiLeft + 7, this.guiTop + 16, 164, 110)).withOnValueChanged(v -> {
            this.scroll = v.getScrollValue();
            if (this.updateScrollableContent) {
                this.fillButtons((DLIconButton[])this.groupPatterns.components.toArray(DLIconButton[]::new), this.scroll, this.guiLeft + 8, this.guiTop + 17, this.scrollbar);
            }
            this.updateScrollableContent = true;
        })).setAutoScrollerSize(true)));
        this.fillButtons((DLIconButton[])this.groupPatterns.components.toArray(DLIconButton[]::new), this.scroll, this.guiLeft + 8, this.guiTop + 17, this.scrollbar);
    }

    protected void onDone() {
        NativeImage img = null;
        if (this.preview != null) {
            NativeImage image = this.preview.m_117991_();
            Arrays.stream(this.shape.getInvalidPixels()).forEach(c -> {
                byte[] coords = DLUtils.intToCoords((int)c);
                byte x = coords[0];
                byte y = coords[1];
                image.m_84988_((int)x, (int)y, 0);
            });
            img = image;
        }
        this.result.accept(img);
        this.m_7379_();
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderScreenBackground(graphics);
        DynamicGuiRenderer.renderWindow((Graphics)graphics, (int)this.guiLeft, (int)this.guiTop, (int)187, (int)171);
        DynamicGuiRenderer.renderArea((Graphics)graphics, (int)(this.guiLeft + 7), (int)(this.guiTop + 16), (int)164, (int)110, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.BROWN, (DynamicGuiRenderer.ButtonState)DynamicGuiRenderer.ButtonState.DOWN);
        GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)(this.guiLeft + 93), (int)(this.guiTop + 6), (FormattedText)title, (int)-12566464, (EAlignment)EAlignment.CENTER, (boolean)false);
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
        if (this.preview != null) {
            GuiUtils.drawTexture((int)this.preview.m_117963_(), (Graphics)graphics, (int)(this.guiLeft + 8), (int)(this.guiTop + 130), (int)32, (int)32, (int)0, (int)0, (int)32, (int)32, (int)32, (int)32);
        }
    }

    private void fillButtons(DLIconButton[] buttons, double scrollRow, int defX, int defY, DLVerticalScrollBar scrollbar) {
        if (buttons.length <= 0) {
            return;
        }
        int currentRow = -1;
        for (int i = 0; i < buttons.length; ++i) {
            if (i % 9 == 0) {
                ++currentRow;
            }
            buttons[i].set_x(defX + i % 9 * 18);
            buttons[i].set_y((int)((double)(defY + currentRow * 18) - scrollRow * 18.0));
            buttons[i].set_visible((double)currentRow >= scrollRow && (double)currentRow < scrollRow + 6.0);
        }
        if (scrollbar != null) {
            this.updateScrollableContent = false;
            ((DLVerticalScrollBar)scrollbar.setScreenSize(6)).setMaxScroll(currentRow + 1);
        }
    }
}

