/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLCycleButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLSlider;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import de.mrjulsen.trafficcraft.TrafficCraft;
import de.mrjulsen.trafficcraft.network.packets.cts.StreetLampConfigPacket;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class StreetLampScheduleScreen
extends DLScreen {
    public static final Component title = TextUtils.translate((String)"gui.trafficcraft.streetlampconfig.title");
    private int guiTop = 50;
    private static final int LINES = 3;
    private static final int SPACING_Y = 25;
    private static final int HEIGHT = 137;
    private int turnOnTime;
    private int turnOffTime;
    private TimeUtils.TimeFormat timeFormat = TimeUtils.TimeFormat.TICKS;
    protected DLSlider timeOnSlider;
    protected DLSlider timeOffSlider;
    protected DLCycleButton<TimeUtils.TimeFormat> timeFormatButton;
    private Component textTurnOnTime = TextUtils.translate((String)"gui.trafficcraft.streetlampconfig.turn_on_time");
    private Component textTurnOffTime = TextUtils.translate((String)"gui.trafficcraft.streetlampconfig.turn_off_time");
    private Component textTimeFormat = TextUtils.translate((String)"gui.trafficcraft.streetlampconfig.time_format");

    public StreetLampScheduleScreen(int timeOn, int timeOff, TimeUtils.TimeFormat format) {
        super(title);
        this.turnOnTime = timeOn;
        this.turnOffTime = timeOff;
        this.timeFormat = format;
    }

    public boolean m_7043_() {
        return true;
    }

    public void m_7856_() {
        super.m_7856_();
        this.guiTop = this.f_96544_ / 2 - 68;
        this.addButton(this.f_96543_ / 2 - 100, this.guiTop + 112, 97, 20, CommonComponents.f_130655_, p -> this.onDone(), null);
        this.addButton(this.f_96543_ / 2 + 3, this.guiTop + 112, 97, 20, CommonComponents.f_130656_, p -> this.m_7379_(), null);
        this.timeFormatButton = this.addCycleButton("dragonlib", TimeUtils.TimeFormat.class, this.f_96543_ / 2 - 100, this.guiTop + 25, 200, 20, this.textTimeFormat, (Enum)this.timeFormat, (btn, value) -> {
            this.timeFormat = value;
        }, DLTooltip.of((String)"dragonlib", TimeUtils.TimeFormat.class));
        this.timeOnSlider = this.addSlider(this.f_96543_ / 2 - 100, this.guiTop + 50, 200, 20, this.textTurnOnTime, (Component)TextUtils.text((String)""), 0.0, 23750.0, 250.0, this.turnOnTime, true, (slider, value) -> {
            this.turnOnTime = value.intValue();
        }, null, null);
        this.m_142416_((GuiEventListener)this.timeOnSlider);
        this.timeOffSlider = this.addSlider(this.f_96543_ / 2 - 100, this.guiTop + 75, 200, 20, this.textTurnOffTime, (Component)TextUtils.text((String)""), 0.0, 23750.0, 250.0, this.turnOffTime, true, (slider, value) -> {
            this.turnOffTime = value.intValue();
        }, null, null);
        this.m_142416_((GuiEventListener)this.timeOffSlider);
    }

    protected void onDone() {
        TrafficCraft.net().sendToServer((Object)new StreetLampConfigPacket(this.turnOnTime, this.turnOffTime, this.timeFormat));
        this.m_7379_();
    }

    private String getTimeSuffix(int value) {
        switch (value %= (int)DragonLib.ticksPerDay()) {
            case 0: {
                return "gui.trafficcraft.daytime.midnight";
            }
            case 6000: {
                return "gui.trafficcraft.daytime.morning";
            }
            case 12000: {
                return "gui.trafficcraft.daytime.noon";
            }
            case 18000: {
                return "gui.trafficcraft.daytime.evening";
            }
        }
        return null;
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_96558_(stack, 0);
        StreetLampScheduleScreen.m_93215_((PoseStack)stack, (Font)this.f_96547_, (Component)this.m_96636_(), (int)(this.f_96543_ / 2), (int)this.guiTop, (int)0xFFFFFF);
        String timeOnSuffix = this.getTimeSuffix(this.timeOnSlider.getValueInt());
        this.timeOnSlider.m_93666_((Component)TextUtils.text((String)(TextUtils.translate((String)"gui.trafficcraft.streetlampconfig.turn_on_time", (Object[])new Object[]{TimeUtils.parseTime((long)this.timeOnSlider.getValueInt(), (TimeUtils.TimeFormat)this.timeFormat)}).getString() + (String)(timeOnSuffix == null ? "" : " (" + TextUtils.translate((String)timeOnSuffix).getString() + ")"))));
        String timeOffSuffix = this.getTimeSuffix(this.timeOffSlider.getValueInt());
        this.timeOffSlider.m_93666_((Component)TextUtils.text((String)(TextUtils.translate((String)"gui.trafficcraft.streetlampconfig.turn_off_time", (Object[])new Object[]{TimeUtils.parseTime((long)this.timeOffSlider.getValueInt(), (TimeUtils.TimeFormat)this.timeFormat)}).getString() + (String)(timeOffSuffix == null ? "" : " (" + TextUtils.translate((String)timeOffSuffix).getString() + ")"))));
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
    }
}

