/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.client.screen;

import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLItemButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.TrafficCraft;
import de.mrjulsen.trafficcraft.block.data.TrafficLightTrigger;
import de.mrjulsen.trafficcraft.block.data.TrafficLightType;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightBlockEntity;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightControllerBlockEntity;
import de.mrjulsen.trafficcraft.client.widgets.TrafficLightScheduleContainer;
import de.mrjulsen.trafficcraft.data.TrafficLightSchedule;
import de.mrjulsen.trafficcraft.data.TrafficLightScheduleEntryData;
import de.mrjulsen.trafficcraft.network.packets.cts.TrafficLightSchedulePacket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TrafficLightScheduleEditor
extends DLScreen {
    public static final ResourceLocation WIDGETS = new ResourceLocation("trafficcraft", "textures/gui/traffic_light_schedule_icons.png");
    public static final int TEXTURE_WIDTH = 64;
    public static final int TEXTURE_HEIGHT = 64;
    public static final int WINDOW_WIDTH = 240;
    public static final int WINDOW_HEIGHT = 230;
    public static final int PADDING = 7;
    public static final int TOP_PADDING = 20;
    public static final int BOTTOM_PADDING = 30;
    public static final int SCROLLBAR_WIDTH = 8;
    public static final int ENTRY_PADDING = 8;
    public static final int DEFAULT_ENTRY_HEIGHT = 18;
    public static final int TIMELINE_UW = 9;
    public static final int TIMELINE_VH = 9;
    public static final int ENTRY_TIMELINE_COLUMN_WIDTH = 20;
    private static final int HEADER_BUTTON_COUNT = 2;
    private int guiLeft;
    private int guiTop;
    private GuiAreaDefinition areaHeader;
    private GuiAreaDefinition areaWorkspace;
    private TrafficLightScheduleContainer container;
    private final Screen last;
    private final Map<Integer, TrafficLightType> phaseIdTypes = new HashMap<Integer, TrafficLightType>();
    private final BlockPos pos;
    private final Level level;
    private final boolean isController;
    private final TrafficLightSchedule schedule;
    private static final Component textAddEntry = TextUtils.translate((String)"gui.trafficcraft.trafficlightschedule.add_entry");
    private static final String textLoop = TextUtils.translate((String)"gui.trafficcraft.trafficlightschedule.loop").getString();

    protected TrafficLightScheduleEditor(Screen last, Level level, BlockPos pos) {
        super((Component)TextUtils.translate((String)"gui.trafficcraft.trafficlightschedule.title"));
        BlockEntity blockEntity;
        this.last = last;
        this.pos = pos;
        this.level = level;
        this.isController = this.isController();
        this.schedule = this.getSchedule().copy();
        if (this.isController()) {
            BlockEntity blockEntity2 = level.m_7702_(pos);
            if (blockEntity2 instanceof TrafficLightControllerBlockEntity) {
                TrafficLightControllerBlockEntity blockEntity3 = (TrafficLightControllerBlockEntity)blockEntity2;
                blockEntity3.getTrafficLightLocations().stream().filter(x -> level.m_46749_(x.getLocationBlockPos()) && level.m_7702_(x.getLocationBlockPos()) instanceof TrafficLightBlockEntity).map(x -> (TrafficLightBlockEntity)level.m_7702_(x.getLocationBlockPos())).forEach(x -> {
                    int phaseId = x.getPhaseId();
                    TrafficLightType type = x.getTLType();
                    if (this.phaseIdTypes.containsKey(phaseId)) {
                        TrafficLightType savedType = this.phaseIdTypes.get(phaseId);
                        if (savedType != null && savedType != type) {
                            this.phaseIdTypes.remove(phaseId);
                            this.phaseIdTypes.put(phaseId, type);
                        }
                    } else {
                        this.phaseIdTypes.put(phaseId, type);
                    }
                });
            }
        } else if (level.m_46749_(pos) && (blockEntity = level.m_7702_(pos)) instanceof TrafficLightBlockEntity) {
            TrafficLightBlockEntity blockEntity4 = (TrafficLightBlockEntity)blockEntity;
            this.phaseIdTypes.put(0, blockEntity4.getTLType());
        }
    }

    private boolean isController() {
        return this.level.m_7702_(this.pos) instanceof TrafficLightControllerBlockEntity;
    }

    private TrafficLightSchedule getSchedule() {
        BlockEntity blockEntity;
        if (this.isController && (blockEntity = this.level.m_7702_(this.pos)) instanceof TrafficLightControllerBlockEntity) {
            TrafficLightControllerBlockEntity blockEntity2 = (TrafficLightControllerBlockEntity)blockEntity;
            return blockEntity2.getFirstOrMainSchedule();
        }
        blockEntity = this.level.m_7702_(this.pos);
        if (blockEntity instanceof TrafficLightBlockEntity) {
            TrafficLightBlockEntity blockEntity3 = (TrafficLightBlockEntity)blockEntity;
            return blockEntity3.getSchedule();
        }
        return new TrafficLightSchedule();
    }

    public Map<Integer, TrafficLightType> getPhaseTypes() {
        return this.phaseIdTypes;
    }

    public void m_7379_() {
        if (this.last != null) {
            Minecraft.m_91087_().m_91152_(this.last);
            return;
        }
        super.m_7379_();
    }

    protected void onDone() {
        super.onDone();
        TrafficCraft.net().sendToServer((Object)new TrafficLightSchedulePacket(this.pos, List.of(this.schedule)));
        this.m_7379_();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft = this.f_96543_ / 2 - 120;
        this.guiTop = this.f_96544_ / 2 - 115;
        this.areaHeader = new GuiAreaDefinition(this.guiLeft + 7, this.guiTop + 20, 226, 20);
        this.areaWorkspace = new GuiAreaDefinition(this.guiLeft + 7, this.guiTop + 20 + this.areaHeader.getHeight(), 226, 210 - this.areaHeader.getHeight() - 30);
        int headerW = (this.areaHeader.getWidth() - 2) / 2;
        DLItemButton bt = (DLItemButton)this.m_142416_((GuiEventListener)((DLItemButton)new DLItemButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.BROWN, this.schedule.getTrigger().getIconStack(), this.areaHeader.getLeft() + 1, this.areaHeader.getTop() + 1, headerW, this.areaHeader.getHeight() - 2, (Component)TextUtils.translate((String)this.schedule.getTrigger().getValueTranslationKey("trafficcraft")), btn -> {
            DLItemButton ibtn = btn;
            this.schedule.setTrigger((TrafficLightTrigger)this.schedule.getTrigger().next());
            ibtn.withItem(this.schedule.getTrigger().getIconStack());
            btn.m_93666_((Component)TextUtils.translate((String)this.schedule.getTrigger().getValueTranslationKey("trafficcraft")));
        }).withAlignment(EAlignment.LEFT)).withDefaultItemTooltip(false));
        this.addTooltip(DLTooltip.of((String)"trafficcraft", TrafficLightTrigger.class).withMaxWidth(this.f_96543_ / 4).assignedTo((AbstractWidget)bt));
        this.m_142416_((GuiEventListener)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.BROWN, Sprite.empty(), null, this.areaHeader.getLeft() + 1 + headerW, this.areaHeader.getTop() + 1, headerW, this.areaHeader.getHeight() - 2, (Component)TextUtils.text((String)(textLoop + ": " + (this.schedule.isLoop() ? CommonComponents.f_130653_.getString() : CommonComponents.f_130654_.getString()))), btn -> {
            this.schedule.setLoop(!this.schedule.isLoop());
            btn.m_93666_((Component)TextUtils.text((String)(textLoop + ": " + (this.schedule.isLoop() ? CommonComponents.f_130653_.getString() : CommonComponents.f_130654_.getString()))));
        }));
        this.addButton(this.guiLeft + 7, this.guiTop + 230 - 7 - 20, 20, 20, (Component)TextUtils.text((String)"+"), btn -> this.createNewEntry(), DLTooltip.of((FormattedText)textAddEntry));
        this.addButton(this.guiLeft + 240 - 7 - 90, this.guiTop + 230 - 7 - 20, 90, 20, CommonComponents.f_130656_, btn -> this.m_7379_(), null);
        this.addButton(this.guiLeft + 240 - 7 - 180 - 4, this.guiTop + 230 - 7 - 20, 90, 20, CommonComponents.f_130655_, btn -> this.onDone(), null);
        this.container = (TrafficLightScheduleContainer)this.m_142416_((GuiEventListener)new TrafficLightScheduleContainer(this.schedule, this.isController(), this.getPhaseTypes(), this.areaWorkspace.getX(), this.areaWorkspace.getY(), this.areaWorkspace.getWidth(), this.areaWorkspace.getHeight()));
    }

    private void createNewEntry() {
        this.schedule.getEntries().add(new TrafficLightScheduleEntryData());
        this.container.init();
    }

    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderScreenBackground(graphics);
        DynamicGuiRenderer.renderWindow((Graphics)graphics, (int)this.guiLeft, (int)this.guiTop, (int)240, (int)230);
        DynamicGuiRenderer.renderArea((Graphics)graphics, (GuiAreaDefinition)this.areaHeader, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.GRAY, (DynamicGuiRenderer.ButtonState)DynamicGuiRenderer.ButtonState.DISABLED);
        GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)(this.f_96543_ / 2), (int)(this.guiTop + 7), (FormattedText)this.f_96539_, (int)-12566464, (EAlignment)EAlignment.CENTER, (boolean)false);
        super.renderMainLayer(graphics, pMouseX, pMouseY, pPartialTick);
    }
}

