/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.client.screen;

import com.mojang.blaze3d.platform.NativeImage;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLVerticalScrollBar;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.client.util.WidgetsCollection;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.TrafficCraft;
import de.mrjulsen.trafficcraft.block.data.TrafficSignShape;
import de.mrjulsen.trafficcraft.data.NamedTrafficSignTextureReference;
import de.mrjulsen.trafficcraft.data.TrafficSignClientTexture;
import de.mrjulsen.trafficcraft.data.TrafficSignTextureMetadata;
import de.mrjulsen.trafficcraft.item.CreativePatternCatalogueItem;
import de.mrjulsen.trafficcraft.item.PatternCatalogueItem;
import de.mrjulsen.trafficcraft.network.packets.cts.CreativePatternCataloguePacket;
import de.mrjulsen.trafficcraft.network.packets.cts.PatternCatalogueIndexPacket;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class TrafficSignPatternSelectionScreen
extends DLScreen {
    public static final Component title = TextUtils.translate((String)"gui.trafficcraft.patternselection.title");
    private static final int WIDTH = 158;
    private static final int HEIGHT = 200;
    private static final int TEXTURE_WIDTH = 158;
    private static final int TEXTURE_HEIGHT = 174;
    private static final int MAX_ENTRIES_IN_ROW = 6;
    private static final int MAX_ROWS = 6;
    private static final int ICON_BUTTON_WIDTH = 18;
    private static final int ICON_BUTTON_HEIGHT = 18;
    private static final int BOOKMARK_U = 158;
    private static final int BOOKMARK_V_UNSELECTED_LEFT = 0;
    private static final int BOOKMARK_V_SELECTED_LEFT = 20;
    private static final int BOOKMARK_V_UNSELECTED_RIGHT = 40;
    private static final int BOOKMARK_V_SELECTED_RIGHT = 60;
    private static final int BOOKMARK_HEIGHT = 20;
    private static final int BOOKMARK_WIDTH = 44;
    private static final int BOOKMARK_SPACING = 2;
    private static final int BOOKMARK_COUNT_PER_SIDE = 6;
    private static final int BOOKMARK_Y_START = 17;
    private static final int BOOKMARK_X_LEFT = -33;
    private static final int BOOKMARK_X_RIGHT = 142;
    private final WidgetsCollection groupPatterns = new WidgetsCollection();
    private DLVerticalScrollBar scrollbar;
    private boolean updateScrollableContent = true;
    private int guiTop;
    private int guiLeft;
    private final Map<NamedTrafficSignTextureReference, TrafficSignClientTexture> cachedTextures = new HashMap<NamedTrafficSignTextureReference, TrafficSignClientTexture>();
    private final TrafficSignShape[] bookmarks = new TrafficSignShape[]{TrafficSignShape.CIRCLE, TrafficSignShape.TRIANGLE, TrafficSignShape.SQUARE, TrafficSignShape.DIAMOND, TrafficSignShape.RECTANGLE, TrafficSignShape.MISC};
    private int selectedBookmark = this.bookmarks.length;
    private double scroll = 0.0;
    private int selectedIndex;
    private final ItemStack stack;
    private final boolean creative;
    private static final ResourceLocation OVERLAY = new ResourceLocation("trafficcraft", "textures/gui/traffic_sign_workbench_overlay.png");

    public TrafficSignPatternSelectionScreen(ItemStack stack) {
        super(title);
        if (!(stack.m_41720_() instanceof PatternCatalogueItem)) {
            throw new IllegalStateException("ItemStack is no PatternCatalogueItem.");
        }
        this.stack = stack;
        this.creative = stack.m_41720_() instanceof CreativePatternCatalogueItem;
        this.selectedBookmark = stack.m_41720_() instanceof CreativePatternCatalogueItem && CreativePatternCatalogueItem.shouldUseCustomPattern(stack) ? 0 : this.bookmarks.length;
        this.selectedIndex = PatternCatalogueItem.getSelectedIndex(stack);
    }

    public boolean m_7043_() {
        return true;
    }

    public void m_7379_() {
        if (this.selectedBookmark >= this.bookmarks.length) {
            TrafficCraft.net().sendToServer((Object)new PatternCatalogueIndexPacket(PatternCatalogueItem.getSelectedIndex(this.stack)));
        } else {
            NamedTrafficSignTextureReference data = CreativePatternCatalogueItem.getCustomImage(this.stack);
            if (data != null) {
                TrafficCraft.net().sendToServer((Object)new CreativePatternCataloguePacket(data));
            }
        }
        this.cachedTextures.values().forEach(x -> x.close());
        super.m_7379_();
    }

    public void m_7856_() {
        super.m_7856_();
        this.guiLeft = this.f_96543_ / 2 - 79;
        this.guiTop = this.f_96544_ / 2 - 100;
        this.scroll = 0.0;
        this.groupPatterns.components.clear();
        if (this.selectedBookmark >= this.bookmarks.length) {
            int count = PatternCatalogueItem.getStoredPatternCount(this.stack);
            int i = 0;
            while (i < count) {
                final int j = i++;
                DLIconButton btn = (DLIconButton)new DLIconButton(DLAbstractImageButton.ButtonType.RADIO_BUTTON, DynamicGuiRenderer.AreaStyle.BROWN, Sprite.empty(), this.groupPatterns, this.guiLeft + 9, this.guiTop + 36 + j * 18, 18, 18, null, button -> {
                    PatternCatalogueItem.setSelectedIndex(this.stack, j);
                    if (this.stack.m_41720_() instanceof CreativePatternCatalogueItem) {
                        CreativePatternCatalogueItem.clearCustomImage(this.stack);
                    }
                }){

                    public void renderImage(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
                        NamedTrafficSignTextureReference data = PatternCatalogueItem.getPatternAt(TrafficSignPatternSelectionScreen.this.stack, j);
                        TrafficSignClientTexture tex = TrafficSignPatternSelectionScreen.this.cachedTextures.computeIfAbsent(data, x -> TrafficSignClientTexture.load(data.getTextureId(), false));
                        GuiUtils.drawTexture((ResourceLocation)tex.getTextureLocation(), (Graphics)graphics, (int)(this.f_93620_ + 1), (int)(this.f_93621_ + 1), (int)16, (int)16, (int)0, (int)0, (int)tex.getRawData().getWidth(), (int)tex.getRawData().getHeight(), (int)tex.getRawData().getWidth(), (int)tex.getRawData().getHeight());
                    }
                }.withAlignment(EAlignment.CENTER);
                this.addTooltip(DLTooltip.of((FormattedText)TextUtils.text((String)PatternCatalogueItem.getPatternAt(this.stack, j).getName())).assignedTo((AbstractWidget)btn));
                this.m_142416_((GuiEventListener)btn);
            }
        } else {
            TrafficSignShape[] shapes;
            TrafficSignShape[] trafficSignShapeArray;
            if (this.bookmarks[this.selectedBookmark] == TrafficSignShape.MISC) {
                trafficSignShapeArray = (TrafficSignShape[])Arrays.stream(TrafficSignShape.values()).filter(x -> !Arrays.stream(this.bookmarks).anyMatch(y -> x == y) || x == TrafficSignShape.MISC).toArray(TrafficSignShape[]::new);
            } else {
                TrafficSignShape[] trafficSignShapeArray2 = new TrafficSignShape[1];
                trafficSignShapeArray = trafficSignShapeArray2;
                trafficSignShapeArray2[0] = this.bookmarks[this.selectedBookmark];
            }
            for (TrafficSignShape shape : shapes = trafficSignShapeArray) {
                int a = 1;
                ResourceLocation path = new ResourceLocation("trafficcraft:textures/block/sign/" + shape.getShape() + "/" + shape.getShape() + a + ".png");
                ArrayList<TrafficSignTextureMetadata> locs = new ArrayList<TrafficSignTextureMetadata>();
                while (Minecraft.m_91087_().m_91098_().m_213713_(path).isPresent()) {
                    short width = 32;
                    short height = 32;
                    try (NativeImage img = NativeImage.m_85058_((InputStream)((Resource)this.f_96541_.m_91098_().m_213713_(path).get()).m_215507_());){
                        width = (short)img.m_84982_();
                        height = (short)img.m_85084_();
                    }
                    catch (IOException e) {
                        TrafficCraft.LOGGER.warn("Unable to determine texture size.", (Throwable)e);
                    }
                    locs.add(new TrafficSignTextureMetadata(path, shape, a, width, height));
                    path = new ResourceLocation("trafficcraft:textures/block/sign/" + shape.getShape() + "/" + shape.getShape() + ++a + ".png");
                }
                int count = locs.size();
                int i = 0;
                while (i < count) {
                    int j = i++;
                    Sprite sprite = new Sprite(((TrafficSignTextureMetadata)locs.get(j)).location(), 32, 32, 0, 0, 32, 32, 16, 16);
                    DLIconButton btn = (DLIconButton)new DLIconButton(DLAbstractImageButton.ButtonType.RADIO_BUTTON, DynamicGuiRenderer.AreaStyle.BROWN, sprite, this.groupPatterns, this.guiLeft + 9, this.guiTop + 36 + j * 18, 18, 18, null, button -> {
                        CreativePatternCatalogueItem.setCustomImage(this.stack, NamedTrafficSignTextureReference.ofBuildIn("", new NamedTrafficSignTextureReference.BuildInTrafficSignCodec(((TrafficSignTextureMetadata)locs.get(j)).shape(), ((TrafficSignTextureMetadata)locs.get(j)).id(), ((TrafficSignTextureMetadata)locs.get(j)).width(), ((TrafficSignTextureMetadata)locs.get(j)).height())));
                        this.selectedIndex = j;
                    }).withAlignment(EAlignment.CENTER);
                    this.m_142416_((GuiEventListener)btn);
                }
            }
        }
        this.scrollbar = (DLVerticalScrollBar)((DLVerticalScrollBar)((DLVerticalScrollBar)this.m_142416_((GuiEventListener)new DLVerticalScrollBar(this.guiLeft + 79 + 54, this.guiTop + 45 - 1, 8, 110, new GuiAreaDefinition(this.guiLeft + 79 - 54, this.guiTop + 45, 108, 108)))).setAutoScrollerSize(true)).withOnValueChanged(scrollbar -> {
            this.scroll = scrollbar.getScrollValue();
            if (this.updateScrollableContent) {
                this.fillButtons((DLIconButton[])this.groupPatterns.components.toArray(DLIconButton[]::new), this.scroll, this.guiLeft + 79 - 54 - 1, this.guiTop + 45, this.scrollbar);
            }
            this.updateScrollableContent = true;
        });
        this.scrollbar.f_93624_ = this.groupPatterns.components.size() > 36;
        this.fillButtons((DLIconButton[])this.groupPatterns.components.toArray(DLIconButton[]::new), this.scroll, this.guiLeft + 79 - 54 - 1, this.guiTop + 45, this.scrollbar);
    }

    private void fillButtons(DLIconButton[] buttons, double scrollRow, int defX, int defY, DLVerticalScrollBar scrollbar) {
        if (buttons.length <= 0) {
            return;
        }
        int currentRow = -1;
        for (int i = 0; i < buttons.length; ++i) {
            if (i % 6 == 0) {
                ++currentRow;
            }
            buttons[i].set_x(defX + i % 6 * 18);
            buttons[i].set_y((int)((double)(defY + currentRow * 18) - scrollRow * 18.0));
            buttons[i].set_visible((double)currentRow >= scrollRow && (double)currentRow < scrollRow + 6.0);
        }
        if (scrollbar != null) {
            this.updateScrollableContent = false;
            ((DLVerticalScrollBar)scrollbar.setScreenSize(6)).setMaxScroll(currentRow + 1);
        }
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderScreenBackground(graphics);
        GuiUtils.drawTexture((ResourceLocation)OVERLAY, (Graphics)graphics, (int)this.guiLeft, (int)(this.guiTop + 26), (int)158, (int)174, (int)0, (int)0, (int)158, (int)174, (int)256, (int)256);
        if (this.creative) {
            int bookY = this.guiTop + 26;
            int bookmarkIndex = 0;
            for (TrafficSignShape shape : this.bookmarks) {
                bookmarkIndex = this.addBookmark(graphics, mouseX, mouseY, partialTicks, bookY, bookmarkIndex, shape.getIconResourceLocation(), 0, 0, 32, 32, 32, 32);
            }
            bookmarkIndex = this.addBookmark(graphics, mouseX, mouseY, partialTicks, bookY, bookmarkIndex, OVERLAY, 239, 0, 16, 16, 256, 256);
        }
        DynamicGuiRenderer.renderArea((Graphics)graphics, (int)(this.guiLeft + 79 - 54 - 2), (int)(this.guiTop + 45 - 1), (int)110, (int)110, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.BROWN, (DynamicGuiRenderer.ButtonState)DynamicGuiRenderer.ButtonState.DOWN);
        if (CreativePatternCatalogueItem.hasCustomPattern(this.stack)) {
            NamedTrafficSignTextureReference data = CreativePatternCatalogueItem.getCustomImage(this.stack);
            TrafficSignClientTexture tex = this.cachedTextures.computeIfAbsent(data, x -> TrafficSignClientTexture.load(data.getTextureId(), false));
            NamedTrafficSignTextureReference.BuildInTrafficSignCodec codec = NamedTrafficSignTextureReference.BuildInTrafficSignCodec.decode(data.getTextureId());
            GuiUtils.drawTexture((ResourceLocation)tex.getTextureLocation(), (Graphics)graphics, (int)(this.guiLeft + 15), (int)(this.guiTop + 200 - 15 - 24), (int)24, (int)24, (int)0, (int)0, (int)tex.getRawData().getWidth(), (int)tex.getRawData().getHeight(), (int)tex.getRawData().getWidth(), (int)tex.getRawData().getHeight());
            float scale = 0.75f;
            graphics.poseStack().m_85836_();
            graphics.poseStack().m_85841_(scale, scale, scale);
            int n = (int)((float)(this.guiLeft + 15 + 30) / scale);
            Objects.requireNonNull(this.f_96547_);
            GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)n, (int)((int)((float)(this.guiTop + 200 - 15 - 12 - 9 / 2) / scale)), (FormattedText)TextUtils.translate((String)"gui.trafficcraft.patternselection.build_in_pattern", (Object[])new Object[]{TextUtils.translate((String)codec.shape().getTranslationKey()).getString(), this.selectedIndex + 1}), (int)-12566464, (EAlignment)EAlignment.LEFT, (boolean)false);
            graphics.poseStack().m_85849_();
        } else {
            NamedTrafficSignTextureReference data = PatternCatalogueItem.getSelectedPattern(this.stack);
            if (data != null) {
                TrafficSignClientTexture tex = this.cachedTextures.computeIfAbsent(data, x -> TrafficSignClientTexture.load(data.getTextureId(), false));
                GuiUtils.drawTexture((ResourceLocation)tex.getTextureLocation(), (Graphics)graphics, (int)(this.guiLeft + 15), (int)(this.guiTop + 200 - 15 - 24), (int)24, (int)24, (int)0, (int)0, (int)tex.getRawData().getWidth(), (int)tex.getRawData().getHeight(), (int)tex.getRawData().getWidth(), (int)tex.getRawData().getHeight());
                float scale = 0.75f;
                graphics.poseStack().m_85836_();
                graphics.poseStack().m_85841_(scale, scale, scale);
                int n = (int)((float)(this.guiLeft + 15 + 30) / scale);
                Objects.requireNonNull(this.f_96547_);
                GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)n, (int)((int)((float)(this.guiTop + 200 - 15 - 12 - 9 / 2) / scale)), (String)data.getName(), (int)-12566464, (EAlignment)EAlignment.LEFT, (boolean)false);
                graphics.poseStack().m_85849_();
            }
        }
        GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)(this.f_96543_ / 2), (int)this.guiTop, (FormattedText)title, (int)-1, (EAlignment)EAlignment.CENTER, (boolean)false);
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
    }

    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderFrontLayer(graphics, mouseX, mouseY, partialTick);
        this.groupPatterns.performForEach(x -> x.m_7428_(graphics.poseStack(), mouseX, mouseY));
    }

    private int addBookmark(Graphics graphics, int mouseX, int mouseY, float partialTicks, int bookY, int bookmarkIndex, ResourceLocation icon, int u, int v, int uW, int vH, int texW, int texH) {
        int bookmarkX;
        int idx = bookmarkIndex % 6;
        int n = bookmarkX = bookmarkIndex / 6 <= 0 ? -33 : 142;
        int bookmarkV = bookmarkIndex / 6 <= 0 ? (this.selectedBookmark == bookmarkIndex ? 20 : 0) : (this.selectedBookmark == bookmarkIndex ? 60 : 40);
        GuiUtils.drawTexture((ResourceLocation)OVERLAY, (Graphics)graphics, (int)(this.guiLeft + bookmarkX), (int)(bookY + 17 + idx * 22), (int)44, (int)20, (int)158, (int)bookmarkV, (int)44, (int)20, (int)256, (int)256);
        GuiUtils.drawTexture((ResourceLocation)icon, (Graphics)graphics, (int)(this.guiLeft + bookmarkX + 14), (int)(bookY + 17 + idx * 22 + 2), (int)16, (int)16, (int)u, (int)v, (int)uW, (int)vH, (int)texW, (int)texH);
        return ++bookmarkIndex;
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.creative) {
            int index;
            int bookY = this.guiTop + 26;
            int xLeft = this.guiLeft + -33;
            int xRight = this.guiLeft + 142;
            int y = bookY + 17;
            int h1 = y + Math.min(6, this.bookmarks.length + 1) * 22;
            int h2 = y + (this.bookmarks.length - 6 + 1) * 22;
            if (pMouseX > (double)xLeft && pMouseX < (double)(xLeft + 44) && pMouseY > (double)y && pMouseY < (double)h1) {
                this.selectedBookmark = index = Mth.m_14045_((int)((int)((pMouseY - (double)y) / 22.0)), (int)0, (int)6);
                this.m_169413_();
                this.m_7856_();
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.2f));
            }
            if (this.bookmarks.length + 1 > 6 && pMouseX > (double)xRight && pMouseX < (double)(xRight + 44) && pMouseY > (double)y && pMouseY < (double)h2) {
                this.selectedBookmark = index = 6 + Mth.m_14045_((int)((int)((pMouseY - (double)y) / 22.0)), (int)0, (int)6);
                this.m_169413_();
                this.m_7856_();
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.2f));
            }
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }
}

