/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.client.screen;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.mrjulsen.mcdragonlib.client.gui.DLColorPickerScreen;
import de.mrjulsen.mcdragonlib.client.gui.DLContainerScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenu;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenuItem;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLItemButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLVerticalScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.IDragonLibWidget;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.client.util.WidgetsCollection;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.ColorUtils;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.TrafficCraft;
import de.mrjulsen.trafficcraft.block.data.TrafficSignShape;
import de.mrjulsen.trafficcraft.client.screen.SignPickerScreen;
import de.mrjulsen.trafficcraft.client.screen.menu.TrafficSignWorkbenchMenu;
import de.mrjulsen.trafficcraft.data.NamedTrafficSignTextureReference;
import de.mrjulsen.trafficcraft.data.TrafficSignClientTexture;
import de.mrjulsen.trafficcraft.data.TrafficSignTextureData;
import de.mrjulsen.trafficcraft.init.ClientInit;
import de.mrjulsen.trafficcraft.item.ColorPaletteItem;
import de.mrjulsen.trafficcraft.item.PatternCatalogueItem;
import de.mrjulsen.trafficcraft.network.packets.cts.ColorPaletteItemPacket;
import de.mrjulsen.trafficcraft.network.packets.cts.PatternCatalogueDeletePacket;
import de.mrjulsen.trafficcraft.network.packets.cts.PatternCatalogueIndexPacketGui;
import de.mrjulsen.trafficcraft.network.packets.cts.TrafficSignPatternPacket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class TrafficSignWorkbenchGui
extends DLContainerScreen<TrafficSignWorkbenchMenu> {
    public static final Component title = TextUtils.translate((String)"gui.trafficcraft.trafficsignworkbench.title");
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int WIDTH = 230;
    private static final int HEIGHT = 256;
    private static final int MAX_ENTRIES_IN_ROW = 4;
    private static final int MAX_ROWS = 3;
    private static final int ICON_BUTTON_WIDTH = 18;
    private static final int ICON_BUTTON_HEIGHT = 18;
    private static final int MAX_TOOLBAR1_BUTTONS = 4;
    private final WidgetsCollection groupDefaultModeButtons = new WidgetsCollection();
    private final WidgetsCollection groupEditor = new WidgetsCollection();
    private final WidgetsCollection groupEditorToolbar1 = new WidgetsCollection();
    private final WidgetsCollection groupShapes = new WidgetsCollection();
    private final WidgetsCollection groupCreatePattern = new WidgetsCollection();
    private final WidgetsCollection groupColors = new WidgetsCollection();
    private final Map<NamedTrafficSignTextureReference, TrafficSignClientTexture> cachedTextures = new HashMap<NamedTrafficSignTextureReference, TrafficSignClientTexture>();
    private int guiLeft;
    private int guiTop;
    private TrafficSignWorkbenchMode mode = TrafficSignWorkbenchMode.EMPTY;
    private GuiAreaDefinition editorArea;
    private GuiAreaDefinition nextButton;
    private GuiAreaDefinition prevButton;
    private NamedTrafficSignTextureReference preview;
    private DLEditBox nameBox;
    private DLIconButton createNewAcceptBtn;
    private final Map<TrafficSignWorkbenchMode, List<DLTooltip>> tooltips = new HashMap<TrafficSignWorkbenchMode, List<DLTooltip>>();
    private TrafficSignShape shape;
    private int[][] pixels;
    private String name;
    private TrafficSignWorkbenchEditorTool tool = TrafficSignWorkbenchEditorTool.DRAW;
    private int selectedColor = -16777216;
    private int selectedIndex = -1;
    private final Component createPattern = TextUtils.translate((String)"gui.trafficcraft.trafficsignworkbench.createpattern.title");
    private final Component createPatternInstruction = TextUtils.translate((String)"gui.trafficcraft.trafficsignworkbench.createpattern.instruction");
    private final Component emptyPattern = TextUtils.translate((String)"gui.trafficcraft.trafficsignworkbench.menu.no_pattern");
    private final Component tooltipDefaultNew = TextUtils.translate((String)"gui.trafficcraft.trafficsignworkbench.menu.add");
    private final Component tooltipDefaultEdit = TextUtils.translate((String)"gui.trafficcraft.trafficsignworkbench.menu.edit");
    private final Component tooltipDefaultDelete = TextUtils.translate((String)"gui.trafficcraft.trafficsignworkbench.menu.delete");
    private final Component tooltipEditorToolbarDraw = TextUtils.translate((String)"gui.trafficcraft.trafficsignworkbench.editor.draw");
    private final Component tooltipEditorToolbarErase = TextUtils.translate((String)"gui.trafficcraft.trafficsignworkbench.editor.erase");
    private final Component tooltipEditorToolbarPickColor = TextUtils.translate((String)"gui.trafficcraft.trafficsignworkbench.editor.pick_color");
    private final Component tooltipEditorToolbarFill = TextUtils.translate((String)"gui.trafficcraft.trafficsignworkbench.editor.fill");
    private final Component tooltipEditorToolbarText = TextUtils.translate((String)"gui.trafficcraft.trafficsignworkbench.editor.text");
    private final Component tooltipEditorToolbarLoad = TextUtils.translate((String)"gui.trafficcraft.trafficsignworkbench.editor.load");
    private final Component tooltipEditorToolbarSave = TextUtils.translate((String)"gui.trafficcraft.trafficsignworkbench.editor.save");
    private final Component tooltipEditorToolbarDiscard = TextUtils.translate((String)"gui.trafficcraft.trafficsignworkbench.editor.discard");
    private static final ResourceLocation GUI = new ResourceLocation("trafficcraft", "textures/gui/traffic_sign_workbench.png");
    private static final ResourceLocation OVERLAY = new ResourceLocation("trafficcraft", "textures/gui/traffic_sign_workbench_overlay.png");

    public TrafficSignWorkbenchGui(TrafficSignWorkbenchMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 230;
        this.f_97727_ = 256;
        this.f_97731_ = 188;
        this.f_97730_ = 6;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        this.cachedTextures.values().stream().forEach(x -> x.close());
        super.m_7379_();
    }

    public void m_7856_() {
        DLIconButton btn2;
        int j;
        int i;
        super.m_7856_();
        this.guiLeft = this.f_96543_ / 2 - 115;
        this.guiTop = this.f_96544_ / 2 - 128;
        this.groupDefaultModeButtons.clear();
        this.groupShapes.clear();
        this.groupCreatePattern.clear();
        this.groupEditor.clear();
        this.groupEditorToolbar1.clear();
        this.groupColors.clear();
        this.tooltips.clear();
        Arrays.stream(TrafficSignWorkbenchMode.values()).forEach(x -> this.tooltips.put((TrafficSignWorkbenchMode)((Object)x), new ArrayList()));
        DLIconButton btnNew = (DLIconButton)((DLIconButton)this.m_142416_((GuiEventListener)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.BROWN, ButtonIcons.ADD.getSprite(), this.groupDefaultModeButtons, this.guiLeft + 9, this.guiTop + 36 + 0, 18, 18, null, btn -> this.switchMode(TrafficSignWorkbenchMode.CREATE_NEW)))).withAlignment(EAlignment.CENTER);
        this.tooltips.get((Object)TrafficSignWorkbenchMode.DEFAULT).add(DLTooltip.of((FormattedText)this.tooltipDefaultNew).assignedTo((AbstractWidget)btnNew));
        DLIconButton btnEdit = (DLIconButton)((DLIconButton)this.m_142416_((GuiEventListener)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.BROWN, ButtonIcons.EDIT.getSprite(), this.groupDefaultModeButtons, this.guiLeft + 9, this.guiTop + 36 + 18, 18, 18, null, btn -> {
            if (this.preview == null) {
                return;
            }
            this.switchMode(TrafficSignWorkbenchMode.EDITOR);
            this.shape = this.getPrevievTexture().getRawData().getShape();
            this.pixels = ClientInit.textureToIntArray(this.getPrevievTexture().getTexture(), true);
            this.nameBox.m_94144_(this.preview.getName());
            this.selectedIndex = PatternCatalogueItem.getSelectedIndex(((TrafficSignWorkbenchMenu)this.m_6262_()).patternSlot.m_7993_());
        }))).withAlignment(EAlignment.CENTER);
        this.tooltips.get((Object)TrafficSignWorkbenchMode.DEFAULT).add(DLTooltip.of((FormattedText)this.tooltipDefaultEdit).assignedTo((AbstractWidget)btnEdit));
        DLIconButton btnDelete = (DLIconButton)((DLIconButton)this.m_142416_((GuiEventListener)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.BROWN, ButtonIcons.DELETE.getSprite(), this.groupDefaultModeButtons, this.guiLeft + 9, this.guiTop + 36 + 36, 18, 18, null, btn -> {
            if (this.preview == null) {
                return;
            }
            this.f_96541_.m_91152_((Screen)new ConfirmScreen(b -> {
                if (b) {
                    int idx = PatternCatalogueItem.getSelectedIndex(((TrafficSignWorkbenchMenu)this.m_6262_()).patternSlot.m_7993_());
                    TrafficCraft.net().sendToServer((Object)new PatternCatalogueDeletePacket(idx));
                }
                this.f_96541_.m_91152_((Screen)this);
            }, (Component)TextUtils.translate((String)"gui.trafficcraft.trafficsignworkbench.delete.question"), (Component)TextUtils.translate((String)"selectWorld.deleteWarning", (Object[])new Object[]{this.preview.getName()}), (Component)TextUtils.translate((String)"selectWorld.deleteButton"), CommonComponents.f_130656_));
        }))).withAlignment(EAlignment.CENTER);
        this.tooltips.get((Object)TrafficSignWorkbenchMode.DEFAULT).add(DLTooltip.of((FormattedText)this.tooltipDefaultDelete).assignedTo((AbstractWidget)btnDelete));
        int x2 = this.guiLeft + 79;
        int y = this.guiTop + 70;
        DLIconButton[] shapeButtons = (DLIconButton[])Arrays.stream(TrafficSignShape.values()).map(pShape -> {
            TrafficSignShape shape = pShape;
            DLIconButton button = (DLIconButton)new DLIconButton(DLAbstractImageButton.ButtonType.RADIO_BUTTON, DynamicGuiRenderer.AreaStyle.BROWN, new Sprite(shape.getIconResourceLocation(), 16, 16, 0, 0, 16, 16), this.groupShapes, x2, y, 18, 18, null, btn -> {
                this.shape = shape;
            }).withAlignment(EAlignment.CENTER);
            if (shape == this.shape) {
                button.select();
            }
            this.tooltips.get((Object)TrafficSignWorkbenchMode.CREATE_NEW).add(DLTooltip.of((FormattedText)TextUtils.translate((String)shape.getTranslationKey())).assignedTo((AbstractWidget)button));
            button.set_visible(false);
            return (DLIconButton)this.m_142416_((GuiEventListener)button);
        }).toArray(DLIconButton[]::new);
        this.fillButtons(shapeButtons, 0.0, x2, y, null);
        this.createNewAcceptBtn = (DLIconButton)this.m_142416_((GuiEventListener)((DLIconButton)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.GRAY, new Sprite(OVERLAY, 256, 256, 46, 174, 16, 16), this.groupCreatePattern, this.guiLeft + 115 - 20, this.guiTop + 150, 18, 18, null, btn -> this.switchMode(TrafficSignWorkbenchMode.EDITOR)).withAlignment(EAlignment.CENTER)));
        this.m_142416_((GuiEventListener)((DLIconButton)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.GRAY, new Sprite(OVERLAY, 256, 256, 62, 174, 16, 16), this.groupCreatePattern, this.guiLeft + 115 + 2, this.guiTop + 150, 18, 18, null, btn -> this.switchMode(TrafficSignWorkbenchMode.DEFAULT)).withAlignment(EAlignment.CENTER)));
        this.nameBox = GuiUtils.createEditBox((int)(this.guiLeft + 115 - 63), (int)(this.guiTop + 164), (int)120, (int)10, (Font)this.f_96547_, (String)this.name, (Component)TextUtils.empty(), (boolean)false, txt -> {
            this.name = txt;
        }, null);
        this.nameBox.m_94202_(-1);
        this.nameBox.m_94205_(-1);
        this.nameBox.m_94199_(20);
        this.m_142416_((GuiEventListener)this.nameBox);
        this.groupEditor.components.add(this.nameBox);
        this.editorArea = new GuiAreaDefinition(this.guiLeft + 115 - 64 - 3, this.guiTop + 32, 128, 128);
        this.prevButton = new GuiAreaDefinition(this.guiLeft + 51, this.guiTop + 164, 23, 13);
        this.nextButton = new GuiAreaDefinition(this.guiLeft + 149, this.guiTop + 164, 23, 13);
        for (i = 0; i < 4; ++i) {
            j = i;
            Sprite sprite = null;
            switch (j) {
                case 0: {
                    sprite = ButtonIcons.EDIT.getSprite();
                    break;
                }
                case 1: {
                    sprite = ButtonIcons.ERASER.getSprite();
                    break;
                }
                case 2: {
                    sprite = ButtonIcons.PICK_COLOR.getSprite();
                    break;
                }
                case 3: {
                    sprite = ButtonIcons.FILL.getSprite();
                    break;
                }
                case 4: {
                    sprite = ButtonIcons.TEXT.getSprite();
                    break;
                }
            }
            btn2 = (DLIconButton)new DLIconButton(DLAbstractImageButton.ButtonType.RADIO_BUTTON, DynamicGuiRenderer.AreaStyle.BROWN, sprite, this.groupEditorToolbar1, this.guiLeft + 9, this.guiTop + 36 + j * 18, 18, 18, null, b -> {
                this.tool = TrafficSignWorkbenchEditorTool.byIndex(j);
            }).withAlignment(EAlignment.CENTER);
            switch (j) {
                case 0: {
                    this.tooltips.get((Object)TrafficSignWorkbenchMode.EDITOR).add(DLTooltip.of((FormattedText)this.tooltipEditorToolbarDraw).assignedTo((AbstractWidget)btn2));
                    break;
                }
                case 1: {
                    this.tooltips.get((Object)TrafficSignWorkbenchMode.EDITOR).add(DLTooltip.of((FormattedText)this.tooltipEditorToolbarErase).assignedTo((AbstractWidget)btn2));
                    break;
                }
                case 2: {
                    this.tooltips.get((Object)TrafficSignWorkbenchMode.EDITOR).add(DLTooltip.of((FormattedText)this.tooltipEditorToolbarPickColor).assignedTo((AbstractWidget)btn2));
                    break;
                }
                case 3: {
                    this.tooltips.get((Object)TrafficSignWorkbenchMode.EDITOR).add(DLTooltip.of((FormattedText)this.tooltipEditorToolbarFill).assignedTo((AbstractWidget)btn2));
                    break;
                }
                case 4: {
                    this.tooltips.get((Object)TrafficSignWorkbenchMode.EDITOR).add(DLTooltip.of((FormattedText)this.tooltipEditorToolbarText).assignedTo((AbstractWidget)btn2));
                    break;
                }
            }
            if (this.tool == TrafficSignWorkbenchEditorTool.byIndex(j)) {
                btn2.select();
            }
            this.m_142416_((GuiEventListener)btn2);
            if (j != 1) continue;
            btn2.setMenu(new DLContextMenu(() -> GuiAreaDefinition.of((AbstractWidget)btn2), () -> new DLContextMenuItem.Builder().add(new DLContextMenuItem.ContextMenuItemData((Component)TextUtils.text((String)"Clear"), Sprite.empty(), true, b -> this.clearCanvas(), null))));
        }
        for (i = 0; i < 3; ++i) {
            j = i;
            Sprite sprite1 = null;
            switch (j) {
                case 0: {
                    sprite1 = ButtonIcons.OPEN.getSprite();
                    break;
                }
                case 1: {
                    sprite1 = ButtonIcons.SAVE.getSprite();
                    break;
                }
                case 2: {
                    sprite1 = ButtonIcons.DISCARD.getSprite();
                    break;
                }
            }
            btn2 = (DLIconButton)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.BROWN, sprite1, this.groupEditorToolbar1, this.guiLeft + 9, this.guiTop + 130 + j * 18, 18, 18, null, button -> {
                switch (j) {
                    case 0: {
                        this.f_96541_.m_91152_((Screen)new SignPickerScreen((Screen)this, this.shape, image -> {
                            if (image != null) {
                                for (int a = 0; a < 32; ++a) {
                                    for (int b = 0; b < 32; ++b) {
                                        this.pixels[a][b] = ColorUtils.swapRedBlue((int)image.m_84985_(a, b));
                                    }
                                }
                            }
                        }));
                        break;
                    }
                    case 1: {
                        NativeImage img = new NativeImage(NativeImage.Format.RGBA, 32, 32, false);
                        for (int k = 0; k < img.m_84982_(); ++k) {
                            for (int l = 0; l < img.m_85084_(); ++l) {
                                img.m_84988_(k, l, 0);
                                if (!this.shape.isPixelValid(k, l)) continue;
                                img.m_84988_(k, l, ColorUtils.swapRedBlue((int)this.pixels[k][l]));
                            }
                        }
                        TrafficSignTextureData data = TrafficSignClientTexture.createNew(this.shape, img, null);
                        NamedTrafficSignTextureReference ref = NamedTrafficSignTextureReference.of(data, this.name);
                        TrafficCraft.net().sendToServer((Object)new TrafficSignPatternPacket(ref, this.selectedIndex));
                        img.close();
                        this.switchMode(TrafficSignWorkbenchMode.DEFAULT);
                        this.initPreview();
                        break;
                    }
                    case 2: {
                        this.f_96541_.m_91152_((Screen)new ConfirmScreen(b -> {
                            this.f_96541_.m_91152_((Screen)this);
                            if (b) {
                                this.switchMode(TrafficSignWorkbenchMode.DEFAULT);
                                this.initPreview();
                            }
                        }, (Component)TextUtils.translate((String)"gui.trafficcraft.trafficsignworkbench.discard.question"), (Component)TextUtils.empty(), CommonComponents.f_130657_, CommonComponents.f_130658_));
                        break;
                    }
                }
            }).withAlignment(EAlignment.CENTER);
            switch (j) {
                case 0: {
                    this.tooltips.get((Object)TrafficSignWorkbenchMode.EDITOR).add(DLTooltip.of((FormattedText)this.tooltipEditorToolbarLoad).assignedTo((AbstractWidget)btn2));
                    break;
                }
                case 1: {
                    this.tooltips.get((Object)TrafficSignWorkbenchMode.EDITOR).add(DLTooltip.of((FormattedText)this.tooltipEditorToolbarSave).assignedTo((AbstractWidget)btn2));
                    break;
                }
                case 2: {
                    this.tooltips.get((Object)TrafficSignWorkbenchMode.EDITOR).add(DLTooltip.of((FormattedText)this.tooltipEditorToolbarDiscard).assignedTo((AbstractWidget)btn2));
                    break;
                }
            }
            this.m_142416_((GuiEventListener)btn2);
        }
        this.m_142416_((GuiEventListener)((DLIconButton)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.BROWN, ButtonIcons.ADD_SMALL.getSprite(), this.groupEditorToolbar1, this.guiLeft + 203, this.guiTop + 36, 18, 18, null, btn -> this.f_96541_.m_91152_((Screen)new DLColorPickerScreen((Screen)this, this.selectedColor, c -> {
            this.selectedColor = c.toInt();
        }, true))){

            public void renderImage(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
                GuiUtils.fill((Graphics)graphics, (int)(this.f_93620_ + 2), (int)(this.f_93621_ + 2), (int)14, (int)14, (int)TrafficSignWorkbenchGui.this.selectedColor);
                super.renderImage(graphics, mouseX, mouseY, partialTicks);
            }
        }.withAlignment(EAlignment.CENTER)));
        i = 0;
        while (i < 7) {
            j = i++;
            this.m_142416_((GuiEventListener)((DLIconButton)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.BROWN, Sprite.empty(), this.groupColors, this.guiLeft + 203, this.guiTop + 40 + (j + 1) * 18, 18, 18, null, btn -> {}){

                public void renderImage(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
                    ItemStack stack = ((TrafficSignWorkbenchMenu)((TrafficSignWorkbenchGui)TrafficSignWorkbenchGui.this).f_97732_).colorSlot.m_7993_();
                    if (!(stack.m_41720_() instanceof ColorPaletteItem)) {
                        return;
                    }
                    GuiUtils.fill((Graphics)graphics, (int)(this.f_93620_ + 2), (int)(this.f_93621_ + 2), (int)14, (int)14, (int)ColorPaletteItem.getColorAt(stack, j));
                    super.renderImage(graphics, mouseX, mouseY, partialTicks);
                }

                protected boolean m_7972_(int pButton) {
                    return pButton == 0 || pButton == 1 || pButton == 2;
                }

                public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
                    if (!this.m_5953_(pMouseX, pMouseY)) {
                        return super.m_6375_(pMouseX, pMouseY, pButton);
                    }
                    ItemStack stack = ((TrafficSignWorkbenchMenu)((TrafficSignWorkbenchGui)TrafficSignWorkbenchGui.this).f_97732_).colorSlot.m_7993_();
                    if (!(stack.m_41720_() instanceof ColorPaletteItem)) {
                        return super.m_6375_(pMouseX, pMouseY, pButton);
                    }
                    switch (pButton) {
                        case 0: {
                            int color = ColorPaletteItem.getColorAt(stack, j);
                            TrafficSignWorkbenchGui.this.selectedColor = color == 0 ? TrafficSignWorkbenchGui.this.selectedColor : color;
                            break;
                        }
                        case 1: {
                            TrafficCraft.net().sendToServer((Object)new ColorPaletteItemPacket(TrafficSignWorkbenchGui.this.selectedColor, j));
                            break;
                        }
                        case 2: {
                            TrafficCraft.net().sendToServer((Object)new ColorPaletteItemPacket(0, j));
                            break;
                        }
                    }
                    return super.m_6375_(pMouseX, pMouseY, pButton);
                }
            }.withAlignment(EAlignment.CENTER)));
        }
        this.switchMode(this.mode);
    }

    private void fillButtons(DLIconButton[] buttons, double scrollRow, int defX, int defY, DLVerticalScrollBar scrollbar) {
        int currentRow = -1;
        for (int i = 0; i < buttons.length; ++i) {
            if (i % 4 == 0) {
                ++currentRow;
            }
            buttons[i].set_x(defX + i % 4 * 18);
            buttons[i].set_y((int)((double)(defY + currentRow * 18) - scrollRow * 18.0));
            buttons[i].set_visible((double)currentRow >= scrollRow && (double)currentRow < scrollRow + 3.0);
        }
        if (scrollbar != null) {
            ((DLVerticalScrollBar)scrollbar.setScreenSize(3)).setMaxScroll(currentRow + 1);
        }
    }

    protected void m_181908_() {
        super.m_181908_();
        if (((TrafficSignWorkbenchMenu)this.m_6262_()).patternSlot.m_6657_() && this.mode == TrafficSignWorkbenchMode.EMPTY) {
            this.switchMode(TrafficSignWorkbenchMode.DEFAULT);
        } else if (!((TrafficSignWorkbenchMenu)this.m_6262_()).patternSlot.m_6657_()) {
            this.switchMode(TrafficSignWorkbenchMode.EMPTY);
        }
        switch (this.mode.ordinal()) {
            case 3: {
                this.groupColors.setVisible(((TrafficSignWorkbenchMenu)this.m_6262_()).colorSlot.m_6657_());
                break;
            }
            case 1: {
                ((AbstractWidget)this.groupDefaultModeButtons.components.get((int)0)).f_93623_ = !this.isFull();
                ((AbstractWidget)this.groupDefaultModeButtons.components.get((int)1)).f_93623_ = this.preview != null;
                ((AbstractWidget)this.groupDefaultModeButtons.components.get((int)2)).f_93623_ = this.preview != null;
                break;
            }
        }
        if (this.createNewAcceptBtn.f_93624_) {
            this.createNewAcceptBtn.set_active(this.shape != null);
        }
    }

    private boolean isFull() {
        return ((TrafficSignWorkbenchMenu)this.m_6262_()).patternSlot.m_7993_().m_41720_() instanceof PatternCatalogueItem && PatternCatalogueItem.getStoredPatternCount(((TrafficSignWorkbenchMenu)this.m_6262_()).patternSlot.m_7993_()) >= ((PatternCatalogueItem)((TrafficSignWorkbenchMenu)this.m_6262_()).patternSlot.m_7993_().m_41720_()).getMaxPatterns();
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        GuiUtils.drawTexture((ResourceLocation)GUI, (Graphics)graphics, (int)this.guiLeft, (int)this.guiTop, (int)230, (int)256, (int)0, (int)0, (int)230, (int)256, (int)256, (int)256);
        switch (this.mode.ordinal()) {
            case 1: {
                this.renderPatternBackground(graphics);
                GuiUtils.drawTexture((ResourceLocation)OVERLAY, (Graphics)graphics, (int)this.prevButton.getX(), (int)this.prevButton.getY(), (int)this.prevButton.getWidth(), (int)this.prevButton.getHeight(), (int)(this.prevButton.isInBounds((double)mouseX, (double)mouseY) ? 23 : 0), (int)187, (int)this.prevButton.getWidth(), (int)this.prevButton.getHeight(), (int)256, (int)256);
                GuiUtils.drawTexture((ResourceLocation)OVERLAY, (Graphics)graphics, (int)this.nextButton.getX(), (int)this.nextButton.getY(), (int)this.nextButton.getWidth(), (int)this.nextButton.getHeight(), (int)(this.nextButton.isInBounds((double)mouseX, (double)mouseY) ? 23 : 0), (int)174, (int)this.nextButton.getWidth(), (int)this.nextButton.getHeight(), (int)256, (int)256);
                String label = String.format("%s / %s", PatternCatalogueItem.getSelectedIndex(((TrafficSignWorkbenchMenu)this.m_6262_()).patternSlot.m_7993_()) + 1, PatternCatalogueItem.getStoredPatternCount(((TrafficSignWorkbenchMenu)this.m_6262_()).patternSlot.m_7993_()));
                int n = this.guiLeft + 115 - this.f_96547_.m_92895_(label) / 2;
                Objects.requireNonNull(this.f_96547_);
                GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)n, (int)(this.guiTop + 170 - 9 / 2), (String)label, (int)-12566464, (EAlignment)EAlignment.LEFT, (boolean)false);
                label = this.preview == null ? "" : this.preview.getName();
                int n2 = this.guiLeft + 115 - this.f_96547_.m_92895_(label) / 2;
                Objects.requireNonNull(this.f_96547_);
                GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)n2, (int)(this.guiTop + 155 - 9 / 2), (String)label, (int)-12566464, (EAlignment)EAlignment.LEFT, (boolean)false);
                if (this.preview != null) {
                    TrafficSignClientTexture tex = this.getPrevievTexture();
                    GuiUtils.drawTexture((ResourceLocation)tex.getTextureLocation(), (Graphics)graphics, (int)(this.guiLeft + 115 - 50), (int)(this.guiTop + 40), (int)100, (int)100, (int)0, (int)0, (int)tex.getRawData().getWidth(), (int)tex.getRawData().getHeight(), (int)tex.getRawData().getWidth(), (int)tex.getRawData().getHeight());
                } else {
                    label = this.emptyPattern.getString();
                    int n3 = this.guiLeft + 115 - this.f_96547_.m_92895_(label) / 2;
                    Objects.requireNonNull(this.f_96547_);
                    GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)n3, (int)(this.guiTop + 100 - 9 / 2), (String)label, (int)-12566464, (EAlignment)EAlignment.LEFT, (boolean)false);
                }
                DynamicGuiRenderer.renderArea((Graphics)graphics, (int)(this.guiLeft + 8), (int)(this.guiTop + 35), (int)20, (int)56, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.BROWN, (DynamicGuiRenderer.ButtonState)DynamicGuiRenderer.ButtonState.DOWN);
                break;
            }
            case 2: {
                this.renderPatternBackground(graphics);
                DynamicGuiRenderer.renderArea((Graphics)graphics, (int)(this.guiLeft + 79 - 1), (int)(this.guiTop + 69), (int)74, (int)(2 + (TrafficSignShape.values().length / 4 + (TrafficSignShape.values().length % 4 == 0 ? 0 : 1)) * 18), (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.BROWN, (DynamicGuiRenderer.ButtonState)DynamicGuiRenderer.ButtonState.DOWN);
                int n = this.guiLeft + 115 - this.f_96547_.m_92852_((FormattedText)this.createPattern) / 2;
                Objects.requireNonNull(this.f_96547_);
                GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)n, (int)(this.guiTop + 40 - 9 / 2), (FormattedText)this.createPattern, (int)-12566464, (EAlignment)EAlignment.LEFT, (boolean)false);
                int n4 = this.guiLeft + 115 - this.f_96547_.m_92852_((FormattedText)this.createPatternInstruction) / 2;
                Objects.requireNonNull(this.f_96547_);
                GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)n4, (int)(this.guiTop + 55 - 9 / 2), (FormattedText)this.createPatternInstruction, (int)-12566464, (EAlignment)EAlignment.LEFT, (boolean)false);
                break;
            }
            case 3: {
                int mY;
                int mX;
                this.renderPatternBackground(graphics);
                DynamicGuiRenderer.renderArea((Graphics)graphics, (int)(this.guiLeft + 8), (int)(this.guiTop + 35), (int)20, (int)74, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.BROWN, (DynamicGuiRenderer.ButtonState)DynamicGuiRenderer.ButtonState.DOWN);
                DynamicGuiRenderer.renderArea((Graphics)graphics, (int)(this.guiLeft + 8), (int)(this.guiTop + 129), (int)20, (int)56, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.BROWN, (DynamicGuiRenderer.ButtonState)DynamicGuiRenderer.ButtonState.DOWN);
                DynamicGuiRenderer.renderArea((Graphics)graphics, (int)(this.guiLeft + 202), (int)(this.guiTop + 35), (int)20, (int)20, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.BROWN, (DynamicGuiRenderer.ButtonState)DynamicGuiRenderer.ButtonState.DOWN);
                DynamicGuiRenderer.renderArea((Graphics)graphics, (int)(this.guiLeft + 202), (int)(this.guiTop + 57), (int)20, (int)128, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.BROWN, (DynamicGuiRenderer.ButtonState)DynamicGuiRenderer.ButtonState.DOWN);
                DynamicGuiRenderer.renderArea((Graphics)graphics, (int)(this.guiLeft + 115 - 65), (int)(this.guiTop + 162), (int)120, (int)12, (DynamicGuiRenderer.AreaStyle)DynamicGuiRenderer.AreaStyle.GRAY, (DynamicGuiRenderer.ButtonState)DynamicGuiRenderer.ButtonState.DOWN);
                GuiUtils.setTint((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GuiUtils.drawTexture((int)this.shape.getShapeTextureId(), (Graphics)graphics, (int)(this.editorArea.getX() - 1), (int)(this.editorArea.getY() - 1), (int)this.editorArea.getWidth(), (int)this.editorArea.getHeight(), (int)0, (int)0, (int)32, (int)32, (int)32, (int)32);
                GuiUtils.drawTexture((int)this.shape.getShapeTextureId(), (Graphics)graphics, (int)(this.editorArea.getX() + 1), (int)(this.editorArea.getY() - 1), (int)this.editorArea.getWidth(), (int)this.editorArea.getHeight(), (int)0, (int)0, (int)32, (int)32, (int)32, (int)32);
                GuiUtils.drawTexture((int)this.shape.getShapeTextureId(), (Graphics)graphics, (int)(this.editorArea.getX() - 1), (int)(this.editorArea.getY() + 1), (int)this.editorArea.getWidth(), (int)this.editorArea.getHeight(), (int)0, (int)0, (int)32, (int)32, (int)32, (int)32);
                GuiUtils.drawTexture((int)this.shape.getShapeTextureId(), (Graphics)graphics, (int)(this.editorArea.getX() + 1), (int)(this.editorArea.getY() + 1), (int)this.editorArea.getWidth(), (int)this.editorArea.getHeight(), (int)0, (int)0, (int)32, (int)32, (int)32, (int)32);
                GuiUtils.resetTint();
                GuiUtils.drawTexture((int)this.shape.getShapeTextureId(), (Graphics)graphics, (int)this.editorArea.getX(), (int)this.editorArea.getY(), (int)this.editorArea.getWidth(), (int)this.editorArea.getHeight(), (int)0, (int)0, (int)32, (int)32, (int)32, (int)32);
                for (int a = 0; a < this.pixels.length; ++a) {
                    for (int b = 0; b < this.pixels[a].length; ++b) {
                        GuiUtils.fill((Graphics)graphics, (int)(this.editorArea.getX() + a * 4), (int)(this.editorArea.getY() + b * 4), (int)4, (int)4, (int)this.pixels[a][b]);
                    }
                }
                if (!this.editorArea.isInBounds((double)mouseX, (double)mouseY) || !this.shape.isPixelValid(mX = this.getMouseXEditorCoord(mouseX), mY = this.getMouseYEditorCoord(mouseY))) break;
                int x = this.editorArea.getX() + mX * 4;
                int y = this.editorArea.getY() + mY * 4;
                GuiUtils.fill((Graphics)graphics, (int)x, (int)y, (int)4, (int)4, (int)0x7F000000);
                break;
            }
        }
        GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)(this.guiLeft + 115 - this.f_96547_.m_92852_((FormattedText)title) / 2), (int)(this.guiTop + 5), (String)title.getString(), (int)-12566464, (EAlignment)EAlignment.LEFT, (boolean)false);
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
    }

    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTick) {
        Iterator w = this.m_6702_().stream().map(x -> (Widget)x).iterator();
        while (w.hasNext()) {
            IDragonLibWidget layeredWidget;
            Widget widget = (Widget)w.next();
            if (!(widget instanceof IDragonLibWidget) || !(layeredWidget = (IDragonLibWidget)widget).visible() || this.checkWidgetBounds() && !DLUtils.rectanglesIntersecting((double)layeredWidget.x(), (double)layeredWidget.y(), (double)layeredWidget.width(), (double)layeredWidget.height(), (double)((double)this.x() + (Double)this.checkWidgetBoundsOffset().getFirst()), (double)((double)this.y() + (Double)this.checkWidgetBoundsOffset().getSecond()), (double)this.width(), (double)this.height())) continue;
            layeredWidget.renderFrontLayer(graphics, mouseX, mouseY, partialTick);
        }
        DLItemButton.renderAllItemButtonTooltips((Screen)this, (Graphics)graphics, (int)mouseX, (int)mouseY);
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_85837_(0.0, 0.0, 1000.0);
        RenderSystem.m_157182_();
        if (this.getContextMenu() != null && this.getContextMenu() != null) {
            this.getContextMenu().renderFrontLayer(graphics, mouseX, mouseY, partialTick);
        }
        graphics.poseStack().m_85849_();
    }

    private void renderPatternBackground(Graphics graphics) {
        GuiUtils.drawTexture((ResourceLocation)OVERLAY, (Graphics)graphics, (int)(this.guiLeft + 36), (int)(this.guiTop + 14), (int)158, (int)174, (int)0, (int)0, (int)256, (int)256);
    }

    private int getMouseXEditorCoord(double mouseX) {
        return ((int)mouseX - this.editorArea.getX()) / 4;
    }

    private int getMouseYEditorCoord(double mouseY) {
        return ((int)mouseY - this.editorArea.getY()) / 4;
    }

    private void draw(double pMouseX, double pMouseY, int button) {
        if (this.mode != TrafficSignWorkbenchMode.EDITOR || !this.editorArea.isInBounds(pMouseX, pMouseY)) {
            return;
        }
        int x = this.getMouseXEditorCoord(pMouseX);
        int y = this.getMouseYEditorCoord(pMouseY);
        switch (this.tool.ordinal()) {
            default: {
                int color = this.selectedColor;
                if (button == 1 || this.tool == TrafficSignWorkbenchEditorTool.ERASER) {
                    color = 0;
                }
                if (!this.shape.isPixelValid(x, y)) break;
                this.pixels[x][y] = color;
                break;
            }
            case 2: {
                if (!this.shape.isPixelValid(x, y) || this.pixels[x][y] == 0) break;
                this.selectedColor = this.pixels[x][y];
                break;
            }
            case 3: {
                if (!this.shape.isPixelValid(x, y)) break;
                this.fillArea(x, y, this.pixels[x][y]);
                this.tool = TrafficSignWorkbenchEditorTool.DRAW;
                for (int w = 0; w < this.groupEditorToolbar1.components.size(); ++w) {
                    Object e = this.groupEditorToolbar1.components.get(w);
                    if (!(e instanceof DLIconButton)) continue;
                    DLIconButton btn = (DLIconButton)e;
                    if (w == 0) {
                        btn.select();
                        continue;
                    }
                    btn.deselect();
                }
            }
        }
    }

    private void fillArea(int x, int y, int replaceColor) {
        int y1;
        if (!this.shape.isPixelValid(x, y) || this.pixels[x][y] == this.selectedColor) {
            return;
        }
        this.pixels[x][y] = this.selectedColor;
        int x1 = x - 1;
        if (x1 >= 0 && this.shape.isPixelValid(x1, y) && this.pixels[x1][y] == replaceColor) {
            this.fillArea(x - 1, y, replaceColor);
        }
        if ((x1 = x + 1) < 32 && this.shape.isPixelValid(x1, y) && this.pixels[x1][y] == replaceColor) {
            this.fillArea(x + 1, y, replaceColor);
        }
        if ((y1 = y - 1) >= 0 && this.shape.isPixelValid(x, y1) && this.pixels[x][y1] == replaceColor) {
            this.fillArea(x, y - 1, replaceColor);
        }
        if ((y1 = y + 1) < 32 && this.shape.isPixelValid(x, y1) && this.pixels[x][y1] == replaceColor) {
            this.fillArea(x, y + 1, replaceColor);
        }
    }

    private void switchPreview(int index) {
        PatternCatalogueItem.setSelectedIndex(((TrafficSignWorkbenchMenu)this.m_6262_()).patternSlot.m_7993_(), index);
        TrafficCraft.net().sendToServer((Object)new PatternCatalogueIndexPacketGui(index));
        this.initPreview();
    }

    private void initPreview() {
        this.preview = PatternCatalogueItem.getSelectedPattern(((TrafficSignWorkbenchMenu)this.m_6262_()).patternSlot.m_7993_());
        this.getPrevievTexture();
    }

    private synchronized TrafficSignClientTexture getPrevievTexture() {
        if (this.preview == null) {
            return TrafficSignClientTexture.EMPTY;
        }
        return this.cachedTextures.computeIfAbsent(this.preview, x -> TrafficSignClientTexture.load(x.getTextureId(), false));
    }

    public void updatePreview() {
        this.initPreview();
    }

    public void m_6305_(PoseStack poseStack, int pMouseX, int pMouseY, float pPartialTick) {
        Graphics graphics = new Graphics(poseStack);
        this.m_96558_(poseStack, pMouseY);
        super.m_6305_(poseStack, pMouseX, pMouseY, pPartialTick);
        this.m_7025_(poseStack, pMouseX, pMouseY);
        block0 : switch (this.mode.ordinal()) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                int i;
                for (i = 0; i < this.groupEditorToolbar1.components.size(); ++i) {
                }
                for (i = 0; i < this.groupColors.components.size(); ++i) {
                    int j = i;
                    ItemStack stack = ((TrafficSignWorkbenchMenu)this.f_97732_).colorSlot.m_7993_();
                    if (!(stack.m_41720_() instanceof ColorPaletteItem)) break block0;
                    int color = ColorPaletteItem.getColorAt(stack, j);
                    if (color == 0) {
                        color = -1;
                    }
                    int c = color;
                    GuiUtils.renderTooltip((Screen)this, (AbstractWidget)((AbstractWidget)this.groupColors.components.get(j)), List.of(TextUtils.translate((String)"gui.trafficcraft.trafficsignworkbench.editor.color.slot", (Object[])new Object[]{j + 1}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)c))), TextUtils.translate((String)"gui.trafficcraft.trafficsignworkbench.editor.color.get").m_130940_(ChatFormatting.GRAY), TextUtils.translate((String)"gui.trafficcraft.trafficsignworkbench.editor.color.set").m_130940_(ChatFormatting.GRAY), TextUtils.translate((String)"gui.trafficcraft.trafficsignworkbench.editor.color.remove").m_130940_(ChatFormatting.GRAY)), (int)(this.f_96543_ / 4), (Graphics)graphics, (int)pMouseX, (int)pMouseY);
                }
                break;
            }
        }
        this.tooltips.get((Object)this.mode).forEach(x -> x.render((Screen)this, graphics, pMouseX, pMouseY));
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        switch (this.mode.ordinal()) {
            case 1: {
                if (this.nextButton.isInBounds(pMouseX, pMouseY)) {
                    this.switchPreview(PatternCatalogueItem.getSelectedIndex(((TrafficSignWorkbenchMenu)this.m_6262_()).patternSlot.m_7993_()) + 1);
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.2f));
                    break;
                }
                if (!this.prevButton.isInBounds(pMouseX, pMouseY)) break;
                this.switchPreview(Math.max(PatternCatalogueItem.getSelectedIndex(((TrafficSignWorkbenchMenu)this.m_6262_()).patternSlot.m_7993_()) - 1, 0));
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.2f));
                break;
            }
            case 3: {
                this.draw(pMouseX, pMouseY, pButton);
                break;
            }
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        this.draw(pMouseX, pMouseY, pButton);
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    private boolean isMouseInBounds(int x, int y, int w, int h, int mX, int mY) {
        return mX >= x && mX <= x + w && mY >= y && mY <= y + h;
    }

    private void switchMode(TrafficSignWorkbenchMode mode) {
        boolean differentMode = this.mode != mode;
        this.mode = mode;
        this.groupDefaultModeButtons.setVisible(false);
        this.groupShapes.setVisible(false);
        this.groupCreatePattern.setVisible(false);
        this.groupEditor.setVisible(false);
        this.groupEditorToolbar1.setVisible(false);
        this.groupColors.setVisible(false);
        switch (mode.ordinal()) {
            default: {
                break;
            }
            case 1: {
                this.groupDefaultModeButtons.setVisible(true);
                break;
            }
            case 2: {
                this.groupShapes.setVisible(true);
                this.groupCreatePattern.setVisible(true);
                break;
            }
            case 3: {
                this.groupEditor.setVisible(true);
                this.groupEditorToolbar1.setVisible(true);
                this.groupColors.setVisible(true);
            }
        }
        if (differentMode) {
            this.initMode();
        }
    }

    private void initMode() {
        switch (this.mode.ordinal()) {
            default: {
                break;
            }
            case 1: {
                this.initPreview();
                break;
            }
            case 2: {
                this.shape = null;
                this.groupShapes.performForEachOfType(DLIconButton.class, w -> w.deselect());
                break;
            }
            case 3: {
                this.clearCanvas();
                this.name = TextUtils.translate((String)"gui.trafficcraft.trafficsignworkbench.pattern.name_unknown").getString();
                this.nameBox.m_94144_(this.name);
                this.selectedIndex = -1;
            }
        }
    }

    private void clearCanvas() {
        this.pixels = new int[32][];
        for (int a = 0; a < this.pixels.length; ++a) {
            this.pixels[a] = new int[32];
        }
    }

    protected static enum TrafficSignWorkbenchMode {
        EMPTY,
        DEFAULT,
        CREATE_NEW,
        EDITOR;

    }

    protected static enum TrafficSignWorkbenchEditorTool {
        DRAW(0),
        ERASER(1),
        PICK_COLOR(2),
        FILL(3);

        private int index;

        private TrafficSignWorkbenchEditorTool(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static TrafficSignWorkbenchEditorTool byIndex(int index) {
            for (TrafficSignWorkbenchEditorTool shape : TrafficSignWorkbenchEditorTool.values()) {
                if (shape.getIndex() != index) continue;
                return shape;
            }
            return DRAW;
        }
    }

    protected static enum ButtonIcons {
        EDIT(0),
        ERASER(1),
        PICK_COLOR(2),
        TEXT(3),
        FILL(4),
        DELETE(5),
        PATTERN(6),
        ADD(7),
        ADD_SMALL(8),
        SAVE(9),
        OPEN(10),
        IMPORT(11),
        DISCARD(12);

        private int index;
        private static final int U = 238;
        private static final int ICON_SIZE = 18;

        private ButtonIcons(int index) {
            this.index = index;
        }

        public int getV() {
            return this.getIndex() * 18;
        }

        public int getU() {
            return 238;
        }

        public int getIndex() {
            return this.index;
        }

        public static ButtonIcons byIndex(int index) {
            if (index < 0 || index >= ButtonIcons.values().length) {
                return EDIT;
            }
            return ButtonIcons.values()[index];
        }

        public void render(PoseStack pPoseStack, int x, int y) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)OVERLAY);
            GuiComponent.m_93133_((PoseStack)pPoseStack, (int)x, (int)y, (float)this.getU(), (float)this.getV(), (int)18, (int)18, (int)256, (int)256);
        }

        public Sprite getSprite() {
            return new Sprite(OVERLAY, 256, 256, this.getU(), this.getV(), 18, 18);
        }
    }
}

