/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.data;

import de.mrjulsen.mcdragonlib.core.ITranslatableEnum;
import java.util.Arrays;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.level.material.MaterialColor;

public enum PaintColor implements StringRepresentable,
ITranslatableEnum
{
    NONE(-1, "none", -1, MaterialColor.f_76398_, -1, -1),
    WHITE(0, "white", 0xF9FFFE, MaterialColor.f_76406_, 0xF0F0F0, 0xFFFFFF),
    ORANGE(1, "orange", 16351261, MaterialColor.f_76413_, 15435844, 16738335),
    MAGENTA(2, "magenta", 13061821, MaterialColor.f_76414_, 12801229, 0xFF00FF),
    LIGHT_BLUE(3, "light_blue", 3847130, MaterialColor.f_76415_, 6719955, 10141901),
    YELLOW(4, "yellow", 16701501, MaterialColor.f_76416_, 14602026, 0xFFFF00),
    LIME(5, "lime", 8439583, MaterialColor.f_76417_, 4312372, 0xBFFF00),
    PINK(6, "pink", 15961002, MaterialColor.f_76418_, 14188952, 16738740),
    GRAY(7, "gray", 4673362, MaterialColor.f_76419_, 0x434343, 0x808080),
    LIGHT_GRAY(8, "light_gray", 0x9D9D97, MaterialColor.f_76420_, 0xABABAB, 0xD3D3D3),
    CYAN(9, "cyan", 1481884, MaterialColor.f_76421_, 2651799, 65535),
    PURPLE(10, "purple", 8991416, MaterialColor.f_76422_, 8073150, 10494192),
    BLUE(11, "blue", 3949738, MaterialColor.f_76361_, 2437522, 255),
    BROWN(12, "brown", 8606770, MaterialColor.f_76362_, 5320730, 9127187),
    GREEN(13, "green", 6192150, MaterialColor.f_76363_, 3887386, 65280),
    RED(14, "red", 11546150, MaterialColor.f_76364_, 11743532, 0xFF0000),
    BLACK(15, "black", 0x1D1D21, MaterialColor.f_76365_, 0x1E1B1B, 0);

    private final int index;
    private final String name;
    private final int textureColor;
    private final MaterialColor materialColor;
    private final int fireworkColor;
    private final int textColor;

    private PaintColor(int index, String name, int textureColor, MaterialColor materialColor, int fireworkColor, int textColor) {
        this.index = index;
        this.name = name;
        this.textureColor = textureColor;
        this.materialColor = materialColor;
        this.fireworkColor = fireworkColor;
        this.textColor = textColor;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public int getTextureColor() {
        return this.textureColor;
    }

    public MaterialColor getMaterialColor() {
        return this.materialColor;
    }

    public int getFireworkColor() {
        return this.fireworkColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public static PaintColor getByIndex(int index) {
        return Arrays.stream(PaintColor.values()).filter(x -> x.getIndex() == index).findFirst().orElse(WHITE);
    }

    public static PaintColor getByDye(DyeItem item) {
        return Arrays.stream(PaintColor.values()).filter(x -> x.getIndex() == item.m_41089_().m_41060_()).findFirst().orElse(WHITE);
    }

    public static PaintColor getByDye(DyeColor color) {
        return Arrays.stream(PaintColor.values()).filter(x -> x.getIndex() == color.m_41060_()).findFirst().orElse(WHITE);
    }

    public static boolean useWhiteOrBlackForeColor(int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        double luminance = (0.299 * (double)red + 0.587 * (double)green + 0.114 * (double)blue) / 255.0;
        return luminance < 0.5;
    }

    public String m_7912_() {
        return "paint_color";
    }

    public String getEnumName() {
        return "paint_color";
    }

    public String getEnumValueName() {
        return this.name;
    }
}

