/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.item;

import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.block.PaintBucketBlock;
import de.mrjulsen.trafficcraft.block.data.IColorBlockEntity;
import de.mrjulsen.trafficcraft.block.data.IPaintableBlock;
import de.mrjulsen.trafficcraft.client.ClientWrapper;
import de.mrjulsen.trafficcraft.data.PaintColor;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BrushItem
extends Item {
    public static final String NBT_PATTERN = "pattern";
    public static final String NBT_PAINT = "paint";
    public static final String NBT_COLOR = "color";
    private int paintAmount = 0;

    public BrushItem(Item.Properties properties, int paintAmount) {
        super(properties.m_41487_(1));
        this.paintAmount = paintAmount;
    }

    public boolean m_6777_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        Block block;
        if (player.m_7500_() && (block = state.m_60734_()) instanceof IPaintableBlock) {
            IPaintableBlock block2 = (IPaintableBlock)block;
            block2.onRemoveColor(state, worldIn, pos, player);
            return false;
        }
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        CompoundTag nbt = BrushItem.checkNbt(stack);
        stack.m_41751_(nbt);
        if (level.f_46443_) {
            ClientWrapper.showPaintBrushScreen(nbt.m_128451_(NBT_PATTERN), nbt.m_128451_(NBT_PAINT), PaintColor.getByIndex(nbt.m_128451_(NBT_COLOR)));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void m_7373_(ItemStack stack, Level player, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, player, list, flag);
        if (stack.m_41782_()) {
            PaintColor paintColor = PaintColor.getByIndex(stack.m_41783_().m_128451_(NBT_COLOR));
            String color = TextUtils.translate((String)paintColor.getValueTranslationKey("trafficcraft")).getString();
            list.add((Component)TextUtils.translate((String)"item.trafficcraft.paint_brush.tooltip.pattern", (Object[])new Object[]{"\u00a7f" + stack.m_41783_().m_128451_(NBT_PATTERN)}).m_130940_(ChatFormatting.GRAY));
            if (stack.m_41783_().m_128451_(NBT_PAINT) == 0) {
                list.add((Component)TextUtils.translate((String)"item.trafficcraft.paint_brush.tooltip.color", (Object[])new Object[]{TextUtils.translate((String)"item.trafficcraft.paint_brush.tooltip.color_empty")}).m_130940_(ChatFormatting.GRAY));
            } else {
                list.add((Component)TextUtils.translate((String)"item.trafficcraft.paint_brush.tooltip.color", (Object[])new Object[]{TextUtils.text((String)color).m_130948_(Style.f_131099_.m_131157_(ChatFormatting.WHITE).m_178520_(paintColor.getTextureColor()))}).m_130940_(ChatFormatting.GRAY));
            }
            list.add((Component)TextUtils.translate((String)"item.trafficcraft.paint_brush.tooltip.paint", (Object[])new Object[]{"\u00a7f" + (int)(0.78125f * (float)stack.m_41783_().m_128451_(NBT_PAINT))}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean m_142522_(ItemStack stack) {
        return BrushItem.checkNbt(stack).m_128451_(NBT_PAINT) > 0;
    }

    public int m_142158_(ItemStack stack) {
        return BrushItem.checkNbt(stack).m_128451_(NBT_PAINT) * 13 / 128;
    }

    public int m_142159_(ItemStack pStack) {
        return BrushItem.getColor(pStack).getTextureColor();
    }

    public static CompoundTag checkNbt(ItemStack stack) {
        CompoundTag nbt;
        if (stack.m_41782_()) {
            nbt = stack.m_41783_();
        } else {
            nbt = new CompoundTag();
            nbt.m_128405_(NBT_PAINT, 0);
            nbt.m_128405_(NBT_PATTERN, 0);
            nbt.m_128405_(NBT_COLOR, -1);
        }
        return nbt;
    }

    public int getPaintAmount() {
        return this.paintAmount;
    }

    public static PaintColor getColor(ItemStack stack) {
        return PaintColor.getByIndex(BrushItem.checkNbt(stack).m_128451_(NBT_COLOR));
    }

    public static int getPatternId(ItemStack stack) {
        return BrushItem.checkNbt(stack).m_128451_(NBT_PATTERN);
    }

    public static int getPaint(ItemStack stack) {
        return BrushItem.checkNbt(stack).m_128451_(NBT_PAINT);
    }

    public int getMaxPaint() {
        return 128;
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Level level = pContext.m_43725_();
        CompoundTag nbt = BrushItem.checkNbt(pContext.m_43722_());
        pContext.m_43722_().m_41751_(nbt);
        if (nbt.m_128451_(NBT_PAINT) <= 0) {
            return InteractionResult.FAIL;
        }
        BlockPos pos = pContext.m_8083_();
        BlockState state = pContext.m_43725_().m_8055_(pos);
        Player player = pContext.m_43723_();
        if (state.m_60734_() instanceof PaintBucketBlock) {
            level.m_5594_(null, pos, SoundEvents.f_11783_, SoundSource.BLOCKS, 0.8f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        Block block = state.m_60734_();
        if (block instanceof IPaintableBlock) {
            IColorBlockEntity blockEntity;
            IPaintableBlock block2 = (IPaintableBlock)block;
            BlockEntity blockEntity2 = level.m_7702_(pos);
            if (blockEntity2 instanceof IColorBlockEntity && (blockEntity = (IColorBlockEntity)blockEntity2).getColor() == PaintColor.getByIndex(nbt.m_128451_(NBT_COLOR))) {
                InteractionResult res = block2.update(pContext);
                if (res == InteractionResult.CONSUME) {
                    this.removePaint(player, nbt);
                    res = InteractionResult.SUCCESS;
                }
                return res;
            }
            InteractionResult res = block2.onSetColor(pContext);
            if (res == InteractionResult.CONSUME) {
                this.removePaint(player, nbt);
                res = InteractionResult.SUCCESS;
            }
            return res;
        }
        return InteractionResult.PASS;
    }

    private void removePaint(Player player, CompoundTag nbt) {
        if (!player.m_7500_()) {
            nbt.m_128405_(NBT_PAINT, nbt.m_128451_(NBT_PAINT) - 1);
        }
    }
}

