/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.item;

import de.mrjulsen.trafficcraft.Constants;
import de.mrjulsen.trafficcraft.client.ClientWrapper;
import de.mrjulsen.trafficcraft.data.NamedTrafficSignTextureReference;
import de.mrjulsen.trafficcraft.item.PatternCatalogueItem;
import java.util.List;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class CreativePatternCatalogueItem
extends PatternCatalogueItem {
    private static final String NBT_CUSTOM = "custom";

    public CreativePatternCatalogueItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    @Override
    public int getMaxPatterns() {
        return Short.MAX_VALUE;
    }

    public void m_7373_(ItemStack stack, Level player, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, player, list, flag);
        list.add((Component)Constants.CREATIVE_MODE_ONLY_TOOLTIP);
    }

    public boolean m_5812_(ItemStack pStack) {
        return true;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_) {
            ClientWrapper.showSignPatternSelectionScreen(stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Override
    public NamedTrafficSignTextureReference getSelectedImageData(ItemStack stack) {
        return CreativePatternCatalogueItem.shouldUseCustomPattern(stack) ? CreativePatternCatalogueItem.getCustomImage(stack) : super.getSelectedImageData(stack);
    }

    public static void setCustomImage(ItemStack stack, NamedTrafficSignTextureReference data) {
        CreativePatternCatalogueItem.checkNbt(stack).m_128365_(NBT_CUSTOM, (Tag)data.toNbt());
    }

    public static void clearCustomImage(ItemStack stack) {
        CreativePatternCatalogueItem.checkNbt(stack).m_128473_(NBT_CUSTOM);
    }

    public static NamedTrafficSignTextureReference getCustomImage(ItemStack stack) {
        if (CreativePatternCatalogueItem.hasCustomPattern(stack)) {
            return NamedTrafficSignTextureReference.fromNbt(CreativePatternCatalogueItem.checkNbt(stack).m_128469_(NBT_CUSTOM));
        }
        return null;
    }

    public static boolean hasCustomPattern(ItemStack stack) {
        return CreativePatternCatalogueItem.checkNbt(stack).m_128441_(NBT_CUSTOM);
    }

    public static boolean shouldUseCustomPattern(ItemStack stack) {
        return CreativePatternCatalogueItem.checkNbt(stack).m_128441_(NBT_CUSTOM) && !CreativePatternCatalogueItem.indexInBounds(stack, CreativePatternCatalogueItem.getSelectedIndex(stack));
    }
}

