/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.item;

import de.mrjulsen.trafficcraft.client.ClientWrapper;
import de.mrjulsen.trafficcraft.client.tooltip.TrafficSignTooltip;
import de.mrjulsen.trafficcraft.data.NamedTrafficSignTextureReference;
import de.mrjulsen.trafficcraft.data.TrafficSignData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PatternCatalogueItem
extends Item {
    @Deprecated
    private static final String NBT_LEGACY_PATTERNS = "patterns";
    private static final String NBT_SELECTED_INDEX = "SelectedIndex";
    private static final String NBT_TEXTURES = "TextureIds";
    private static final int MAX_SIGN_PATTERNS = 36;
    private static final Map<ItemStack, Optional<TooltipComponent>> tooltips = new HashMap<ItemStack, Optional<TooltipComponent>>();

    public PatternCatalogueItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_) {
            ClientWrapper.showSignPatternSelectionScreen(stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public int getMaxPatterns() {
        return 36;
    }

    protected static CompoundTag checkNbt(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128441_(NBT_TEXTURES)) {
            nbt.m_128365_(NBT_TEXTURES, (Tag)new ListTag());
        }
        if (nbt.m_128441_(NBT_LEGACY_PATTERNS)) {
            nbt.m_128437_(NBT_LEGACY_PATTERNS, 10).stream().forEach(x -> nbt.m_128437_(NBT_TEXTURES, 10).add((Object)TrafficSignData.migrate((CompoundTag)x).toNbt()));
            nbt.m_128473_(NBT_LEGACY_PATTERNS);
        }
        if (!nbt.m_128441_(NBT_SELECTED_INDEX)) {
            nbt.m_128405_(NBT_SELECTED_INDEX, 0);
        }
        return nbt;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack pStack) {
        Optional tooltip = tooltips.computeIfAbsent(pStack, x -> this.createTooltip((ItemStack)x));
        tooltip.ifPresent(x -> ((TrafficSignTooltip)x).initAgeable());
        return tooltip;
    }

    private Optional<TooltipComponent> createTooltip(ItemStack stck) {
        ItemStack stack = stck;
        NonNullList nonnulllist = NonNullList.m_122779_();
        if (stack.m_41782_()) {
            Arrays.stream(PatternCatalogueItem.getStoredPatterns(stack)).forEach(arg_0 -> nonnulllist.add(arg_0));
        }
        return Optional.of(new TrafficSignTooltip((NonNullList<NamedTrafficSignTextureReference>)nonnulllist, this.getSelectedImageData(stack), PatternCatalogueItem.getSelectedIndex(stack), () -> {
            if (tooltips.containsKey(stack)) {
                tooltips.remove(stack);
            }
        }));
    }

    public NamedTrafficSignTextureReference getSelectedImageData(ItemStack stack) {
        return PatternCatalogueItem.getSelectedPattern(stack);
    }

    protected static boolean indexInBounds(ItemStack stack, int index) {
        return index >= 0 && index < PatternCatalogueItem.getStoredPatternCount(stack);
    }

    public static int getSelectedIndex(ItemStack stack) {
        return PatternCatalogueItem.checkNbt(stack).m_128451_(NBT_SELECTED_INDEX);
    }

    public static short getStoredPatternCount(ItemStack stack) {
        return (short)PatternCatalogueItem.checkNbt(stack).m_128437_(NBT_TEXTURES, 10).size();
    }

    public static NamedTrafficSignTextureReference getPatternAt(ItemStack stack, int index) {
        if (!PatternCatalogueItem.indexInBounds(stack, index)) {
            return null;
        }
        return NamedTrafficSignTextureReference.fromNbt(PatternCatalogueItem.checkNbt(stack).m_128437_(NBT_TEXTURES, 10).m_128728_(index));
    }

    public static NamedTrafficSignTextureReference getSelectedPattern(ItemStack stack) {
        return PatternCatalogueItem.getPatternAt(stack, PatternCatalogueItem.getSelectedIndex(stack));
    }

    public static NamedTrafficSignTextureReference[] getStoredPatterns(ItemStack stack) {
        return (NamedTrafficSignTextureReference[])PatternCatalogueItem.checkNbt(stack).m_128437_(NBT_TEXTURES, 10).stream().map(x -> NamedTrafficSignTextureReference.fromNbt((CompoundTag)x)).toArray(NamedTrafficSignTextureReference[]::new);
    }

    public static boolean setPattern(ItemStack stack, NamedTrafficSignTextureReference pattern) {
        if (PatternCatalogueItem.getStoredPatternCount(stack) >= ((PatternCatalogueItem)stack.m_41720_()).getMaxPatterns()) {
            return false;
        }
        ListTag tag = PatternCatalogueItem.checkNbt(stack).m_128437_(NBT_TEXTURES, 10);
        tag.add((Object)pattern.toNbt());
        PatternCatalogueItem.setSelectedIndex(stack, tag.size() - 1);
        return true;
    }

    public static boolean replacePattern(ItemStack stack, NamedTrafficSignTextureReference pattern, int index) {
        if (PatternCatalogueItem.getStoredPatternCount(stack) >= ((PatternCatalogueItem)stack.m_41720_()).getMaxPatterns()) {
            return false;
        }
        PatternCatalogueItem.checkNbt(stack).m_128437_(NBT_TEXTURES, 10).set(index, (Tag)pattern.toNbt());
        PatternCatalogueItem.setSelectedIndex(stack, index);
        return true;
    }

    public static boolean removePatternAt(ItemStack stack, int index) {
        if (!PatternCatalogueItem.indexInBounds(stack, index)) {
            return false;
        }
        PatternCatalogueItem.checkNbt(stack).m_128437_(NBT_TEXTURES, 10).remove(index);
        short count = PatternCatalogueItem.getStoredPatternCount(stack);
        if (index >= count) {
            PatternCatalogueItem.setSelectedIndex(stack, Math.max(0, count - 1));
        }
        return true;
    }

    public static void clearPatterns(ItemStack stack) {
        PatternCatalogueItem.checkNbt(stack).m_128437_(NBT_TEXTURES, 10).clear();
        if (PatternCatalogueItem.checkNbt(stack).m_128441_(NBT_LEGACY_PATTERNS)) {
            PatternCatalogueItem.checkNbt(stack).m_128437_(NBT_LEGACY_PATTERNS, 10).clear();
        }
    }

    public static void setSelectedIndex(ItemStack stack, int index) {
        PatternCatalogueItem.checkNbt(stack).m_128405_(NBT_SELECTED_INDEX, Mth.m_14045_((int)index, (int)-1, (int)Math.max(0, PatternCatalogueItem.getStoredPatternCount(stack) - 1)));
    }
}

