/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.math.Vector3f;
import de.mrjulsen.mcdragonlib.core.Location;
import de.mrjulsen.mcdragonlib.data.StatusResult;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.block.data.RoadType;
import de.mrjulsen.trafficcraft.client.ClientWrapper;
import de.mrjulsen.trafficcraft.config.ModCommonConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RoadConstructionTool
extends Item {
    public static final String NBT_LOCATION1 = "Location1";
    public static final String NBT_LOCATION2 = "Location2";
    public static final String NBT_ROAD_WIDTH = "RoadWidth";
    public static final String NBT_REPLACE_BLOCKS = "ReplaceBlocks";
    public static final String NBT_ROAD_TYPE = "RoadType";
    public static final boolean DEFAULT_REPLACE_BLOCKS = true;
    public static final byte DEFAULT_ROAD_WIDTH = 7;
    public static final RoadType DEFAULT_ROAD_TYPE = RoadType.ASPHALT;
    private static final int ERROR_TOO_FAR = 1;
    private static final int ERROR_SLOPE_TOO_STEEP = 2;
    public static final int BUILD_DELAY_TICKS = 4;
    private static byte clientTicks;
    private static final byte FAST_GRAPHICS_CLIENT_TICK_DELAY = 8;
    private static final byte FANCY_GRAPHICS_CLIENT_TICK_DELAY = 4;
    private final float attackDamage;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public RoadConstructionTool(Tiers tier, Item.Properties properties) {
        super(properties.m_41487_(1).m_41503_(tier.m_6609_() * 6));
        float attackDamageModifier = 0.5f;
        this.attackDamage = tier.m_6631_() + attackDamageModifier;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", -3.0, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Level level = pContext.m_43725_();
        BlockPos clickedPos = pContext.m_8083_();
        Vec3 clickedVec = pContext.m_43720_();
        Player player = pContext.m_43723_();
        if (!player.m_6144_()) {
            if (!level.f_46443_) {
                CompoundTag compound = pContext.m_43722_().m_41784_();
                Location location = new Location((double)clickedPos.m_123341_(), clickedVec.f_82480_, (double)clickedPos.m_123343_(), level.m_46472_().m_135782_().toString());
                if (compound.m_128441_(NBT_LOCATION1)) {
                    if (RoadConstructionTool.isLineValid(Location.fromNbt((CompoundTag)compound.m_128469_(NBT_LOCATION1)).getLocationVec3(), location.getLocationVec3()).result()) {
                        compound.m_128365_(NBT_LOCATION2, (Tag)location.toNbt());
                    }
                } else {
                    compound.m_128365_(NBT_LOCATION1, (Tag)location.toNbt());
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(pContext);
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
    }

    public boolean m_41465_() {
        return true;
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot pSlot) {
        return pSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(pSlot);
    }

    public boolean m_5812_(ItemStack pStack) {
        CompoundTag tag = pStack.m_41783_();
        return tag != null && (tag.m_128441_(NBT_LOCATION1) || tag.m_128441_(NBT_LOCATION2)) || super.m_5812_(pStack);
    }

    public static void reset(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128473_(NBT_LOCATION1);
        nbt.m_128473_(NBT_LOCATION2);
        nbt.m_128379_(NBT_REPLACE_BLOCKS, true);
        nbt.m_128344_(NBT_ROAD_WIDTH, (byte)7);
        nbt.m_128405_(NBT_ROAD_TYPE, DEFAULT_ROAD_TYPE.getIndex());
    }

    public static void initStackTag(ItemStack stack) {
        if (!stack.m_41783_().m_128441_(NBT_ROAD_WIDTH)) {
            stack.m_41783_().m_128344_(NBT_ROAD_WIDTH, (byte)7);
        }
        if (!stack.m_41783_().m_128441_(NBT_ROAD_TYPE)) {
            stack.m_41783_().m_128405_(NBT_ROAD_TYPE, DEFAULT_ROAD_TYPE.getIndex());
        }
        if (!stack.m_41783_().m_128441_(NBT_REPLACE_BLOCKS)) {
            stack.m_41783_().m_128379_(NBT_REPLACE_BLOCKS, true);
        }
    }

    private static StatusResult isLineValid(Vec3 a, Vec3 b) {
        boolean flag1 = a.m_82554_(b) < (double)((Integer)ModCommonConfig.ROAD_BUILDER_MAX_DISTANCE.get()).intValue();
        boolean flag2 = MathUtils.slope((Vec3)a, (Vec3)b) >= (Double)ModCommonConfig.ROAD_BUILDER_MAX_SLOPE.get();
        int status = 0;
        if (!flag1) {
            status = 1;
        } else if (!flag2) {
            status = 2;
        }
        return new StatusResult(flag1 && flag2, status, null);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemstack = pPlayer.m_21120_(pUsedHand);
        RoadConstructionTool.initStackTag(itemstack);
        Location startLoc = Location.fromNbt((CompoundTag)itemstack.m_41783_().m_128469_(NBT_LOCATION1));
        Location endLoc = Location.fromNbt((CompoundTag)itemstack.m_41783_().m_128469_(NBT_LOCATION2));
        Collection<Object> blockList = new ArrayList();
        if (endLoc != null && startLoc != null) {
            Vec3 start = startLoc.getLocationVec3();
            Vec3 end = endLoc.getLocationVec3();
            byte roadWidth = itemstack.m_41783_().m_128445_(NBT_ROAD_WIDTH);
            boolean replaceBlocks = true;
            blockList = RoadConstructionTool.calculateRoad(pLevel, start, end, roadWidth, replaceBlocks);
        }
        if (pLevel.f_46443_) {
            ClientWrapper.showRoadConstructionToolScreen(itemstack, (int)blockList.stream().flatMap(x -> x.values().stream()).filter(v -> v <= 0 || v >= 8).count(), blockList.stream().flatMap(x -> x.values().stream()).filter(v -> v > 0 && v < 8).mapToInt(x -> x).sum());
        }
        return InteractionResultHolder.m_19090_((Object)itemstack);
    }

    public static RoadBuilderCountResult countBlocksNeeded(Level level, Vec3 start, Vec3 end, byte roadWidth, boolean replaceBlocks) {
        Collection<Object> blockList = new ArrayList();
        blockList = RoadConstructionTool.calculateRoad(level, start, end, roadWidth, replaceBlocks);
        return new RoadBuilderCountResult((int)blockList.stream().flatMap(x -> x.values().stream()).filter(v -> v <= 0 || v >= 8).count(), blockList.stream().flatMap(x -> x.values().stream()).filter(v -> v > 0 && v < 8).mapToInt(x -> x).sum());
    }

    public static Collection<Map<BlockPos, Integer>> calculateRoad(Level level, Vec3 start, Vec3 end, byte roadWidth, boolean replaceBlocks) {
        double spacingMul = 2.0;
        if (start.f_82480_ > end.f_82480_) {
            Vec3 temp = end;
            end = start;
            start = temp;
        }
        Vec3 vec = new Vec3(end.f_82479_, end.f_82480_, end.f_82481_).m_82546_(start);
        Vec3 rVec = new Vec3(vec.f_82481_, 0.0, -vec.f_82479_).m_82541_();
        double lastY = Double.MIN_VALUE;
        ArrayList<Map<BlockPos, Integer>> blockList = new ArrayList<Map<BlockPos, Integer>>();
        int i = 0;
        while ((double)i <= vec.m_82553_() * 2.0) {
            double d;
            double a = d = 1.0 / vec.m_82553_() / 2.0 * (double)i;
            HashMap<BlockPos, Integer> blockLayer = new HashMap<BlockPos, Integer>();
            Vec3 vecPos = new Vec3(vec.f_82479_ * a, vec.f_82480_ * a, vec.f_82481_ * a).m_82549_(start);
            Vec3 rightVec = i == 0 ? rVec.m_82541_() : new Vec3(vec.f_82481_ * a, 0.0, -(vec.f_82479_ * a)).m_82541_();
            lastY = RoadConstructionTool.setLayer(level, lastY, vecPos, rightVec, blockLayer, roadWidth, replaceBlocks);
            blockList.forEach(x -> x.entrySet().removeIf(y -> blockLayer.keySet().stream().anyMatch(z -> ((BlockPos)y.getKey()).equals(z))));
            blockList.add(blockLayer);
            ++i;
        }
        return blockList;
    }

    public static RoadBuildingData prepareRoadBuilding(Level pLevel, Player pPlayer, InteractionHand pHand, ItemStack pStack, Vec3 start, Vec3 end, byte roadWidth, boolean replaceBlocks, RoadType roadType) {
        Collection<Map<BlockPos, Integer>> blockList = RoadConstructionTool.calculateRoad(pLevel, start, end, roadWidth, replaceBlocks);
        pPlayer.m_36335_().m_41524_(pStack.m_41720_(), blockList.size() * 4);
        if (!pLevel.f_46443_) {
            DLUtils.giveAdvancement((ServerPlayer)((ServerPlayer)pPlayer), (String)"trafficcraft", (String)"road_construction_tool", (String)"req");
        }
        return new RoadBuildingData(blockList, pPlayer, pHand, pStack, start, end, roadWidth, replaceBlocks, roadType);
    }

    private static double setLayer(Level pLevel, double lastY, Vec3 pos, Vec3 normalizedRightVec, Map<BlockPos, Integer> blockList, byte roadWidth, boolean replaceBlocks) {
        block8: {
            BlockPos bPos;
            Vec3 vec;
            double i;
            double height;
            double halfWidth;
            block7: {
                halfWidth = (double)roadWidth / 2.0 - 0.5;
                double step = 0.5;
                double pixel = 0.0625;
                double slopeHeight = 0.125;
                double d = pos.f_82480_ < 0.0 ? pos.f_82480_ - (double)((int)pos.f_82480_) + (double)(!(Math.abs(pos.f_82480_ - (double)((int)pos.f_82480_)) <= 0.0) ? 1 : 0) : (height = pos.f_82480_ - (double)((int)pos.f_82480_));
                if (lastY < (double)((int)pos.f_82480_) + 0.125) {
                    for (i = -halfWidth; i < halfWidth + 0.5; i += 0.5) {
                        vec = pos.m_82549_(normalizedRightVec.m_82490_(i));
                        bPos = new BlockPos(vec.f_82479_, vec.f_82480_ - 1.0, vec.f_82481_);
                        if (!replaceBlocks && !pLevel.m_46859_(bPos)) continue;
                        if (blockList.containsKey(bPos)) {
                            blockList.remove(bPos);
                        }
                        blockList.put(bPos, 8);
                    }
                }
                if (!(height >= 1.0625)) break block7;
                for (i = -halfWidth; i < halfWidth + 0.5; i += 0.5) {
                    vec = pos.m_82549_(normalizedRightVec.m_82490_(i));
                    bPos = new BlockPos(vec);
                    if (!replaceBlocks && !pLevel.m_46859_(bPos)) continue;
                    if (blockList.containsKey(bPos)) {
                        blockList.remove(bPos);
                    }
                    blockList.put(bPos, 8);
                }
                break block8;
            }
            if (!(height >= 0.125)) break block8;
            for (i = -halfWidth; i < halfWidth + 0.5; i += 0.5) {
                vec = pos.m_82549_(normalizedRightVec.m_82490_(i));
                bPos = new BlockPos(vec);
                if (!replaceBlocks && !pLevel.m_46859_(bPos)) continue;
                if (blockList.containsKey(bPos)) {
                    blockList.remove(bPos);
                }
                blockList.put(bPos, (int)(height / 0.125));
            }
        }
        return pos.f_82480_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientTick() {
        if ((clientTicks = (byte)(clientTicks + 1)) > (Minecraft.m_91405_() ? (byte)4 : 8)) {
            clientTicks = 0;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (player == null || level == null) {
            return;
        }
        if (Minecraft.m_91087_().f_91080_ != null) {
            return;
        }
        if (!(player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof RoadConstructionTool) && !(player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof RoadConstructionTool)) {
            return;
        }
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof RoadConstructionTool ? player.m_21120_(InteractionHand.MAIN_HAND) : player.m_21120_(InteractionHand.OFF_HAND);
        CompoundTag nbt = stack.m_41784_();
        RoadConstructionTool.initStackTag(stack);
        if (!nbt.m_128441_(NBT_LOCATION1)) {
            return;
        }
        Vec3 start = Location.fromNbt((CompoundTag)nbt.m_128469_(NBT_LOCATION1)).getLocationVec3().m_82520_(0.5, 0.0, 0.5);
        Vec3 end = null;
        if (nbt.m_128441_(NBT_LOCATION1) && !nbt.m_128441_(NBT_LOCATION2)) {
            HitResult lookingAt = player.m_19907_(4.5, 0.0f, false);
            Vec3 lookAtVec = lookingAt.m_82450_();
            if (!level.m_46859_(new BlockPos(lookAtVec)) || !level.m_46859_(new BlockPos(lookAtVec.f_82479_, lookAtVec.f_82480_ - 0.5, lookAtVec.f_82481_))) {
                double blockHeight = level.m_45573_(new BlockPos(lookAtVec));
                int vX = lookAtVec.m_7096_() > 0.0 ? 1 : -1;
                int vZ = lookAtVec.m_7094_() > 0.0 ? 1 : -1;
                end = new Vec3((double)((int)lookAtVec.m_7096_()) + (double)vX * 0.5, (double)((int)lookAtVec.m_7098_()) + (blockHeight <= 0.0 ? 0.0 : blockHeight), (double)((int)lookAtVec.m_7094_()) + (double)vZ * 0.5);
            } else {
                end = null;
            }
            player.m_5661_((Component)TextUtils.translate((String)"item.trafficcraft.road_construction_tool.status_pos1", (Object[])new Object[]{Location.fromNbt((CompoundTag)nbt.m_128469_(NBT_LOCATION1)).getLocationBlockPos().m_123344_()}), true);
        } else if (nbt.m_128441_(NBT_LOCATION1) && nbt.m_128441_(NBT_LOCATION2)) {
            end = Location.fromNbt((CompoundTag)nbt.m_128469_(NBT_LOCATION2)).getLocationVec3().m_82520_(0.5, 0.0, 0.5);
            player.m_5661_((Component)TextUtils.translate((String)"item.trafficcraft.road_construction_tool.status_pos2", (Object[])new Object[]{Location.fromNbt((CompoundTag)nbt.m_128469_(NBT_LOCATION1)).getLocationBlockPos().m_123344_(), Location.fromNbt((CompoundTag)nbt.m_128469_(NBT_LOCATION2)).getLocationBlockPos().m_123344_()}).m_130940_(ChatFormatting.GREEN), true);
        }
        if (end == null) {
            return;
        }
        Vec3 line = end.m_82546_(start);
        double width = nbt.m_128445_(NBT_ROAD_WIDTH);
        double halfWidth = width / 2.0;
        double spacing = 0.25;
        if (line.m_82553_() <= 0.0) {
            return;
        }
        if (line.m_82553_() < 256.0) {
            double mul = 1.0 / Math.min(line.m_82553_(), 256.0) * 0.25;
            int lineStatus = RoadConstructionTool.isLineValid(start, end).code();
            switch (lineStatus) {
                case 1: {
                    player.m_5661_((Component)TextUtils.translate((String)"item.trafficcraft.road_construction_tool.status_too_far").m_130940_(ChatFormatting.RED), true);
                    break;
                }
                case 2: {
                    player.m_5661_((Component)TextUtils.translate((String)"item.trafficcraft.road_construction_tool.status_slope_too_steep").m_130940_(ChatFormatting.RED), true);
                    break;
                }
            }
            if (clientTicks == 0) {
                for (double d = 0.0; d < 1.0; d += mul) {
                    Vec3 vecPos = new Vec3(line.f_82479_ * d, line.f_82480_ * d, line.f_82481_ * d).m_82549_(start);
                    level.m_7106_((ParticleOptions)new DustParticleOptions(RoadConstructionTool.isLineValid(start, end).result() ? new Vector3f(0.2f, 0.9f, 0.2f) : new Vector3f(0.9f, 0.2f, 0.2f), 1.0f), vecPos.f_82479_, vecPos.f_82480_, vecPos.f_82481_, 0.0, 0.0, 0.0);
                    Vec3 rightVec = vecPos.m_82549_(new Vec3(line.f_82481_ * d, 0.0, -line.f_82479_ * d).m_82541_().m_82490_(halfWidth));
                    level.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.6f), 0.5f), rightVec.f_82479_, rightVec.f_82480_, rightVec.f_82481_, 0.0, 0.0, 0.0);
                    Vec3 leftVec = vecPos.m_82549_(new Vec3(-line.f_82481_ * d, 0.0, line.f_82479_ * d).m_82541_().m_82490_(halfWidth));
                    level.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.6f), 0.5f), leftVec.f_82479_, leftVec.f_82480_, leftVec.f_82481_, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public static class RoadBuilderCountResult {
        public final int blocksCount;
        public final int slopesCount;

        protected RoadBuilderCountResult(int blocksCount, int slopesCount) {
            this.blocksCount = blocksCount;
            this.slopesCount = slopesCount;
        }
    }

    public static class RoadBuildingData {
        public final List<Map<BlockPos, Integer>> blocks;
        public final Player player;
        public final InteractionHand hand;
        public final ItemStack item;
        public final Vec3 start;
        public final Vec3 end;
        public final byte roadWidth;
        public final boolean replaceBlocks;
        public final RoadType roadType;

        public RoadBuildingData(Collection<Map<BlockPos, Integer>> blocks, Player player, InteractionHand hand, ItemStack item, Vec3 start, Vec3 end, byte roadWidth, boolean replaceBlocks, RoadType roadType) {
            this.blocks = new ArrayList<Map<BlockPos, Integer>>(blocks);
            this.player = player;
            this.hand = hand;
            this.item = item;
            this.start = start;
            this.end = end;
            this.roadWidth = roadWidth;
            this.replaceBlocks = replaceBlocks;
            this.roadType = roadType;
        }
    }
}

