/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.item;

import de.mrjulsen.mcdragonlib.core.IIterableEnum;
import de.mrjulsen.mcdragonlib.core.ITranslatableEnum;
import de.mrjulsen.mcdragonlib.core.Location;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.TrafficCraft;
import de.mrjulsen.trafficcraft.block.TrafficLightRequestButtonBlock;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightControllerBlockEntity;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightRequestButtonBlockEntity;
import de.mrjulsen.trafficcraft.item.ILinkerItem;
import de.mrjulsen.trafficcraft.item.IScrollEventItem;
import de.mrjulsen.trafficcraft.network.packets.cts.LinkerModePacket;
import de.mrjulsen.trafficcraft.registry.ModBlocks;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TrafficLightLinkerItem
extends Item
implements ILinkerItem,
IScrollEventItem {
    public static final String NBT_LINK_TARGET = "LinkTargetLocation";
    public static final String NBT_MODE = "Mode";
    public static final String NBT_BLOCK = "Block";
    private static final Component textNoLink = TextUtils.translate((String)"item.trafficcraft.traffic_light_linker.tooltip.nolink").m_130940_(ChatFormatting.GRAY);
    private static final Component textNotLoaded = TextUtils.translate((String)"item.trafficcraft.traffic_light_linker.use.target_not_loaded").m_130940_(ChatFormatting.RED);
    private static final Component textClear = TextUtils.translate((String)"item.trafficcraft.traffic_light_linker.use.clear");
    private static final Component textTooltipInstruction = TextUtils.translate((String)"item.trafficcraft.traffic_light_linker.tooltip_instruction").m_130940_(ChatFormatting.ITALIC);
    private static final String keySet = "item.trafficcraft.traffic_light_linker.use.set";
    private static final String keyWrongDim = "item.trafficcraft.traffic_light_linker.use.wrong_dimension";
    private static final String keySetLink = "item.trafficcraft.traffic_light_linker.use.link";
    private static final String keyRemoveLink = "item.trafficcraft.traffic_light_linker.use.unlink";
    private static final String keyTooltipLocation = "item.trafficcraft.traffic_light_linker.tooltip_location";
    private static final String keyTooltipBlock = "item.trafficcraft.traffic_light_linker.tooltip_block";
    private static final String keyTooltipMode = "item.trafficcraft.traffic_light_linker.tooltip_mode";

    public TrafficLightLinkerItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Level level = pContext.m_43725_();
        BlockPos clickedPos = pContext.m_8083_();
        Player player = pContext.m_43723_();
        if (!player.m_6144_()) {
            Block clickedBlock = pContext.m_43725_().m_8055_(clickedPos).m_60734_();
            CompoundTag nbt = this.doesContainValidLinkData(pContext.m_43722_());
            if (nbt == null && this.isSourceBlockAccepted(clickedBlock)) {
                if (!level.f_46443_) {
                    CompoundTag compound = pContext.m_43722_().m_41784_();
                    compound.m_128365_(NBT_LINK_TARGET, (Tag)new Location(clickedPos.m_123341_(), clickedPos.m_123342_(), clickedPos.m_123343_(), level.m_46472_().m_135782_().toString()).toNbt());
                    compound.m_128359_(NBT_BLOCK, Registry.f_122824_.m_7981_((Object)clickedBlock).toString());
                    player.m_5661_((Component)TextUtils.translate((String)keySet, (Object[])new Object[]{clickedPos.m_123344_(), level.m_46472_().m_135782_()}).m_130940_(ChatFormatting.AQUA), true);
                }
                return InteractionResult.SUCCESS;
            }
            if (this.isTargetBlockAccepted(clickedBlock)) {
                BlockEntity blockEntity;
                if (nbt == null) {
                    return InteractionResult.FAIL;
                }
                Location linkLoc = Location.fromNbt((CompoundTag)nbt.m_128469_(NBT_LINK_TARGET));
                LinkerMode mode = LinkerMode.getByIndex(nbt.m_128451_(NBT_MODE));
                if (!pContext.m_43725_().m_46472_().m_135782_().toString().equals(linkLoc.dimension)) {
                    player.m_5661_((Component)TextUtils.translate((String)keyWrongDim).m_130940_(ChatFormatting.RED), true);
                }
                if (clickedBlock instanceof TrafficLightRequestButtonBlock && (blockEntity = pContext.m_43725_().m_7702_(clickedPos)) instanceof TrafficLightRequestButtonBlockEntity) {
                    TrafficLightRequestButtonBlockEntity blockEntity2 = (TrafficLightRequestButtonBlockEntity)blockEntity;
                    switch (mode.ordinal()) {
                        case 1: {
                            blockEntity2.clearLink();
                            player.m_5661_((Component)TextUtils.translate((String)keyRemoveLink, (Object[])new Object[]{linkLoc.getLocationBlockPos().m_123344_(), level.m_46472_().m_135782_()}).m_130940_(ChatFormatting.RED), true);
                            break;
                        }
                        default: {
                            blockEntity2.linkTo(linkLoc);
                            player.m_5661_((Component)TextUtils.translate((String)keySetLink, (Object[])new Object[]{linkLoc.getLocationBlockPos().m_123344_(), level.m_46472_().m_135782_()}).m_130940_(ChatFormatting.GREEN), true);
                            break;
                        }
                    }
                } else if (pContext.m_43725_().m_46749_(linkLoc.getLocationBlockPos()) && this.isSourceBlockAccepted(pContext.m_43725_().m_8055_(linkLoc.getLocationBlockPos()).m_60734_())) {
                    BlockEntity blockEntity3 = pContext.m_43725_().m_7702_(linkLoc.getLocationBlockPos());
                    if (blockEntity3 instanceof TrafficLightControllerBlockEntity) {
                        TrafficLightControllerBlockEntity blockEntity4 = (TrafficLightControllerBlockEntity)blockEntity3;
                        BlockPos pos = pContext.m_8083_();
                        String dim = pContext.m_43725_().m_46472_().m_135782_().toString();
                        switch (mode.ordinal()) {
                            case 1: {
                                blockEntity4.removeTrafficLightLocation(new Location(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), dim));
                                player.m_5661_((Component)TextUtils.translate((String)keyRemoveLink, (Object[])new Object[]{linkLoc.getLocationBlockPos().m_123344_(), level.m_46472_().m_135782_()}).m_130940_(ChatFormatting.RED), true);
                                break;
                            }
                            default: {
                                blockEntity4.addTrafficLightLocation(new Location(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), dim));
                                player.m_5661_((Component)TextUtils.translate((String)keySetLink, (Object[])new Object[]{linkLoc.getLocationBlockPos().m_123344_(), level.m_46472_().m_135782_()}).m_130940_(ChatFormatting.GREEN), true);
                            }
                        }
                    }
                } else {
                    player.m_5661_(textNotLoaded, true);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6225_(pContext);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemstack = pPlayer.m_21120_(pUsedHand);
        if (pPlayer.m_6144_()) {
            Level level = pPlayer.m_9236_();
            if (!level.f_46443_) {
                if (itemstack.m_41783_() != null) {
                    CompoundTag tag = itemstack.m_41783_();
                    tag.m_128473_(NBT_LINK_TARGET);
                    tag.m_128473_(NBT_BLOCK);
                }
                pPlayer.m_5661_(textClear, true);
            }
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        CompoundTag tag = null;
        tag = this.doesContainValidLinkData(pStack);
        if (tag != null) {
            Location loc = Location.fromNbt((CompoundTag)tag.m_128469_(NBT_LINK_TARGET));
            pTooltipComponents.add((Component)TextUtils.translate((String)keyTooltipLocation, (Object[])new Object[]{Integer.toString((int)loc.x), Integer.toString((int)loc.y), Integer.toString((int)loc.z), loc.dimension}));
        } else {
            pTooltipComponents.add(textNoLink);
        }
        CompoundTag nbt = pStack.m_41784_();
        LinkerMode mode = LinkerMode.getByIndex(nbt.m_128451_(NBT_MODE));
        if (nbt.m_128441_(NBT_BLOCK)) {
            try {
                ResourceLocation location = new ResourceLocation(nbt.m_128461_(NBT_BLOCK));
                pTooltipComponents.add((Component)TextUtils.translate((String)keyTooltipBlock, (Object[])new Object[]{((Block)Registry.f_122824_.m_7745_(location)).m_49954_().getString()}));
            }
            catch (Exception e) {
                pTooltipComponents.add((Component)TextUtils.translate((String)keyTooltipBlock, (Object[])new Object[]{TextUtils.text((String)"ERROR").m_130940_(ChatFormatting.RED)}));
            }
        }
        pTooltipComponents.add((Component)TextUtils.translate((String)keyTooltipMode, (Object[])new Object[]{TextUtils.translate((String)mode.getValueTranslationKey("trafficcraft")), TextUtils.translate((String)mode.getValueTranslationKey("trafficcraft"))}));
        pTooltipComponents.add(textTooltipInstruction);
    }

    public boolean m_5812_(ItemStack pStack) {
        return this.doesContainValidLinkData(pStack) != null || super.m_5812_(pStack);
    }

    public CompoundTag doesContainValidLinkData(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_(NBT_LINK_TARGET) ? tag : null;
    }

    @Override
    public boolean isTargetBlockAccepted(Block block) {
        return block.equals(ModBlocks.TRAFFIC_LIGHT.get()) || block.equals(ModBlocks.TRAFFIC_LIGHT_REQUEST_BUTTON.get());
    }

    @Override
    public boolean isSourceBlockAccepted(Block block) {
        return block.equals(ModBlocks.TRAFFIC_LIGHT_CONTROLLER.get()) || block.equals(ModBlocks.TRAFFIC_LIGHT.get());
    }

    @Override
    public boolean mouseScroll(Player player, ItemStack itemStack, double scrollDelta) {
        if (player.m_6047_()) {
            CompoundTag compound = itemStack.m_41784_();
            LinkerMode mode = LinkerMode.LINK;
            if (scrollDelta > 0.0) {
                mode = (LinkerMode)LinkerMode.getByIndex(compound.m_128451_(NBT_MODE)).next();
            } else if (scrollDelta < 0.0) {
                mode = (LinkerMode)LinkerMode.getByIndex(compound.m_128451_(NBT_MODE)).previous();
            }
            TrafficLightLinkerItem.setMode(itemStack, mode);
            TrafficCraft.net().sendToServer((Object)new LinkerModePacket(mode));
            player.m_5661_((Component)TextUtils.translate((String)keyTooltipMode, (Object[])new Object[]{TextUtils.translate((String)LinkerMode.getByIndex(compound.m_128451_(NBT_MODE)).getValueTranslationKey("trafficcraft")), TextUtils.translate((String)LinkerMode.getByIndex(compound.m_128451_(NBT_MODE)).getValueTranslationKey("trafficcraft"))}), true);
            return true;
        }
        return false;
    }

    public static void setMode(ItemStack item, LinkerMode mode) {
        CompoundTag compound = item.m_41784_();
        compound.m_128405_(NBT_MODE, mode.getIndex());
    }

    public static enum LinkerMode implements StringRepresentable,
    ITranslatableEnum,
    IIterableEnum<LinkerMode>
    {
        LINK(0, "link"),
        UNLINK(1, "unlink");

        private int index;
        private String name;

        private LinkerMode(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public static LinkerMode getByIndex(int index) {
            return Arrays.stream(LinkerMode.values()).filter(x -> x.getIndex() == index).findFirst().orElse(LINK);
        }

        public LinkerMode[] getValues() {
            return LinkerMode.values();
        }

        public String getEnumName() {
            return "linkermode";
        }

        public String getEnumValueName() {
            return this.getName();
        }

        public String m_7912_() {
            return this.getName();
        }
    }
}

