/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.network.packets.cts;

import de.mrjulsen.mcdragonlib.net.IPacketBase;
import de.mrjulsen.trafficcraft.block.data.RoadType;
import de.mrjulsen.trafficcraft.item.RoadConstructionTool;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public class RoadBuilderDataPacket
implements IPacketBase<RoadBuilderDataPacket> {
    private boolean replaceBlocks;
    private byte roadWidth;
    private RoadType roadType;

    public RoadBuilderDataPacket() {
    }

    public RoadBuilderDataPacket(boolean replaceBlocks, byte roadWidth, RoadType roadType) {
        this.replaceBlocks = replaceBlocks;
        this.roadWidth = roadWidth;
        this.roadType = roadType;
    }

    public void encode(RoadBuilderDataPacket packet, FriendlyByteBuf buffer) {
        buffer.writeBoolean(packet.replaceBlocks);
        buffer.writeByte((int)packet.roadWidth);
        buffer.m_130068_((Enum)packet.roadType);
    }

    public RoadBuilderDataPacket decode(FriendlyByteBuf buffer) {
        boolean replaceBlocks = buffer.readBoolean();
        byte roadWidth = buffer.readByte();
        RoadType roadType = (RoadType)buffer.m_130066_(RoadType.class);
        return new RoadBuilderDataPacket(replaceBlocks, roadWidth, roadType);
    }

    public void handle(RoadBuilderDataPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            ServerPlayer sender = (ServerPlayer)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            if (sender.m_21205_().m_41720_() instanceof RoadConstructionTool) {
                CompoundTag nbt = sender.m_21205_().m_41784_();
                nbt.m_128344_("RoadWidth", packet.roadWidth);
                nbt.m_128379_("ReplaceBlocks", packet.replaceBlocks);
                nbt.m_128405_("RoadType", packet.roadType.getIndex());
            } else if (sender.m_21206_().m_41720_() instanceof RoadConstructionTool) {
                CompoundTag nbt = sender.m_21206_().m_41784_();
                nbt.m_128344_("RoadWidth", packet.roadWidth);
                nbt.m_128379_("ReplaceBlocks", packet.replaceBlocks);
                nbt.m_128405_("RoadType", packet.roadType.getIndex());
            }
            sender.m_150109_().m_6596_();
        });
    }
}

