/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.network.packets.cts;

import de.mrjulsen.mcdragonlib.net.IPacketBase;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import de.mrjulsen.trafficcraft.item.StreetLampConfigCardItem;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public class StreetLampConfigPacket
implements IPacketBase<StreetLampConfigPacket> {
    private int turnOnTime;
    private int turnOffTime;
    private TimeUtils.TimeFormat timeFormat;

    public StreetLampConfigPacket() {
    }

    public StreetLampConfigPacket(int turnOnTime, int turnOffTime, TimeUtils.TimeFormat timeFormat) {
        this.turnOnTime = turnOnTime;
        this.turnOffTime = turnOffTime;
        this.timeFormat = timeFormat;
    }

    public void encode(StreetLampConfigPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.turnOnTime);
        buffer.writeInt(packet.turnOffTime);
        buffer.writeInt((int)packet.timeFormat.getIndex());
    }

    public StreetLampConfigPacket decode(FriendlyByteBuf buffer) {
        int turnOnTime = buffer.readInt();
        int turnOffTime = buffer.readInt();
        int timeFormat = buffer.readInt();
        return new StreetLampConfigPacket(turnOnTime, turnOffTime, TimeUtils.TimeFormat.getFormatByIndex((byte)((byte)timeFormat)));
    }

    public void handle(StreetLampConfigPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            ServerPlayer sender = (ServerPlayer)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            if (sender.m_21205_().m_41720_() instanceof StreetLampConfigCardItem) {
                CompoundTag nbt = sender.m_21205_().m_41784_();
                nbt.m_128405_("turnOnTime", packet.turnOnTime);
                nbt.m_128405_("turnOffTime", packet.turnOffTime);
                nbt.m_128405_("timeFormat", (int)packet.timeFormat.getIndex());
            } else if (sender.m_21206_().m_41720_() instanceof StreetLampConfigCardItem) {
                CompoundTag nbt = sender.m_21206_().m_41784_();
                nbt.m_128405_("turnOnTime", packet.turnOnTime);
                nbt.m_128405_("turnOffTime", packet.turnOffTime);
                nbt.m_128405_("timeFormat", (int)packet.timeFormat.getIndex());
            }
            sender.m_150109_().m_6596_();
        });
    }
}

