/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.network.packets.cts;

import de.mrjulsen.mcdragonlib.net.IPacketBase;
import de.mrjulsen.trafficcraft.block.TrafficLightBlock;
import de.mrjulsen.trafficcraft.block.data.TrafficLightColor;
import de.mrjulsen.trafficcraft.block.data.TrafficLightControlType;
import de.mrjulsen.trafficcraft.block.data.TrafficLightIcon;
import de.mrjulsen.trafficcraft.block.data.TrafficLightModel;
import de.mrjulsen.trafficcraft.block.data.TrafficLightType;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightBlockEntity;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TrafficLightPacket
implements IPacketBase<TrafficLightPacket> {
    private BlockPos pos;
    private Collection<TrafficLightColor> enabledColors;
    private TrafficLightType type;
    private TrafficLightModel model;
    private TrafficLightIcon icon;
    private TrafficLightControlType controlType;
    private TrafficLightColor[] colors;
    private int phaseId;
    private boolean scheduleEnabled;

    public TrafficLightPacket() {
    }

    public TrafficLightPacket(BlockPos pos, Collection<TrafficLightColor> enabledColors, TrafficLightType type, TrafficLightModel model, TrafficLightIcon icon, TrafficLightControlType controlType, TrafficLightColor[] colorSlots, int phaseId, boolean scheduleEnabled) {
        this.pos = pos;
        this.enabledColors = enabledColors;
        this.type = type;
        this.model = model;
        this.icon = icon;
        this.controlType = controlType;
        this.colors = colorSlots;
        this.phaseId = phaseId;
        this.scheduleEnabled = scheduleEnabled;
    }

    public void encode(TrafficLightPacket packet, FriendlyByteBuf buffer) {
        int i;
        buffer.m_130064_(packet.pos);
        TrafficLightColor[] enabledColorsArr = (TrafficLightColor[])packet.enabledColors.toArray(TrafficLightColor[]::new);
        buffer.writeBoolean(enabledColorsArr.length > 0);
        if (enabledColorsArr.length > 0) {
            byte[] enColBArr = new byte[enabledColorsArr.length];
            for (i = 0; i < enabledColorsArr.length; ++i) {
                enColBArr[i] = enabledColorsArr[i].getGroupIndex();
            }
            buffer.m_130087_(enColBArr);
        }
        buffer.writeByte((int)packet.type.getIndex());
        buffer.writeByte((int)packet.model.getLightsCount());
        buffer.writeByte((int)packet.icon.getIndex());
        buffer.writeByte((int)packet.controlType.getIndex());
        buffer.writeBoolean(packet.colors.length > 0);
        if (packet.colors.length > 0) {
            byte[] colSlBArr = new byte[packet.colors.length];
            for (i = 0; i < packet.colors.length; ++i) {
                colSlBArr[i] = packet.colors[i].getGroupIndex();
            }
            buffer.m_130087_(colSlBArr);
        }
        buffer.writeInt(packet.phaseId);
        buffer.writeBoolean(packet.scheduleEnabled);
    }

    public TrafficLightPacket decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        ArrayList<TrafficLightColor> enabledColors = new ArrayList<TrafficLightColor>();
        byte[] enColBArr = new byte[]{};
        if (buffer.readBoolean()) {
            enColBArr = buffer.m_130052_();
        }
        TrafficLightType type = TrafficLightType.getTypeByIndex(buffer.readByte());
        for (byte b : enColBArr) {
            enabledColors.add(TrafficLightColor.getColorByGroupIndex(b, type));
        }
        TrafficLightModel model = TrafficLightModel.getModelByLightsCount(buffer.readByte());
        TrafficLightIcon icon = TrafficLightIcon.getIconByIndex(buffer.readByte());
        TrafficLightControlType controlType = TrafficLightControlType.getControlTypeByIndex(buffer.readByte());
        TrafficLightColor[] colorSlots = new TrafficLightColor[TrafficLightModel.maxRequiredSlots()];
        if (buffer.readBoolean()) {
            byte[] colSlBArr = buffer.m_130052_();
            for (int i = 0; i < colSlBArr.length && i < colorSlots.length; ++i) {
                colorSlots[i] = TrafficLightColor.getColorByGroupIndex(colSlBArr[i], type);
            }
        }
        int phaseId = buffer.readInt();
        boolean scheduleEnabled = buffer.readBoolean();
        return new TrafficLightPacket(pos, enabledColors, type, model, icon, controlType, colorSlots, phaseId, scheduleEnabled);
    }

    public void handle(TrafficLightPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            ServerLevel level;
            ServerPlayer player = (ServerPlayer)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            if (player != null && (level = player.m_9236_()).m_46749_(packet.pos)) {
                BlockEntity patt0$temp = level.m_7702_(packet.pos);
                if (patt0$temp instanceof TrafficLightBlockEntity) {
                    TrafficLightBlockEntity blockEntity = (TrafficLightBlockEntity)patt0$temp;
                    blockEntity.setRunning(packet.scheduleEnabled);
                    blockEntity.setPhaseId(packet.phaseId);
                    blockEntity.setControlType(packet.controlType);
                    blockEntity.setIcon(packet.icon);
                    blockEntity.setColorSlots(packet.colors);
                    blockEntity.enableOnlyColors(packet.enabledColors);
                    blockEntity.setType(packet.type);
                }
                BlockState state = level.m_8055_(packet.pos);
                level.m_46597_(packet.pos, (BlockState)state.m_61124_(TrafficLightBlock.MODEL, (Comparable)((Object)packet.model)));
            }
        });
    }
}

