/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.network.packets.cts;

import de.mrjulsen.mcdragonlib.block.WritableSignBlockEntity;
import de.mrjulsen.mcdragonlib.net.IPacketBase;
import dev.architectury.networking.NetworkManager;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WritableSignPacket
implements IPacketBase<WritableSignPacket> {
    private String[] messages;
    private BlockPos pos;

    public WritableSignPacket() {
    }

    public WritableSignPacket(BlockPos pos, String[] messages) {
        this.pos = pos;
        this.messages = messages;
    }

    public void encode(WritableSignPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos);
        buffer.writeInt(packet.messages.length);
        for (int i = 0; i < packet.messages.length; ++i) {
            String message = packet.messages[i];
            int messageLength = packet.messages[i].getBytes(StandardCharsets.UTF_8).length;
            buffer.writeInt(messageLength);
            buffer.m_130072_(message, messageLength);
        }
    }

    public WritableSignPacket decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        int messagesCount = buffer.readInt();
        String[] messages = new String[messagesCount];
        for (int i = 0; i < messagesCount; ++i) {
            int messageLength = buffer.readInt();
            messages[i] = buffer.m_130136_(messageLength);
        }
        WritableSignPacket instance = new WritableSignPacket(pos, messages);
        return instance;
    }

    public void handle(WritableSignPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            ServerPlayer sender = (ServerPlayer)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            BlockEntity patt0$temp = sender.m_9236_().m_7702_(packet.pos);
            if (patt0$temp instanceof WritableSignBlockEntity) {
                WritableSignBlockEntity blockEntity = (WritableSignBlockEntity)patt0$temp;
                blockEntity.setTexts(packet.messages);
            }
        });
    }
}

