/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.io.Serializable;
import javax.annotation.Nonnull;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsbuilder.modules.builder.BuilderModule;
import mcjty.rftoolsbuilder.modules.builder.blocks.AnchorMode;
import mcjty.rftoolsbuilder.modules.builder.blocks.BuilderTileEntity;
import mcjty.rftoolsbuilder.modules.builder.client.GuiShapeCard;
import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardItem;
import mcjty.rftoolsbuilder.modules.builder.network.PacketCloseContainerAndOpenCardGui;
import mcjty.rftoolsbuilder.setup.RFToolsBuilderMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class GuiBuilder
extends GenericGuiContainer<BuilderTileEntity, GenericContainer> {
    private EnergyBar energyBar;
    private Button currentLevel;
    private final ImageChoiceLabel[] anchor = new ImageChoiceLabel[4];

    public GuiBuilder(BuilderTileEntity builderTileEntity, GenericContainer container, Inventory inventory) {
        super((GenericTileEntity)builderTileEntity, (AbstractContainerMenu)container, inventory, ((BaseBlock)BuilderModule.BUILDER.get()).getManualEntry());
    }

    public static void register() {
        GuiBuilder.register((MenuType)((MenuType)BuilderModule.CONTAINER_BUILDER.get()), GuiBuilder::new);
    }

    public void m_7856_() {
        this.window = new Window((Screen)this, this.tileEntity, RFToolsBuilderMessages.INSTANCE, new ResourceLocation("rftoolsbuilder", "gui/builder.gui"));
        super.m_7856_();
        this.initializeFields();
        this.setupEvents();
    }

    private void setupEvents() {
        this.window.event("cardgui", (source, params) -> this.openCardGui());
        this.window.event("anchor", (source, params) -> this.selectAnchor(source.getName()));
    }

    private void initializeFields() {
        this.energyBar = (EnergyBar)this.window.findChild("energybar");
        this.currentLevel = (Button)this.window.findChild("level");
        this.anchor[0] = (ImageChoiceLabel)this.window.findChild("anchor0");
        this.anchor[1] = (ImageChoiceLabel)this.window.findChild("anchor1");
        this.anchor[2] = (ImageChoiceLabel)this.window.findChild("anchor2");
        this.anchor[3] = (ImageChoiceLabel)this.window.findChild("anchor3");
        this.updateFields();
    }

    private void updateFields() {
        if (this.window == null) {
            return;
        }
        int cury = BuilderTileEntity.getCurrentLevelClientSide();
        this.currentLevel.text("Y: " + (Serializable)(cury == -1 ? "stop" : Integer.valueOf(cury)));
        ItemStack card = ((BuilderTileEntity)this.tileEntity).getCapability(ForgeCapabilities.ITEM_HANDLER).map(h -> h.getStackInSlot(0)).orElse(ItemStack.f_41583_);
        if (card.m_41619_()) {
            this.window.setFlag("!validcard");
        } else if (card.m_41720_() instanceof ShapeCardItem) {
            this.window.setFlag("!validcard");
        } else {
            this.window.setFlag("validcard");
        }
        this.updateAnchorSettings(((BuilderTileEntity)this.tileEntity).getAnchor());
        this.updateEnergyBar(this.energyBar);
    }

    private void openCardGui() {
        ItemStack cardStack = ((GenericContainer)this.f_97732_).m_38853_(0).m_7993_();
        if (!cardStack.m_41619_()) {
            GuiShapeCard.fromTEPos = ((BuilderTileEntity)this.tileEntity).m_58899_();
            GuiShapeCard.fromTEStackSlot = 0;
            RFToolsBuilderMessages.INSTANCE.sendToServer((Object)new PacketCloseContainerAndOpenCardGui(((BuilderTileEntity)this.tileEntity).m_58899_()));
        }
    }

    private void selectAnchor(String name) {
        int index = name.charAt(name.length() - 1) - 48;
        this.updateAnchorSettings(AnchorMode.values()[index]);
        this.sendServerCommandTyped(RFToolsBuilderMessages.INSTANCE, Minecraft.m_91087_().f_91073_.m_46472_(), GenericTileEntity.COMMAND_SYNC_BINDING.name(), TypedMap.builder().put(BuilderTileEntity.VALUE_ANCHOR.key(), (Object)AnchorMode.values()[index].getName()).build());
    }

    private void updateAnchorSettings(AnchorMode index) {
        for (int i = 0; i < this.anchor.length; ++i) {
            if (this.isShapeCard()) {
                this.anchor[i].setCurrentChoice(0);
                continue;
            }
            this.anchor[i].setCurrentChoice(i == index.ordinal() ? 1 : 0);
        }
    }

    private boolean isShapeCard() {
        ItemStack card = ((BuilderTileEntity)this.tileEntity).getCapability(ForgeCapabilities.ITEM_HANDLER).map(h -> h.getStackInSlot(0)).orElse(ItemStack.f_41583_);
        return !card.m_41619_() && card.m_41720_() instanceof ShapeCardItem;
    }

    protected void m_7286_(@Nonnull PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.updateFields();
        this.drawWindow(matrixStack);
    }
}

