/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import com.mojang.util.UUIDTypeAdapter;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.events.QuestProgressEventData;
import dev.ftb.mods.ftbquests.net.ClaimRewardResponseMessage;
import dev.ftb.mods.ftbquests.net.ObjectCompletedMessage;
import dev.ftb.mods.ftbquests.net.ObjectCompletedResetMessage;
import dev.ftb.mods.ftbquests.net.ObjectStartedMessage;
import dev.ftb.mods.ftbquests.net.ObjectStartedResetMessage;
import dev.ftb.mods.ftbquests.net.ResetRewardMessage;
import dev.ftb.mods.ftbquests.net.SyncEditingModeMessage;
import dev.ftb.mods.ftbquests.net.SyncLockMessage;
import dev.ftb.mods.ftbquests.net.SyncRewardBlockingMessage;
import dev.ftb.mods.ftbquests.net.TogglePinnedResponseMessage;
import dev.ftb.mods.ftbquests.net.UpdateTaskProgressMessage;
import dev.ftb.mods.ftbquests.quest.ProgressionMode;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim;
import dev.ftb.mods.ftbquests.quest.reward.RewardClaimType;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.util.FTBQuestsInventoryListener;
import dev.ftb.mods.ftbquests.util.QuestKey;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.Team;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ByteOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class TeamData {
    public static final int VERSION = 1;
    public static final int AUTO_PIN_ID = 1;
    private static final byte BOOL_NONE = -1;
    private static final byte BOOL_FALSE = 0;
    private static final byte BOOL_TRUE = 1;
    private static final Comparator<Long2LongMap.Entry> LONG2LONG_COMPARATOR = (e1, e2) -> Long.compareUnsigned(e1.getLongValue(), e2.getLongValue());
    private static final Comparator<Object2LongMap.Entry<QuestKey>> OBJECT2LONG_COMPARATOR = (e1, e2) -> Long.compareUnsigned(e1.getLongValue(), e2.getLongValue());
    public final UUID uuid;
    public QuestFile file;
    public String name;
    private boolean shouldSave;
    private boolean locked;
    private boolean rewardsBlocked;
    private final Long2LongOpenHashMap taskProgress;
    private final Object2LongOpenHashMap<QuestKey> claimedRewards;
    private final Long2LongOpenHashMap started;
    private final Long2LongOpenHashMap completed;
    private final Object2ObjectOpenHashMap<UUID, PerPlayerData> perPlayerData;
    private Long2ByteOpenHashMap areDependenciesCompleteCache;
    private Object2ByteOpenHashMap<QuestKey> unclaimedRewardsCache;

    public TeamData(UUID id) {
        this.uuid = id;
        this.name = "";
        this.shouldSave = false;
        this.taskProgress = new Long2LongOpenHashMap();
        this.taskProgress.defaultReturnValue(0L);
        this.claimedRewards = new Object2LongOpenHashMap();
        this.claimedRewards.defaultReturnValue(0L);
        this.started = new Long2LongOpenHashMap();
        this.started.defaultReturnValue(0L);
        this.completed = new Long2LongOpenHashMap();
        this.completed.defaultReturnValue(0L);
        this.perPlayerData = new Object2ObjectOpenHashMap();
    }

    public static TeamData get(Player player) {
        return FTBQuests.PROXY.getQuestFile(player.m_20193_().m_5776_()).getData((Entity)player);
    }

    public void markDirty() {
        this.shouldSave = true;
    }

    public void saveIfChanged() {
        QuestFile questFile;
        if (this.shouldSave && (questFile = this.file) instanceof ServerQuestFile) {
            ServerQuestFile sqf = (ServerQuestFile)questFile;
            Path path = sqf.server.m_129843_(ServerQuestFile.FTBQUESTS_DATA);
            SNBT.write((Path)path.resolve(this.uuid + ".snbt"), (CompoundTag)this.serializeNBT());
            this.shouldSave = false;
        }
    }

    public String toString() {
        return this.name.isEmpty() ? this.uuid.toString() : this.name;
    }

    public long getProgress(long taskId) {
        return this.taskProgress.get(taskId);
    }

    public long getProgress(Task task) {
        return this.getProgress(task.id);
    }

    public Optional<Date> getStartedTime(long questId) {
        long when = this.started.get(questId);
        return when == 0L ? Optional.empty() : Optional.of(new Date(when));
    }

    public boolean setStarted(long questId, @Nullable Date time) {
        if (!this.locked) {
            if (time == null) {
                if (this.started.remove(questId) >= 0L) {
                    this.clearCachedProgress();
                    this.markDirty();
                    if (this.file.isServerSide()) {
                        new ObjectStartedResetMessage(this.uuid, questId).sendTo(this.getOnlineMembers());
                    }
                    return true;
                }
            } else if (this.started.put(questId, time.getTime()) == 0L) {
                this.clearCachedProgress();
                this.markDirty();
                if (this.file.isServerSide()) {
                    new ObjectStartedMessage(this.uuid, questId).sendTo(this.getOnlineMembers());
                }
                return true;
            }
        }
        return false;
    }

    public Optional<Date> getCompletedTime(long questId) {
        long when = this.completed.get(questId);
        return when == 0L ? Optional.empty() : Optional.of(new Date(when));
    }

    public boolean setCompleted(long id, @Nullable Date time) {
        if (this.locked) {
            return false;
        }
        if (time == null) {
            if (this.completed.remove(id) >= 0L) {
                this.clearCachedProgress();
                this.markDirty();
                if (this.file.isServerSide()) {
                    new ObjectCompletedResetMessage(this.uuid, id).sendTo(this.getOnlineMembers());
                }
                return true;
            }
        } else if (this.completed.put(id, time.getTime()) == 0L) {
            this.clearCachedProgress();
            this.markDirty();
            if (this.file.isServerSide()) {
                new ObjectCompletedMessage(this.uuid, id).sendTo(this.getOnlineMembers());
            }
            return true;
        }
        return false;
    }

    public Optional<Date> getRewardClaimTime(UUID player, Reward reward) {
        QuestKey key = QuestKey.of(reward.isTeamReward() ? Util.f_137441_ : player, reward.id);
        long t = this.claimedRewards.getLong((Object)key);
        return t == 0L ? Optional.empty() : Optional.of(new Date(t));
    }

    public boolean areRewardsBlocked() {
        return this.rewardsBlocked;
    }

    public boolean isRewardBlocked(Reward reward) {
        return this.areRewardsBlocked() && !reward.ignoreRewardBlocking() && !reward.quest.ignoreRewardBlocking();
    }

    public boolean setRewardsBlocked(boolean rewardsBlocked) {
        if (rewardsBlocked != this.rewardsBlocked) {
            this.rewardsBlocked = rewardsBlocked;
            this.clearCachedProgress();
            this.markDirty();
            if (this.file.isServerSide()) {
                new SyncRewardBlockingMessage(this.uuid, rewardsBlocked).sendTo(this.getOnlineMembers());
            }
            return true;
        }
        return false;
    }

    public boolean isRewardClaimed(UUID player, Reward reward) {
        return this.getRewardClaimTime(player, reward).isPresent();
    }

    public boolean hasUnclaimedRewards(UUID player, QuestObject object) {
        QuestKey key;
        byte b;
        if (this.unclaimedRewardsCache == null) {
            this.unclaimedRewardsCache = new Object2ByteOpenHashMap();
            this.unclaimedRewardsCache.defaultReturnValue((byte)-1);
        }
        if ((b = this.unclaimedRewardsCache.getByte((Object)(key = QuestKey.of(player, object.id)))) == -1) {
            b = object.hasUnclaimedRewardsRaw(this, player) ? (byte)1 : 0;
            this.unclaimedRewardsCache.put((Object)key, b);
        }
        return b == 1;
    }

    public boolean claimReward(UUID player, Reward reward, long date) {
        if (this.locked || this.isRewardBlocked(reward)) {
            return false;
        }
        QuestKey key = QuestKey.of(reward.isTeamReward() ? Util.f_137441_ : player, reward.id);
        if (!this.claimedRewards.containsKey((Object)key)) {
            this.claimedRewards.put((Object)key, date);
            this.clearCachedProgress();
            this.markDirty();
            if (this.file.isServerSide()) {
                new ClaimRewardResponseMessage(this.uuid, player, reward.id).sendTo(this.getOnlineMembers());
            }
            reward.quest.checkRepeatable(this, player);
            return true;
        }
        return false;
    }

    public void deleteReward(Reward reward) {
        if (!this.locked && this.claimedRewards.object2LongEntrySet().removeIf(e -> ((QuestKey)e.getKey()).id == reward.id)) {
            this.clearCachedProgress();
            this.markDirty();
        }
    }

    public boolean resetReward(UUID player, Reward reward) {
        if (!this.locked && this.claimedRewards.removeLong((Object)QuestKey.of(reward.isTeamReward() ? Util.f_137441_ : player, reward.id)) != 0L) {
            this.clearCachedProgress();
            this.markDirty();
            if (this.file.isServerSide()) {
                new ResetRewardMessage(this.uuid, player, reward.id).sendTo(this.getOnlineMembers());
            }
            return true;
        }
        return false;
    }

    public void clearCachedProgress() {
        this.areDependenciesCompleteCache = null;
        this.unclaimedRewardsCache = null;
    }

    public SNBTCompoundTag serializeNBT() {
        SNBTCompoundTag nbt = new SNBTCompoundTag();
        nbt.m_128405_("version", 1);
        nbt.m_128359_("uuid", UUIDTypeAdapter.fromUUID((UUID)this.uuid));
        nbt.m_128359_("name", this.name);
        nbt.m_128379_("lock", this.locked);
        nbt.m_128379_("rewards_blocked", this.rewardsBlocked);
        SNBTCompoundTag taskProgressNBT = new SNBTCompoundTag();
        for (Object entry : this.taskProgress.long2LongEntrySet()) {
            if (entry.getLongValue() <= Integer.MAX_VALUE) {
                taskProgressNBT.m_128405_(QuestObjectBase.getCodeString(entry.getLongKey()), (int)entry.getLongValue());
                continue;
            }
            taskProgressNBT.m_128356_(QuestObjectBase.getCodeString(entry.getLongKey()), entry.getLongValue());
        }
        nbt.m_128365_("task_progress", (Tag)taskProgressNBT);
        SNBTCompoundTag startedNBT = new SNBTCompoundTag();
        for (Long2LongMap.Entry entry : this.started.long2LongEntrySet().stream().sorted(LONG2LONG_COMPARATOR).toList()) {
            startedNBT.m_128356_(QuestObjectBase.getCodeString(entry.getLongKey()), entry.getLongValue());
        }
        nbt.m_128365_("started", (Tag)startedNBT);
        SNBTCompoundTag completedNBT = new SNBTCompoundTag();
        for (Long2LongMap.Entry entry : this.completed.long2LongEntrySet().stream().sorted(LONG2LONG_COMPARATOR).toList()) {
            completedNBT.m_128356_(QuestObjectBase.getCodeString(entry.getLongKey()), entry.getLongValue());
        }
        nbt.m_128365_("completed", (Tag)completedNBT);
        SNBTCompoundTag sNBTCompoundTag = new SNBTCompoundTag();
        for (Object2LongMap.Entry<QuestKey> entry : this.claimedRewards.object2LongEntrySet().stream().sorted(OBJECT2LONG_COMPARATOR).toList()) {
            sNBTCompoundTag.m_128356_(((QuestKey)entry.getKey()).toString(), entry.getLongValue());
        }
        nbt.m_128365_("claimed_rewards", (Tag)sNBTCompoundTag);
        CompoundTag compoundTag = new CompoundTag();
        this.perPlayerData.forEach((id, ppd) -> {
            if (!ppd.hasDefaultValues()) {
                ppdTag.m_128365_(UUIDTypeAdapter.fromUUID((UUID)id), (Tag)ppd.writeNBT());
            }
        });
        nbt.m_128365_("player_data", (Tag)compoundTag);
        return nbt;
    }

    public void deserializeNBT(SNBTCompoundTag nbt) {
        int fileVersion = nbt.m_128451_("version");
        if (fileVersion != 1) {
            this.markDirty();
        }
        this.name = nbt.m_128461_("name");
        this.locked = nbt.m_128471_("lock");
        this.rewardsBlocked = nbt.m_128471_("rewards_blocked");
        this.taskProgress.clear();
        this.claimedRewards.clear();
        this.perPlayerData.clear();
        SNBTCompoundTag claimedRewardsNBT = nbt.getCompound("claimed_rewards");
        for (Object s : claimedRewardsNBT.m_128431_()) {
            this.claimedRewards.put((Object)QuestKey.of((String)s), claimedRewardsNBT.m_128454_((String)s));
        }
        SNBTCompoundTag taskProgressNBT = nbt.getCompound("task_progress");
        for (Object s : taskProgressNBT.m_128431_()) {
            this.taskProgress.put(this.file.getID(s), taskProgressNBT.m_128454_((String)s));
        }
        SNBTCompoundTag startedNBT = nbt.getCompound("started");
        for (Object s : startedNBT.m_128431_()) {
            this.started.put(this.file.getID(s), startedNBT.m_128454_((String)s));
        }
        SNBTCompoundTag completedNBT = nbt.getCompound("completed");
        for (String s : completedNBT.m_128431_()) {
            this.completed.put(this.file.getID(s), completedNBT.m_128454_(s));
        }
        if (!nbt.m_128441_("player_data")) {
            this.loadLegacyData(nbt);
        } else {
            SNBTCompoundTag ppdTag = nbt.getCompound("player_data");
            for (String key : ppdTag.m_128431_()) {
                try {
                    UUID id = UUIDTypeAdapter.fromString((String)key);
                    this.perPlayerData.put((Object)id, (Object)PerPlayerData.fromNBT(ppdTag.m_128469_(key), this.file));
                }
                catch (IllegalArgumentException e) {
                    FTBQuests.LOGGER.error("ignoring invalid player ID {} while loading per-player data for team {}", (Object)key, (Object)this.uuid);
                }
            }
        }
    }

    private void loadLegacyData(SNBTCompoundTag nbt) {
        Team team;
        FTBQuests.LOGGER.info("Converting per-team data to per-player data for {} ({}}", (Object)this.uuid, (Object)this.name);
        boolean canEdit = nbt.m_128471_("can_edit");
        boolean autoPin = nbt.m_128471_("auto_pin");
        boolean chapterPinned = nbt.m_128471_("chapter_pinned");
        ListTag pinnedQuestsNBT = nbt.m_128437_("pinned_quests", 8);
        LongOpenHashSet pinnedQuests = new LongOpenHashSet();
        pinnedQuestsNBT.forEach(arg_0 -> this.lambda$loadLegacyData$4((LongSet)pinnedQuests, arg_0));
        if ((canEdit || autoPin || chapterPinned || !pinnedQuests.isEmpty()) && (team = FTBTeamsAPI.getPlayerTeam((UUID)this.uuid)) != null) {
            team.getMembers().forEach(arg_0 -> this.lambda$loadLegacyData$5(canEdit, autoPin, chapterPinned, (LongSet)pinnedQuests, arg_0));
        }
    }

    public void write(FriendlyByteBuf buffer, boolean self) {
        buffer.m_130072_(this.name, Short.MAX_VALUE);
        buffer.m_130130_(this.taskProgress.size());
        for (Long2LongMap.Entry entry : this.taskProgress.long2LongEntrySet()) {
            buffer.writeLong(entry.getLongKey());
            buffer.m_130103_(entry.getLongValue());
        }
        long now = System.currentTimeMillis();
        buffer.m_130130_(this.started.size());
        for (Long2LongMap.Entry entry : this.started.long2LongEntrySet()) {
            buffer.writeLong(entry.getLongKey());
            buffer.m_130103_(now - entry.getLongValue());
        }
        buffer.m_130130_(this.completed.size());
        for (Long2LongMap.Entry entry : this.completed.long2LongEntrySet()) {
            buffer.writeLong(entry.getLongKey());
            buffer.m_130103_(now - entry.getLongValue());
        }
        buffer.writeBoolean(this.locked);
        buffer.writeBoolean(this.rewardsBlocked);
        if (self) {
            buffer.m_130130_(this.claimedRewards.size());
            for (Long2LongMap.Entry entry : this.claimedRewards.object2LongEntrySet()) {
                ((QuestKey)entry.getKey()).write(buffer);
                buffer.m_130103_(now - entry.getLongValue());
            }
            buffer.m_130130_(this.perPlayerData.size());
            this.perPlayerData.forEach((id, ppd) -> {
                buffer.m_130077_(id);
                ppd.writeNet(buffer);
            });
        }
    }

    public void read(FriendlyByteBuf buffer, boolean self) {
        this.name = buffer.m_130136_(Short.MAX_VALUE);
        this.taskProgress.clear();
        int ts = buffer.m_130242_();
        for (int i = 0; i < ts; ++i) {
            this.taskProgress.put(buffer.readLong(), buffer.m_130258_());
        }
        long now = System.currentTimeMillis();
        this.started.clear();
        int ss = buffer.m_130242_();
        for (int i = 0; i < ss; ++i) {
            this.started.put(buffer.readLong(), now - buffer.m_130258_());
        }
        this.completed.clear();
        int cs = buffer.m_130242_();
        for (int i = 0; i < cs; ++i) {
            this.completed.put(buffer.readLong(), now - buffer.m_130258_());
        }
        this.locked = buffer.readBoolean();
        this.rewardsBlocked = buffer.readBoolean();
        this.claimedRewards.clear();
        this.perPlayerData.clear();
        if (self) {
            int crs = buffer.m_130242_();
            for (int i = 0; i < crs; ++i) {
                QuestKey key = QuestKey.of(buffer);
                this.claimedRewards.put((Object)key, now - buffer.m_130258_());
            }
            int ppdCount = buffer.m_130242_();
            for (int i = 0; i < ppdCount; ++i) {
                UUID id = buffer.m_130259_();
                this.perPlayerData.put((Object)id, (Object)PerPlayerData.fromNet(buffer));
            }
        }
    }

    public int getRelativeProgress(QuestObject object) {
        if (this.isCompleted(object)) {
            return 100;
        }
        if (!this.isStarted(object)) {
            return 0;
        }
        return object.getRelativeProgressFromChildren(this);
    }

    public boolean isStarted(QuestObject object) {
        return this.started.containsKey(object.id);
    }

    public boolean isCompleted(QuestObject object) {
        return this.completed.containsKey(object.id);
    }

    public boolean areDependenciesComplete(Quest quest) {
        byte b;
        if (!quest.hasDependencies()) {
            return true;
        }
        if (this.areDependenciesCompleteCache == null) {
            this.areDependenciesCompleteCache = new Long2ByteOpenHashMap();
            this.areDependenciesCompleteCache.defaultReturnValue((byte)-1);
        }
        if ((b = this.areDependenciesCompleteCache.get(quest.id)) == -1) {
            b = this.areDependenciesComplete0(quest) ? (byte)1 : 0;
            this.areDependenciesCompleteCache.put(quest.id, b);
        }
        return b == 1;
    }

    private boolean areDependenciesComplete0(Quest quest) {
        if (quest.minRequiredDependencies > 0) {
            return quest.getDependencies().filter(dep -> this.isCompleted((QuestObject)dep) && !dep.invalid).limit(quest.minRequiredDependencies).count() == (long)quest.minRequiredDependencies;
        }
        if (quest.dependencyRequirement.one) {
            return quest.getDependencies().anyMatch(dep -> !dep.invalid && (quest.dependencyRequirement.completed ? this.isCompleted((QuestObject)dep) : this.isStarted((QuestObject)dep)));
        }
        return quest.getDependencies().allMatch(dep -> !dep.invalid && (quest.dependencyRequirement.completed ? this.isCompleted((QuestObject)dep) : this.isStarted((QuestObject)dep)));
    }

    public boolean canStartTasks(Quest quest) {
        return quest.getProgressionMode() == ProgressionMode.FLEXIBLE || this.areDependenciesComplete(quest);
    }

    public void claimReward(ServerPlayer player, Reward reward, boolean notify) {
        if (this.claimReward(player.m_20148_(), reward, System.currentTimeMillis())) {
            reward.claim(player, notify);
        }
    }

    public List<ServerPlayer> getOnlineMembers() {
        Team team = FTBTeamsAPI.getManager().getTeamByID(this.uuid);
        return team == null ? Collections.emptyList() : team.getOnlineMembers();
    }

    public void checkAutoCompletion(Quest quest) {
        if (quest.rewards.isEmpty() || !this.isCompleted(quest)) {
            return;
        }
        List<ServerPlayer> online = null;
        for (Reward reward : quest.rewards) {
            RewardAutoClaim auto = reward.getAutoClaimType();
            if (auto == RewardAutoClaim.DISABLED) continue;
            if (online == null && (online = this.getOnlineMembers()).isEmpty()) {
                return;
            }
            for (ServerPlayer player : online) {
                this.claimReward(player, reward, auto == RewardAutoClaim.ENABLED);
            }
        }
    }

    public RewardClaimType getClaimType(UUID player, Reward reward) {
        boolean r = this.isRewardClaimed(player, reward);
        if (r) {
            return RewardClaimType.CLAIMED;
        }
        if (this.isCompleted(reward.quest)) {
            return RewardClaimType.CAN_CLAIM;
        }
        return RewardClaimType.CANT_CLAIM;
    }

    public void resetProgress(Task task) {
        if (this.taskProgress.remove(task.id) > 0L) {
            this.markDirty();
        }
    }

    public final void setProgress(Task task, long progress) {
        if (this.locked) {
            return;
        }
        long maxProgress = task.getMaxProgress();
        progress = Math.max(0L, Math.min(progress, maxProgress));
        long prevProgress = this.getProgress(task);
        if (prevProgress != progress || progress == 0L && this.isStarted(task)) {
            if (progress == 0L) {
                this.taskProgress.remove(task.id);
                this.started.remove(task.id);
                this.completed.remove(task.id);
            } else {
                this.taskProgress.put(task.id, progress);
            }
            this.clearCachedProgress();
            if (this.file.isServerSide()) {
                Date now = new Date();
                List<ServerPlayer> onlineMembers = this.getOnlineMembers();
                new UpdateTaskProgressMessage(this, task.id, progress).sendTo(onlineMembers);
                if (prevProgress == 0L) {
                    task.onStarted(new QuestProgressEventData<Task>(now, this, task, onlineMembers, Collections.emptyList()));
                }
                if (progress >= maxProgress && this.areDependenciesComplete(task.quest)) {
                    this.markTaskCompleted(task);
                }
            }
            this.markDirty();
        }
    }

    public void markTaskCompleted(Task task) {
        if (this.isCompleted(task)) {
            return;
        }
        List<ServerPlayer> onlineMembers = this.getOnlineMembers();
        List<Object> notifiedPlayers = !task.quest.chapter.alwaysInvisible && QuestObjectBase.sendNotifications.get(true) ? onlineMembers : Collections.emptyList();
        task.onCompleted(new QuestProgressEventData<Task>(new Date(), this, task, onlineMembers, notifiedPlayers));
        for (ServerPlayer player : onlineMembers) {
            FTBQuestsInventoryListener.detect(player, ItemStack.f_41583_, task.id);
        }
        if (this.isCompleted(task.quest)) {
            this.perPlayerData.values().forEach(data -> data.pinnedQuests.remove(task.quest.id));
            this.markDirty();
            new TogglePinnedResponseMessage(task.quest.id, false).sendTo(onlineMembers);
        }
    }

    public final void addProgress(Task task, long p) {
        this.setProgress(task, this.getProgress(task) + p);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean setLocked(boolean b) {
        if (this.locked != b) {
            this.locked = b;
            this.clearCachedProgress();
            this.markDirty();
            if (this.file.isServerSide()) {
                new SyncLockMessage(this.uuid, this.locked).sendTo(this.getOnlineMembers());
            }
            return true;
        }
        return false;
    }

    public void mergeData(TeamData from) {
        from.taskProgress.forEach((id, data) -> this.taskProgress.mergeLong(id.longValue(), data.longValue(), Long::max));
        from.started.forEach((id, data) -> this.started.mergeLong(id.longValue(), data.longValue(), (oldVal, newVal) -> oldVal));
        from.completed.forEach((id, data) -> this.completed.mergeLong(id.longValue(), data.longValue(), (oldVal, newVal) -> oldVal));
        from.claimedRewards.forEach((id, data) -> this.claimedRewards.mergeLong(id, data.longValue(), (oldVal, newVal) -> oldVal));
        from.perPlayerData.forEach((id, data) -> this.perPlayerData.merge(id, data, (oldVal, newVal) -> oldVal));
    }

    public void copyData(TeamData from) {
        this.locked = from.locked;
        this.taskProgress.putAll((Map)from.taskProgress);
        this.claimedRewards.putAll(from.claimedRewards);
        this.started.putAll((Map)from.started);
        this.completed.putAll((Map)from.completed);
        this.perPlayerData.putAll(from.perPlayerData);
        this.rewardsBlocked = from.rewardsBlocked;
    }

    private Optional<PerPlayerData> getOrCreatePlayerData(Player player) {
        if (!this.perPlayerData.containsKey((Object)player.m_20148_()) && this.file.isPlayerOnTeam(player, this)) {
            this.perPlayerData.put((Object)player.m_20148_(), (Object)new PerPlayerData());
        }
        return Optional.ofNullable((PerPlayerData)this.perPlayerData.get((Object)player.m_20148_()));
    }

    public boolean getCanEdit(Player player) {
        return this.getOrCreatePlayerData(player).map(d -> d.canEdit).orElse(false);
    }

    public boolean setCanEdit(Player player, boolean newCanEdit) {
        return this.getOrCreatePlayerData(player).map(playerData -> {
            if (playerData.canEdit != newCanEdit) {
                playerData.canEdit = newCanEdit;
                this.clearCachedProgress();
                this.markDirty();
                if (this.file.isServerSide() && player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    new SyncEditingModeMessage(this.uuid, newCanEdit).sendTo(sp);
                }
                return true;
            }
            return false;
        }).orElse(false);
    }

    public boolean isQuestPinned(Player player, long id) {
        return this.getOrCreatePlayerData(player).map(playerData -> playerData.pinnedQuests.contains(id)).orElse(false);
    }

    public void setQuestPinned(Player player, long id, boolean pinned) {
        this.getOrCreatePlayerData(player).ifPresent(playerData -> {
            if (pinned ? playerData.pinnedQuests.add(id) : playerData.pinnedQuests.remove(id)) {
                this.markDirty();
            }
        });
    }

    public void setChapterPinned(Player player, boolean pinned) {
        this.getOrCreatePlayerData(player).ifPresent(playerData -> {
            if (playerData.chapterPinned != pinned) {
                playerData.chapterPinned = pinned;
                this.markDirty();
            }
        });
    }

    public boolean isChapterPinned(Player player) {
        return this.getOrCreatePlayerData(player).map(playerData -> playerData.chapterPinned).orElse(false);
    }

    public LongSet getPinnedQuestIds(Player player) {
        return this.getOrCreatePlayerData(player).map(playerData -> playerData.pinnedQuests).orElse(LongSet.of());
    }

    private /* synthetic */ void lambda$loadLegacyData$5(boolean canEdit, boolean autoPin, boolean chapterPinned, LongSet pinnedQuests, UUID memberId) {
        this.perPlayerData.put((Object)memberId, (Object)new PerPlayerData(canEdit, autoPin, chapterPinned, pinnedQuests));
    }

    private /* synthetic */ void lambda$loadLegacyData$4(LongSet pinnedQuests, Tag tag) {
        pinnedQuests.add(this.file.getID(tag.m_7916_()));
    }

    private static class PerPlayerData {
        private boolean canEdit;
        private boolean autoPin;
        private boolean chapterPinned;
        private final LongSet pinnedQuests;

        PerPlayerData() {
            this.chapterPinned = false;
            this.autoPin = false;
            this.canEdit = false;
            this.pinnedQuests = new LongOpenHashSet();
        }

        PerPlayerData(boolean canEdit, boolean autoPin, boolean chapterPinned, LongSet pinnedQuests) {
            this.canEdit = canEdit;
            this.autoPin = autoPin;
            this.chapterPinned = chapterPinned;
            this.pinnedQuests = pinnedQuests;
        }

        public boolean hasDefaultValues() {
            return !this.canEdit && !this.autoPin && !this.chapterPinned && this.pinnedQuests.isEmpty();
        }

        public static PerPlayerData fromNBT(CompoundTag nbt, QuestFile file) {
            PerPlayerData ppd = new PerPlayerData();
            ppd.canEdit = nbt.m_128471_("can_edit");
            ppd.autoPin = nbt.m_128471_("auto_pin");
            ppd.chapterPinned = nbt.m_128471_("chapter_pinned");
            ListTag pinnedQuestsNBT = nbt.m_128437_("pinned_quests", 8);
            for (int i = 0; i < pinnedQuestsNBT.size(); ++i) {
                ppd.pinnedQuests.add(file.getID(pinnedQuestsNBT.m_128778_(i)));
            }
            return ppd;
        }

        public static PerPlayerData fromNet(FriendlyByteBuf buffer) {
            PerPlayerData ppd = new PerPlayerData();
            ppd.canEdit = buffer.readBoolean();
            ppd.autoPin = buffer.readBoolean();
            ppd.chapterPinned = buffer.readBoolean();
            int pinnedCount = buffer.m_130242_();
            for (int i = 0; i < pinnedCount; ++i) {
                ppd.pinnedQuests.add(buffer.readLong());
            }
            return ppd;
        }

        public CompoundTag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            if (this.canEdit) {
                nbt.m_128379_("can_edit", true);
            }
            if (this.autoPin) {
                nbt.m_128379_("auto_pin", true);
            }
            if (this.chapterPinned) {
                nbt.m_128379_("chapter_pinned", true);
            }
            if (!this.pinnedQuests.isEmpty()) {
                long[] pinnedQuestsArray = this.pinnedQuests.toLongArray();
                Arrays.sort(pinnedQuestsArray);
                ListTag pinnedQuestsNBT = new ListTag();
                for (long l : pinnedQuestsArray) {
                    pinnedQuestsNBT.add((Object)StringTag.m_129297_((String)QuestObjectBase.getCodeString(l)));
                }
                nbt.m_128365_("pinned_quests", (Tag)pinnedQuestsNBT);
            }
            return nbt;
        }

        public void writeNet(FriendlyByteBuf buffer) {
            buffer.writeBoolean(this.canEdit);
            buffer.writeBoolean(this.autoPin);
            buffer.writeBoolean(this.chapterPinned);
            buffer.m_130130_(this.pinnedQuests.size());
            LongIterator longIterator = this.pinnedQuests.iterator();
            while (longIterator.hasNext()) {
                long reward = (Long)longIterator.next();
                buffer.writeLong(reward);
            }
        }
    }
}

