/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import com.mojang.datafixers.util.Either;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.BooleanTask;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BiomeTask
extends BooleanTask {
    private static final ResourceKey<Biome> DEFAULT_BIOME = Biomes.f_48202_;
    private static final List<String> KNOWN_BIOMES = new ArrayList<String>();
    private Either<ResourceKey<Biome>, TagKey<Biome>> biome = Either.left(DEFAULT_BIOME);

    public BiomeTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.BIOME;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("biome", this.getBiome());
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.setBiome(nbt.m_128461_("biome"));
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130070_(this.getBiome());
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.setBiome(buffer.m_130136_(Short.MAX_VALUE));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addEnum("biome", (Object)this.getBiome(), this::setBiome, NameMap.of((Object)DEFAULT_BIOME.m_135782_().toString(), this.getKnownBiomes()).create());
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return Component.m_237115_((String)"ftbquests.task.ftbquests.biome").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)this.getBiome())).m_130940_(ChatFormatting.DARK_GREEN);
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return 20;
    }

    @Override
    public boolean checkOnLogin() {
        return false;
    }

    @Override
    public boolean canSubmit(TeamData teamData, ServerPlayer player) {
        if (player.m_5833_()) {
            return false;
        }
        Holder biomeHolder = player.f_19853_.m_204166_(player.m_20183_());
        return (Boolean)this.biome.map(key -> biomeHolder.m_203543_().map(k -> k == key).orElse(false), tagKey -> {
            Registry reg = (Registry)player.f_19853_.m_5962_().m_6632_(Registry.f_122885_).orElseThrow();
            return reg.m_203431_(tagKey).map(holderSet -> holderSet.m_203333_(biomeHolder)).orElse(false);
        });
    }

    private String getBiome() {
        return (String)this.biome.map(key -> key.m_135782_().toString(), tagKey -> "#" + tagKey.f_203868_());
    }

    private void setBiome(String str) {
        this.biome = str.startsWith("#") ? Either.right((Object)TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)this.safeResourceLocation(str.substring(1), DEFAULT_BIOME.m_135782_()))) : Either.left((Object)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)this.safeResourceLocation(str, DEFAULT_BIOME.m_135782_())));
    }

    private List<String> getKnownBiomes() {
        if (KNOWN_BIOMES.isEmpty()) {
            RegistryAccess registryAccess = FTBQuests.PROXY.getClientPlayer().f_19853_.m_5962_();
            KNOWN_BIOMES.addAll(registryAccess.m_175515_(Registry.f_122885_).m_214010_().stream().map(o -> o.m_135782_().toString()).sorted(String::compareTo).toList());
            KNOWN_BIOMES.addAll(registryAccess.m_175515_(Registry.f_122885_).m_203613_().map(o -> "#" + o.f_203868_()).sorted(String::compareTo).toList());
        }
        return KNOWN_BIOMES;
    }
}

