/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.eligibility;

import com.communi.suggestu.saecularia.caudices.core.block.IBlockWithWorldlyProperties;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityOptions;
import mod.chiselsandbits.api.config.IServerConfiguration;
import mod.chiselsandbits.api.util.SingleBlockBlockReader;
import mod.chiselsandbits.registrars.ModBlocks;
import mod.chiselsandbits.utils.ClassUtils;
import mod.chiselsandbits.utils.ReflectionHelperBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEligibilityAnalysisData {
    private final boolean isCompatible;
    private final float hardness;
    private final float explosionResistance;

    private BlockEligibilityAnalysisData(boolean isCompatible, float hardness, float explosionResistance) {
        this.isCompatible = isCompatible;
        this.hardness = hardness;
        this.explosionResistance = explosionResistance;
    }

    public boolean isCompatible() {
        return this.isCompatible;
    }

    public float getHardness() {
        return this.hardness;
    }

    public float getExplosionResistance() {
        return this.explosionResistance;
    }

    public static BlockEligibilityAnalysisData createFromState(IBlockInformation state) {
        try {
            boolean isFluid;
            ReflectionHelperBlock reflectBlock = (ReflectionHelperBlock)((Object)ModBlocks.REFLECTION_HELPER_BLOCK.get());
            Block blk = state.getBlockState().m_60734_();
            Class<?> blkClass = blk.getClass();
            reflectBlock.m_5880_(null, null, null, null);
            Class<?> b_Class = ClassUtils.getDeclaringClass(blkClass, reflectBlock.getLastInvokedThreadLocalMethodName(), BlockState.class, Player.class, BlockGetter.class, BlockPos.class);
            boolean test_b = b_Class == Block.class || b_Class == BlockBehaviour.class;
            reflectBlock.m_7325_();
            Class<?> exploResistanceClz = ClassUtils.getDeclaringClass(blkClass, reflectBlock.getLastInvokedThreadLocalMethodName(), new Class[0]);
            boolean test_c = exploResistanceClz == Block.class || exploResistanceClz == BlockBehaviour.class;
            reflectBlock.getExplosionResistance(null, null, null, null);
            exploResistanceClz = ClassUtils.getDeclaringClass(blkClass, reflectBlock.getLastInvokedThreadLocalMethodName(), BlockState.class, BlockGetter.class, BlockPos.class, Explosion.class);
            boolean test_d = exploResistanceClz == Block.class || exploResistanceClz == BlockBehaviour.class || exploResistanceClz == null || IEligibilityOptions.getInstance().isValidExplosionDefinitionClass(exploResistanceClz);
            boolean bl = isFluid = !state.getBlockState().m_60819_().m_76178_();
            if (test_b && test_c && test_d && !isFluid) {
                float blockHardness = state.getBlockState().m_60800_((BlockGetter)new SingleBlockBlockReader(state, state.getBlockState().m_60734_()), BlockPos.f_121853_);
                float resistance = blk.m_7325_();
                if (blk instanceof IBlockWithWorldlyProperties) {
                    IBlockWithWorldlyProperties blockWithWorldlyProperties = (IBlockWithWorldlyProperties)blk;
                    resistance = blockWithWorldlyProperties.getExplosionResistance(state.getBlockState(), (BlockGetter)new SingleBlockBlockReader(state, state.getBlockState().m_60734_()), BlockPos.f_121853_, new Explosion(null, null, null, null, 0.0, 1.0, 0.0, 10.0f, false, Explosion.BlockInteraction.NONE));
                }
                return new BlockEligibilityAnalysisData(true, blockHardness, resistance);
            }
            if (test_b && test_c && test_d && isFluid) {
                return new BlockEligibilityAnalysisData(true, 2.0f, 6.0f);
            }
            return new BlockEligibilityAnalysisData(IServerConfiguration.getInstance().getCompatabilityMode().get(), 2.0f, 6.0f);
        }
        catch (Exception err) {
            return new BlockEligibilityAnalysisData(false, -1.0f, -1.0f);
        }
    }
}

