/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item;

import java.util.ArrayList;
import java.util.List;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.block.bitbag.IBitBagAcceptingBlock;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.inventory.bit.IBitInventoryItem;
import mod.chiselsandbits.api.inventory.bit.IBitInventoryItemStack;
import mod.chiselsandbits.api.util.HelpTextUtils;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.inventory.bit.SlottedBitInventoryItemStack;
import mod.chiselsandbits.network.packets.OpenBagGuiPacket;
import mod.chiselsandbits.registrars.ModItems;
import mod.chiselsandbits.utils.SimpleInstanceCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitBagItem
extends Item
implements IBitInventoryItem {
    private static final int BAG_STORAGE_SLOTS = 63;
    SimpleInstanceCache<ItemStack, List<Component>> tooltipCache = new SimpleInstanceCache(null, new ArrayList());

    public BitBagItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        DyeColor color = BitBagItem.getDyedColor(stack);
        Component parent = super.m_7626_(stack);
        if (parent instanceof MutableComponent && color != null) {
            return ((MutableComponent)parent).m_130946_(" - ").m_7220_((Component)Component.m_237115_((String)("chiselsandbits.color." + color.m_41065_())));
        }
        return super.m_7626_(stack);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        List<Component> details;
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        HelpTextUtils.build(LocalStrings.HelpBitBag, tooltip, new Object[0]);
        if (this.tooltipCache.needsUpdate(stack)) {
            IBitInventoryItemStack inventoryItemStack = this.create(stack);
            this.tooltipCache.updateCachedValue(inventoryItemStack.listContents());
        }
        if ((details = this.tooltipCache.getCached()).size() <= 2 || Minecraft.m_91087_().m_91268_() != null && Screen.m_96638_()) {
            tooltip.addAll(details);
        } else {
            tooltip.add((Component)LocalStrings.ShiftDetails.getText());
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level worldIn, @NotNull Player playerIn, @NotNull InteractionHand hand) {
        BlockHitResult blockRayTraceResult;
        BlockState hitBlockState;
        ItemStack itemStackIn = playerIn.m_21120_(hand);
        HitResult rayTraceResult = RayTracingUtils.rayTracePlayer(playerIn);
        if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK && rayTraceResult instanceof BlockHitResult && (hitBlockState = worldIn.m_8055_((blockRayTraceResult = (BlockHitResult)rayTraceResult).m_82425_())).m_60734_() instanceof IBitBagAcceptingBlock) {
            ((IBitBagAcceptingBlock)hitBlockState.m_60734_()).onBitBagInteraction(itemStackIn, playerIn, blockRayTraceResult);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStackIn);
        }
        if (worldIn.f_46443_) {
            ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new OpenBagGuiPacket());
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStackIn);
    }

    @Override
    public IBitInventoryItemStack create(ItemStack stack) {
        if (stack.m_41720_() != this) {
            return new SlottedBitInventoryItemStack(0, nbt -> ItemStack.f_41583_);
        }
        SlottedBitInventoryItemStack inventoryItemStack = new SlottedBitInventoryItemStack(63, nbt -> {
            stack.m_41784_().m_128365_("Inventory", (Tag)nbt);
            return stack;
        });
        inventoryItemStack.deserializeNBT(stack.m_41698_("Inventory"));
        return inventoryItemStack;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof IBitInventoryItem)) {
            return false;
        }
        IBitInventoryItem item2 = (IBitInventoryItem)item;
        IBitInventoryItemStack inventoryItemStack = item2.create(stack);
        return !inventoryItemStack.m_7983_();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof IBitInventoryItem)) {
            return 0.0;
        }
        IBitInventoryItem item2 = (IBitInventoryItem)item;
        IBitInventoryItemStack inventoryItemStack = item2.create(stack);
        double filledRatio = inventoryItemStack.getFilledRatio();
        return Math.min(1.0, Math.max(0.0, IClientConfiguration.getInstance().getInvertBitBagFullness().get() != false ? filledRatio : 1.0 - filledRatio));
    }

    public void m_6787_(@NotNull CreativeModeTab group, @NotNull NonNullList<ItemStack> items) {
        if (this.m_220152_(group)) {
            if (this == ModItems.ITEM_BIT_BAG_DEFAULT.get()) {
                items.add((Object)new ItemStack((ItemLike)this));
            } else {
                for (DyeColor color : DyeColor.values()) {
                    items.add((Object)BitBagItem.dyeBag(new ItemStack((ItemLike)this), color));
                }
            }
        }
    }

    public static ItemStack dyeBag(ItemStack bag, DyeColor color) {
        ItemStack copy = bag.m_41777_();
        if (!copy.m_41782_()) {
            copy.m_41751_(new CompoundTag());
        }
        if (color == null && bag.m_41720_() == ModItems.ITEM_BIT_BAG_DYED.get()) {
            ItemStack unColoredStack = new ItemStack((ItemLike)ModItems.ITEM_BIT_BAG_DEFAULT.get());
            unColoredStack.m_41751_(copy.m_41783_());
            unColoredStack.m_41784_().m_128473_("color");
            return unColoredStack;
        }
        if (color != null) {
            ItemStack coloredStack = copy;
            if (coloredStack.m_41720_() == ModItems.ITEM_BIT_BAG_DEFAULT.get()) {
                coloredStack = new ItemStack((ItemLike)ModItems.ITEM_BIT_BAG_DYED.get());
                coloredStack.m_41751_(copy.m_41783_());
            }
            coloredStack.m_41784_().m_128359_("color", color.m_41065_());
            return coloredStack;
        }
        return copy;
    }

    public static DyeColor getDyedColor(ItemStack stack) {
        if (stack.m_41720_() != ModItems.ITEM_BIT_BAG_DYED.get()) {
            return null;
        }
        if (stack.m_41784_().m_128441_("color")) {
            String name = stack.m_41784_().m_128461_("color");
            for (DyeColor color : DyeColor.values()) {
                if (!name.equals(color.m_7912_())) continue;
                return color;
            }
        }
        return null;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }
}

