/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.common;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.jeed.Jeed;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public abstract class EffectRenderer {
    protected final Minecraft mc = Minecraft.m_91087_();
    protected final boolean offset;

    protected EffectRenderer(boolean offset) {
        this.offset = offset;
    }

    public void render(PoseStack matrixStack, MobEffectInstance effectInstance) {
        this.render(matrixStack, effectInstance, 0, 0, 16, 16);
    }

    public void render(PoseStack matrixStack, MobEffectInstance effectInstance, int x, int y, int width, int height) {
        MobEffect effect = effectInstance.m_19544_();
        MobEffectTextureManager textures = this.mc.m_91306_();
        TextureAtlasSprite sprite = textures.m_118732_(effect);
        this.render(matrixStack, sprite, x, y, width, height);
    }

    public void render(PoseStack matrixStack, TextureAtlasSprite sprite, int x, int y, int width, int height) {
        RenderSystem.m_69424_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)sprite.m_118414_().m_118330_());
        int o = this.offset ? -1 : 0;
        GuiComponent.m_93200_((PoseStack)matrixStack, (int)(x + o), (int)(y + o), (int)0, (int)(width + 2), (int)(height + 2), (TextureAtlasSprite)sprite);
        RenderSystem.m_157182_();
    }

    public static List<Component> getTooltipsWithDescription(MobEffectInstance effectInstance, TooltipFlag tooltipFlag, boolean reactsToShift, boolean showDuration) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (effectInstance != null) {
            MobEffect effect = effectInstance.m_19544_();
            Object name = I18n.m_118938_((String)effect.m_19481_(), (Object[])new Object[0]);
            int amp = effectInstance.m_19564_();
            if (amp >= 1 && amp <= 9) {
                name = (String)name + " " + I18n.m_118938_((String)("enchantment.level." + (amp + 1)), (Object[])new Object[0]);
            }
            tooltip.add((Component)Component.m_237113_((String)name));
            if (showDuration) {
                tooltip.add((Component)Component.m_237113_((String)MobEffectUtil.m_19581_((MobEffectInstance)effectInstance, (float)1.0f)));
            }
            if (Jeed.hasEffectColor()) {
                MutableComponent colorValue = Component.m_237113_((String)("#" + Integer.toHexString(effect.m_19484_())));
                colorValue.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)effect.m_19484_())));
                MutableComponent color = Component.m_237115_((String)"jeed.tooltip.color").m_130940_(ChatFormatting.GRAY);
                tooltip.add((Component)Component.m_237110_((String)"jeed.tooltip.color_complete", (Object[])new Object[]{color, colorValue}));
            }
            if (effect.m_19486_()) {
                tooltip.add((Component)Component.m_237115_((String)"jeed.tooltip.beneficial").m_130940_(ChatFormatting.BLUE));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"jeed.tooltip.harmful").m_130940_(ChatFormatting.RED));
            }
            boolean showDescription = reactsToShift && Screen.m_96638_();
            ResourceLocation res = null;
            if (showDescription || tooltipFlag.m_7050_()) {
                res = Registry.f_122823_.m_7981_((Object)effect);
            }
            if (showDescription) {
                tooltip.add((Component)Component.m_237115_((String)("effect." + res.m_135827_() + "." + res.m_135815_() + ".description")).m_130940_(ChatFormatting.GRAY));
            } else {
                ArrayList list1 = Lists.newArrayList();
                Map map = effect.m_19485_();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.m_22214_(), effect.m_7048_(effectInstance.m_19564_(), attributemodifier), attributemodifier.m_22217_());
                        list1.add(new Pair((Object)((Attribute)entry.getKey()), (Object)attributemodifier1));
                    }
                }
                if (!list1.isEmpty()) {
                    tooltip.add((Component)Component.m_237119_());
                    tooltip.add((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
                    for (Pair pair : list1) {
                        AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                        double d0 = attributemodifier2.m_22218_();
                        double d1 = attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.m_22218_() : attributemodifier2.m_22218_() * 100.0;
                        if (d0 > 0.0) {
                            tooltip.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + attributemodifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                            continue;
                        }
                        if (!(d0 < 0.0)) continue;
                        tooltip.add((Component)Component.m_237110_((String)("attribute.modifier.take." + attributemodifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.RED));
                    }
                }
            }
            if (tooltipFlag.m_7050_()) {
                tooltip.add((Component)Component.m_237113_((String)res.toString()).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
        return tooltip;
    }
}

