/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.common;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.jeed.api.IEffectScreenExtension;
import net.mehvahdjukaar.jeed.common.EffectRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.TooltipFlag;

public class ScreenExtensionsHandler {
    public static final Map<Class<? extends Screen>, IEffectScreenExtension<? extends Screen>> EXTENSIONS = new IdentityHashMap<Class<? extends Screen>, IEffectScreenExtension<? extends Screen>>();

    public static <T extends Screen, E extends IEffectScreenExtension<T>> E getExtension(T screen) {
        Class<?> c = screen.getClass();
        IEffectScreenExtension<? extends Screen> direct = EXTENSIONS.get(c);
        if (direct != null) {
            return (E)direct;
        }
        for (Map.Entry<Class<? extends Screen>, IEffectScreenExtension<? extends Screen>> e : EXTENSIONS.entrySet()) {
            if (!e.getKey().isInstance(screen)) continue;
            return (E)e.getValue();
        }
        return null;
    }

    public static <T extends Screen> void registerScreenExtension(Class<T> screenClass, IEffectScreenExtension<T> extension) {
        EXTENSIONS.put(screenClass, extension);
    }

    public static <T extends Screen> void unRegisterExtension(Class<T> screenClass) {
        EXTENSIONS.remove(screenClass);
    }

    public static void renderEffectTooltip(MobEffectInstance effect, Screen screen, PoseStack matrixStack, int x, int y, boolean showDuration) {
        TooltipFlag.Default flag = Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
        List<Component> tooltip = EffectRenderer.getTooltipsWithDescription(effect, (TooltipFlag)flag, true, showDuration);
        if (!tooltip.isEmpty()) {
            screen.m_96597_(matrixStack, tooltip, x, y);
        }
    }
}

