/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.plugin.rei.display;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.CloseableScissors;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class ScrollableTextWidget
extends WidgetWithBounds {
    private final Rectangle bounds;
    private final List<FormattedCharSequence> texts;
    private final ScrollingContainer scrolling = new ScrollingContainer(){

        public Rectangle getBounds() {
            Rectangle bounds = ScrollableTextWidget.this.getBounds();
            return new Rectangle(bounds.x + 1, bounds.y + 1, bounds.width - 2, bounds.height - 2);
        }

        public int getMaxScrollHeight() {
            int i = 2;
            for (FormattedCharSequence entry : ScrollableTextWidget.this.texts) {
                int n;
                if (entry == null) {
                    n = 4;
                } else {
                    Objects.requireNonNull(ScrollableTextWidget.this.font);
                    n = 9;
                }
                i += n;
            }
            return i;
        }
    };

    public ScrollableTextWidget(Rectangle bounds, List<Component> texts) {
        this.bounds = Objects.requireNonNull(bounds);
        this.texts = Lists.newArrayList();
        for (FormattedText formattedText : texts) {
            if (!this.texts.isEmpty()) {
                this.texts.add(null);
            }
            this.texts.addAll(Minecraft.m_91087_().f_91062_.m_92923_(formattedText, bounds.width - 11));
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.containsMouse(mouseX, mouseY)) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -amount, true);
            return true;
        }
        return false;
    }

    @Nullable
    public GuiEventListener m_7222_() {
        return null;
    }

    public void m_7522_(@Nullable GuiEventListener focused) {
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.scrolling.updateDraggingState(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_7282_() {
        return false;
    }

    public void m_7897_(boolean isDragging) {
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.scrolling.updatePosition(delta);
        Rectangle innerBounds = this.scrolling.getScissorBounds();
        try (CloseableScissors scissors = ScrollableTextWidget.scissor((PoseStack)matrices, (Rectangle)innerBounds);){
            int currentY = -this.scrolling.scrollAmountInt() + innerBounds.y;
            for (FormattedCharSequence text : this.texts) {
                int n;
                if (text != null) {
                    Objects.requireNonNull(this.font);
                    if (currentY + 9 >= innerBounds.y && currentY <= innerBounds.getMaxY()) {
                        this.font.m_92877_(matrices, text, (float)(innerBounds.x + 2), (float)(currentY + 2), REIRuntime.getInstance().isDarkThemeEnabled() ? -4473925 : -16185079);
                    }
                }
                if (text == null) {
                    n = 4;
                } else {
                    Objects.requireNonNull(this.font);
                    n = 9;
                }
                currentY += n;
            }
        }
        if (this.scrolling.hasScrollBar()) {
            if (this.scrolling.scrollAmount() > 8.0) {
                this.m_93179_(matrices, innerBounds.x, innerBounds.y, innerBounds.getMaxX(), innerBounds.y + 16, -3750202, 0xC6C6C6);
            }
            if ((double)this.scrolling.getMaxScroll() - this.scrolling.scrollAmount() > 8.0) {
                this.m_93179_(matrices, innerBounds.x, innerBounds.getMaxY() - 16, innerBounds.getMaxX(), innerBounds.getMaxY(), 0xC6C6C6, -3750202);
            }
        }
        scissors = ScrollableTextWidget.scissor((PoseStack)matrices, (Rectangle)this.scrolling.getBounds());
        try {
            this.scrolling.renderScrollBar(0, 1.0f, 1.0f);
        }
        finally {
            if (scissors != null) {
                scissors.close();
            }
        }
    }

    public List<? extends GuiEventListener> m_6702_() {
        return Collections.emptyList();
    }
}

