/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.component;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.__internal__.ApiSide;
import mcp.mobius.waila.api.__internal__.IApiService;
import mcp.mobius.waila.api.component.WrappedComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;

@ApiSide.ClientOnly
public class PairComponent
implements ITooltipComponent {
    public final ITooltipComponent key;
    public final ITooltipComponent value;
    private final int height;

    public PairComponent(Component key, Component value) {
        this(new WrappedComponent(key), new WrappedComponent(value));
    }

    public PairComponent(ITooltipComponent key, ITooltipComponent value) {
        this.key = key;
        this.value = value;
        this.height = Math.max(key.getHeight(), value.getHeight());
    }

    @Override
    public int getWidth() {
        return this.getColonOffset() + this.getColonWidth() + this.value.getWidth();
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void render(PoseStack matrices, int x, int y, float delta) {
        int n;
        int offset = this.key.getHeight() < this.height ? (this.height - this.key.getHeight()) / 2 : 0;
        IApiService.INSTANCE.renderComponent(matrices, this.key, x, y + offset, delta);
        Font font = Minecraft.m_91087_().f_91062_;
        Objects.requireNonNull(font);
        if (9 < this.height) {
            Objects.requireNonNull(font);
            n = (this.height - 9) / 2;
        } else {
            n = 0;
        }
        offset = n;
        font.m_92750_(matrices, ": ", (float)(x + this.getColonOffset()), (float)(y + offset), IWailaConfig.get().getOverlay().getColor().getTheme().getDefaultTextColor());
        offset = this.value.getHeight() < this.height ? (this.height - this.value.getHeight()) / 2 : 0;
        IApiService.INSTANCE.renderComponent(matrices, this.value, x + this.getColonOffset() + this.getColonWidth(), y + offset, delta);
    }

    private int getColonOffset() {
        return IApiService.INSTANCE.getPairComponentColonOffset();
    }

    private int getColonWidth() {
        return IApiService.INSTANCE.getColonFontWidth();
    }
}

