/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.config;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.config.ConfigEntry;
import mcp.mobius.waila.mcless.config.ConfigIo;
import mcp.mobius.waila.util.Log;
import net.minecraft.resources.ResourceLocation;

public enum PluginConfig implements IPluginConfig
{
    CLIENT,
    SERVER;

    private static final Log LOG;
    private static final Path PATH;
    private static final ConfigIo<Map<String, Map<String, JsonPrimitive>>> IO;
    private static final Map<ResourceLocation, ConfigEntry<Object>> CONFIGS;

    public static <T> void addConfig(ConfigEntry<T> entry) {
        CONFIGS.put(entry.getId(), entry);
    }

    private static Stream<ResourceLocation> getKeyStream() {
        return CONFIGS.keySet().stream().filter(it -> PluginConfig.getEntry(it).getOrigin().isEnabled());
    }

    public static Set<ResourceLocation> getAllKeys(String namespace) {
        return PluginConfig.getKeyStream().filter(id -> id.m_135827_().equals(namespace)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<ResourceLocation> getAllKeys() {
        return PluginConfig.getKeyStream().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<ConfigEntry<Object>> getSyncableConfigs() {
        return CONFIGS.values().stream().filter(ConfigEntry::isSynced).collect(Collectors.toSet());
    }

    public static List<String> getNamespaces() {
        return CONFIGS.keySet().stream().map(ResourceLocation::m_135827_).distinct().sorted((o1, o2) -> o1.equals("waila") ? -1 : (o2.equals("waila") ? 1 : o1.compareToIgnoreCase((String)o2))).collect(Collectors.toList());
    }

    public static <T> ConfigEntry<T> getEntry(ResourceLocation key) {
        return CONFIGS.get(key);
    }

    public static <T> void set(ResourceLocation key, T value) {
        ConfigEntry<Object> entry = CONFIGS.get(key);
        if (entry != null) {
            entry.setLocalValue(value);
        }
    }

    public static void reload() {
        if (!Files.exists(PATH, new LinkOption[0])) {
            PluginConfig.writeConfig();
        }
        Map<String, Map<String, JsonPrimitive>> config = IO.read(PATH);
        config.forEach((namespace, subMap) -> subMap.forEach((path, value) -> {
            ConfigEntry<Object> entry = CONFIGS.get(new ResourceLocation(namespace, path));
            if (entry != null) {
                entry.setLocalValue(entry.getType().parser.apply((JsonPrimitive)value, (JsonPrimitive)entry.getDefaultValue()));
            }
        }));
        LOG.info("Plugin config reloaded");
    }

    public static void save() {
        PluginConfig.writeConfig();
    }

    private static void writeConfig() {
        LinkedHashMap<String, Map> config = new LinkedHashMap<String, Map>();
        for (ConfigEntry<Object> entry : CONFIGS.values()) {
            if (entry.isAlias()) continue;
            ResourceLocation id = entry.getId();
            config.computeIfAbsent(id.m_135827_(), k -> new LinkedHashMap()).put(id.m_135815_(), entry.getType().serializer.apply(entry.getLocalValue()));
        }
        IO.write(PATH, config);
    }

    private <T> T getValue(ResourceLocation key, T defaultValue) {
        ConfigEntry<Object> entry = CONFIGS.get(key);
        if (entry != null && entry.getOrigin().isEnabled()) {
            return (T)entry.getValue(this == SERVER);
        }
        if (Waila.DEV) {
            LOG.error("Unknown plugin config key {}", key);
        }
        return defaultValue;
    }

    @Override
    public Set<ResourceLocation> getKeys() {
        return PluginConfig.getAllKeys();
    }

    @Override
    public Set<ResourceLocation> getKeys(String namespace) {
        return PluginConfig.getAllKeys(namespace);
    }

    @Override
    public boolean getBoolean(ResourceLocation key) {
        return this.getValue(key, false);
    }

    @Override
    public int getInt(ResourceLocation key) {
        return this.getValue(key, 0);
    }

    @Override
    public double getDouble(ResourceLocation key) {
        return this.getValue(key, 0.0);
    }

    @Override
    public String getString(ResourceLocation key) {
        return this.getValue(key, "");
    }

    @Override
    public <T extends Enum<T>> T getEnum(ResourceLocation key) {
        return (T)((Enum)this.getValue(key, null));
    }

    static {
        LOG = Log.create();
        PATH = Waila.CONFIG_DIR.resolve("waila/waila_plugins.json");
        IO = new ConfigIo<Map>(LOG::warn, LOG::error, new GsonBuilder().setPrettyPrinting().create(), new TypeToken<Map<String, Map<String, JsonPrimitive>>>(){}.getType(), LinkedHashMap::new);
        CONFIGS = new LinkedHashMap<ResourceLocation, ConfigEntry<Object>>();
    }
}

