/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.widget;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import mcp.mobius.waila.gui.screen.ConfigScreen;
import mcp.mobius.waila.gui.widget.CategoryEntry;
import mcp.mobius.waila.gui.widget.value.ConfigValue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigListWidget
extends ContainerObjectSelectionList<Entry> {
    private final ConfigScreen owner;
    @Nullable
    private final Runnable diskWriter;
    private int topOffset;
    private int bottomOffset;
    public boolean enableSearchBox = true;
    @Nullable
    private EditBox searchBox;
    @Nullable
    public String filter = null;
    public String @Nullable [] splitFilter = null;

    public ConfigListWidget(ConfigScreen owner, Minecraft client, int width, int height, int top, int bottom, int itemHeight, @Nullable Runnable diskWriter) {
        super(client, width, height, top, bottom, itemHeight - 4);
        this.owner = owner;
        this.diskWriter = diskWriter;
        this.resize(top, bottom);
        this.m_93488_(false);
    }

    public ConfigListWidget(ConfigScreen owner, Minecraft client, int width, int height, int top, int bottom, int itemHeight) {
        this(owner, client, width, height, top, bottom, itemHeight, null);
    }

    public int m_5759_() {
        return Math.min(this.f_93388_ - 20, 450);
    }

    protected int m_5756_() {
        return this.f_93386_.m_91268_().m_85445_() - 5;
    }

    public void tick() {
        if (this.searchBox != null) {
            this.searchBox.m_94120_();
        }
        this.m_6702_().forEach(Entry::tick);
    }

    public boolean save(boolean ignoreErrors) {
        List<ConfigValue> values = this.m_6702_().stream().filter(e -> e instanceof ConfigValue).map(e -> (ConfigValue)((Object)e)).toList();
        if (values.stream().allMatch(ConfigValue::isValueValid)) {
            values.forEach(ConfigValue::save);
            if (this.diskWriter != null) {
                this.diskWriter.run();
            }
            return true;
        }
        if (!ignoreErrors) {
            this.f_93386_.m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)Component.m_237115_((String)"config.waila.invalid_input.title"), (Component)Component.m_237115_((String)"config.waila.invalid_input.desc")));
        }
        return ignoreErrors;
    }

    public EditBox getSearchBox() {
        Preconditions.checkState((boolean)this.enableSearchBox);
        return Objects.requireNonNull(this.searchBox);
    }

    public void init() {
        List<Entry> dirtyChildren = List.copyOf(this.m_6702_());
        for (Entry child : dirtyChildren) {
            child.clear(this);
        }
        List<Entry> rootChildren = List.copyOf(this.m_6702_());
        int index = 0;
        for (Entry child : rootChildren) {
            index += child.init(this, index);
        }
        for (Entry child : this.m_6702_()) {
            child.m_7522_(null);
        }
        if (this.enableSearchBox && this.searchBox == null) {
            this.searchBox = new EditBox(this.f_93386_.f_91062_, 0, 0, 160, 18, (Component)Component.m_237115_((String)"config.waila.search_prompt"));
            this.searchBox.m_94151_(filter -> {
                boolean isBlank = filter.isBlank();
                if (isBlank && this.filter == null || filter.equals(this.filter)) {
                    return;
                }
                this.m_6702_().clear();
                if (isBlank) {
                    this.filter = null;
                    this.splitFilter = null;
                    this.m_6702_().addAll(rootChildren);
                } else {
                    this.filter = filter;
                    this.splitFilter = filter.split("\\s");
                    this.m_6702_().addAll(rootChildren.stream().filter(it -> it.match(this.splitFilter)).toList());
                }
                this.init();
            });
        }
        this.resize(this.topOffset, this.owner.f_96544_ + this.bottomOffset);
        this.m_93410_(this.m_93517_());
    }

    public void add(Entry entry) {
        this.add(this.m_6702_().size(), entry);
    }

    public void add(int index, Entry entry) {
        this.m_6702_().add(index, entry);
    }

    public ConfigListWidget with(Entry entry) {
        return this.with(this.m_6702_().size(), entry);
    }

    public ConfigListWidget with(int index, Entry entry) {
        this.add(index, entry);
        return this;
    }

    public void resize(int top, int bottom) {
        this.topOffset = top;
        this.bottomOffset = bottom - this.owner.f_96544_;
        this.m_93437_(this.owner.f_96543_, this.owner.f_96544_, this.topOffset, this.owner.f_96544_ + this.bottomOffset);
        if (this.searchBox != null) {
            this.searchBox.m_94214_(this.m_5747_() + this.m_5759_() - 160);
            this.searchBox.f_93621_ = (top - 18) / 2;
        }
    }

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        protected final Minecraft client = Minecraft.m_91087_();
        @Nullable
        protected List<? extends GuiEventListener> children;
        @Nullable
        protected List<? extends NarratableEntry> narratables;
        protected ConfigListWidget list;
        protected int index;
        @Nullable
        public CategoryEntry category;
        public int categoryDepth;

        public void tick() {
        }

        public final int init(ConfigListWidget list, int index) {
            Preconditions.checkState((list.m_6702_().get(index) == this ? 1 : 0) != 0);
            this.list = list;
            this.index = index;
            return this.init();
        }

        public int init() {
            return 1;
        }

        public void clear(ConfigListWidget list) {
        }

        protected void gatherChildren(ImmutableList.Builder<GuiEventListener> children) {
        }

        protected void gatherNarratables(ImmutableList.Builder<NarratableEntry> narratables) {
        }

        protected abstract void buildSearchKey(StringBuilder var1);

        public final boolean match(String[] filter) {
            StringBuilder sb = new StringBuilder();
            this.buildSearchKey(sb);
            for (String s : filter) {
                if (!StringUtils.containsIgnoreCase((CharSequence)sb.toString(), (CharSequence)s)) continue;
                return true;
            }
            return false;
        }

        @NotNull
        public List<? extends GuiEventListener> m_6702_() {
            if (this.children == null) {
                ImmutableList.Builder builder = ImmutableList.builder();
                this.gatherChildren((ImmutableList.Builder<GuiEventListener>)builder);
                this.children = builder.build();
            }
            return this.children;
        }

        @NotNull
        public List<? extends NarratableEntry> m_142437_() {
            if (this.narratables == null) {
                ImmutableList.Builder builder = ImmutableList.builder();
                this.gatherNarratables((ImmutableList.Builder<NarratableEntry>)builder);
                this.narratables = builder.build();
            }
            return this.narratables;
        }

        public final void m_6311_(@NotNull PoseStack matrices, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
            if (this.category != null) {
                for (int i = 0; i < this.categoryDepth; ++i) {
                    int lineX1 = rowLeft + 5 + i * 16;
                    int lineX2 = lineX1 + 2;
                    int lineY1 = rowTop - height / 2 - 4;
                    int lineY2 = lineY1 + height + 4;
                    if (i == this.categoryDepth - 1 && index - this.category.index == 1) {
                        lineY1 += 8;
                    }
                    GuiComponent.m_93172_((PoseStack)matrices, (int)lineX1, (int)lineY1, (int)lineX2, (int)lineY2, (int)0x22FAFAFA);
                }
                int offset = this.categoryDepth * 16;
                rowLeft += offset;
                width -= offset;
            }
            this.drawEntry(matrices, index, rowTop, rowLeft, width, height, mouseX, mouseY, hovered, deltaTime);
        }

        protected abstract void drawEntry(PoseStack var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);

        public void renderTooltip(Screen screen, PoseStack matrices, int mouseX, int mouseY, float delta) {
        }
    }
}

