/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.extra.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcp.mobius.waila.api.data.FluidData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class FluidDataImpl
extends FluidData.PlatformDependant<Object> {
    private final List<Entry<?>> entries;
    private final FluidData.PlatformTranslator<Object> proxy;
    private final FluidData.Unit unit;

    public FluidDataImpl(@Nullable FluidData.PlatformTranslator<Object> proxy, FluidData.Unit unit, int slotCountHint) {
        this.entries = slotCountHint == -1 ? new ArrayList() : new ArrayList(slotCountHint);
        this.proxy = proxy;
        this.unit = unit;
    }

    public FluidDataImpl(FriendlyByteBuf buf) {
        this.proxy = null;
        this.unit = (FluidData.Unit)buf.m_130066_(FluidData.Unit.class);
        int size = buf.m_130242_();
        this.entries = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            if (buf.readBoolean()) continue;
            int id = buf.m_130242_();
            Fluid fluid = (Fluid)Registry.f_122822_.m_7942_(id);
            CompoundTag nbt = buf.m_130260_();
            double stored = buf.readDouble();
            double capacity = buf.readDouble();
            this.add(fluid, nbt, stored, capacity);
        }
    }

    @Override
    protected void implAdd(Fluid fluid, @Nullable CompoundTag nbt, double stored, double capacity) {
        this.entries.add(new Entry<Fluid>(fluid, nbt, stored, capacity));
    }

    @Override
    protected FluidData.PlatformTranslator<Object> translator() {
        return this.proxy;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.unit);
        buf.m_130130_(this.entries.size());
        for (Entry<?> entry : this.entries) {
            if (entry.isEmpty()) {
                buf.writeBoolean(true);
                continue;
            }
            buf.writeBoolean(false);
            buf.m_236818_((IdMap)Registry.f_122822_, entry.fluid);
            buf.m_130079_(entry.nbt);
            buf.writeDouble(entry.stored);
            buf.writeDouble(entry.capacity);
        }
    }

    public FluidData.Unit unit() {
        return this.unit;
    }

    public List<Entry<?>> entries() {
        return this.entries;
    }

    public static class Entry<T extends Fluid>
    implements FluidData.FluidDescriptionContext<T> {
        private final T fluid;
        @Nullable
        private final CompoundTag nbt;
        private final double stored;
        private final double capacity;

        private Entry(T fluid, @Nullable CompoundTag nbt, double stored, double capacity) {
            this.fluid = fluid;
            this.nbt = nbt;
            this.stored = stored;
            this.capacity = capacity;
        }

        public boolean isEmpty() {
            return this.fluid == Fluids.f_76191_ || this.stored <= 0.0;
        }

        @Override
        public T fluid() {
            return this.fluid;
        }

        @Override
        @Nullable
        public CompoundTag nbt() {
            return this.nbt;
        }

        public double stored() {
            return this.stored;
        }

        public double capacity() {
            return this.capacity;
        }
    }

    public static class FluidDescription
    implements FluidData.FluidDescription {
        public static final Map<Fluid, FluidData.FluidDescriptor<Fluid>> FLUID_STATIC = new HashMap<Fluid, FluidData.FluidDescriptor<Fluid>>();
        public static final Map<Class<?>, FluidData.FluidDescriptor<Fluid>> FLUID_DYNAMIC = new HashMap();
        public static final Map<Block, FluidData.CauldronDescriptor> CAULDRON_STATIC = new HashMap<Block, FluidData.CauldronDescriptor>();
        public static final Map<Class<?>, FluidData.CauldronDescriptor> CAULDRON_DYNAMIC = new HashMap();
        private static final FluidDescription INSTANCE = new FluidDescription();
        private static final Component UNKNOWN_FLUID_NAME = Component.m_237115_((String)"tooltip.waila.extra.unknown_fluid");
        private static final FluidData.FluidDescriptor<Fluid> UNKNOWN_FLUID_DESC = (ctx, desc) -> {};
        private static final FluidData.CauldronDescriptor NULL_CAULDRON_DESC = state -> null;
        private TextureAtlasSprite sprite;
        private int tint;
        private Component name;

        public static FluidDescription getFluidDesc(Entry<?> entry) {
            Object fluid = entry.fluid();
            FluidData.FluidDescriptor<Fluid> descriptor = FLUID_STATIC.get(fluid);
            if (descriptor == null) {
                for (Class<?> clazz = fluid.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                    descriptor = FLUID_DYNAMIC.get(clazz);
                    if (descriptor == null) continue;
                    FLUID_DYNAMIC.put(fluid.getClass(), descriptor);
                    break;
                }
            }
            if (descriptor == null) {
                descriptor = UNKNOWN_FLUID_DESC;
                FLUID_STATIC.put((Fluid)fluid, UNKNOWN_FLUID_DESC);
            }
            INSTANCE.sprite(Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(Blocks.f_49990_.m_49966_()).m_6160_()).tint(-1).name(UNKNOWN_FLUID_NAME);
            descriptor.describeFluid(entry, INSTANCE);
            return INSTANCE;
        }

        @Nullable
        public static FluidData getCauldronFluidData(BlockState state) {
            Block block = state.m_60734_();
            FluidData.CauldronDescriptor getter = CAULDRON_STATIC.get(block);
            if (getter == null) {
                for (Class<?> clazz = block.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                    getter = CAULDRON_DYNAMIC.get(clazz);
                    if (getter == null) continue;
                    CAULDRON_DYNAMIC.put(block.getClass(), getter);
                    break;
                }
            }
            if (getter == null) {
                getter = NULL_CAULDRON_DESC;
                CAULDRON_STATIC.put(block, NULL_CAULDRON_DESC);
            }
            return getter.getCauldronFluidData(state);
        }

        public Component name() {
            return this.name;
        }

        public TextureAtlasSprite sprite() {
            return this.sprite;
        }

        public int tint() {
            return this.tint;
        }

        @Override
        public FluidDescription name(Component name) {
            this.name = name;
            return this;
        }

        @Override
        public FluidDescription sprite(TextureAtlasSprite sprite) {
            this.sprite = sprite;
            return this;
        }

        @Override
        public FluidDescription tint(int argb) {
            this.tint = argb;
            return this;
        }
    }
}

