/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.harvest.provider;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipLine;
import mcp.mobius.waila.api.component.GrowingComponent;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.plugin.harvest.component.ToolComponent;
import mcp.mobius.waila.plugin.harvest.config.HarvestDisplayMode;
import mcp.mobius.waila.plugin.harvest.config.Options;
import mcp.mobius.waila.plugin.harvest.tool.ToolTier;
import mcp.mobius.waila.plugin.harvest.tool.ToolType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public enum HarvestProvider implements IBlockComponentProvider,
IEventListener
{
    INSTANCE;

    private static final ToolType UNBREAKABLE;
    public final Map<BlockState, List<ToolType>> toolsCache = new Reference2ObjectOpenHashMap();
    public final Map<BlockState, ToolTier> tierCache = new Reference2ObjectOpenHashMap();
    private int updateId = 0;
    private BlockState state;
    private final List<ToolComponent> toolComponents = new ArrayList<ToolComponent>();
    private boolean renderComponents = false;

    @Override
    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        HarvestDisplayMode harvestDisplayMode;
        ToolTier highestTier;
        if (!config.getBoolean(Options.ENABLED)) {
            return;
        }
        if (accessor.getPlayer().m_7500_() && !config.getBoolean(Options.CREATIVE)) {
            return;
        }
        this.updateId = accessor.getUpdateId();
        this.state = accessor.getBlockState();
        boolean unbreakable = this.state.m_60800_((BlockGetter)accessor.getWorld(), accessor.getPosition()) < 0.0f;
        List<ToolType> tools = this.toolsCache.get(this.state);
        if (tools == null) {
            tools = new ArrayList<ToolType>();
            if (unbreakable) {
                tools.add(UNBREAKABLE);
            } else {
                for (ToolType toolType : ToolType.all()) {
                    if (!toolType.blockPredicate.test(this.state)) continue;
                    tools.add(toolType);
                }
                if (tools.isEmpty()) {
                    tools = List.of();
                }
            }
            this.toolsCache.put(this.state, tools);
        }
        if ((highestTier = this.tierCache.get(this.state)) == null) {
            highestTier = ToolTier.NONE;
            for (ToolTier tier : ToolTier.all()) {
                if (tier.tag == null || !this.state.m_204336_(tier.tag)) continue;
                highestTier = tier;
            }
            this.tierCache.put(this.state, highestTier);
        }
        if ((harvestDisplayMode = (HarvestDisplayMode)((Object)config.getEnum(Options.DISPLAY_MODE))) == HarvestDisplayMode.MODERN) {
            return;
        }
        ItemStack heldStack = accessor.getPlayer().m_150109_().m_36056_();
        if (harvestDisplayMode == HarvestDisplayMode.CLASSIC) {
            tooltip.addLine((Component)Component.m_237119_().m_7220_((Component)this.getHarvestableSymbol(accessor, unbreakable)).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"tooltip.waila.harvest.harvestable")));
            if (!tools.isEmpty() && !unbreakable) {
                tooltip.addLine(new PairComponent((Component)Component.m_237115_((String)"tooltip.waila.harvest.effective_tool"), (Component)HarvestProvider.getToolText(tools, heldStack)));
            }
            if (highestTier != ToolTier.NONE) {
                tooltip.addLine(new PairComponent((Component)Component.m_237115_((String)"tooltip.waila.harvest.level"), (Component)HarvestProvider.getTierText(highestTier, heldStack)));
            }
        } else if (harvestDisplayMode == HarvestDisplayMode.CLASSIC_MINIMAL) {
            MutableComponent text = Component.m_237119_();
            text.m_7220_((Component)this.getHarvestableSymbol(accessor, unbreakable));
            if (!tools.isEmpty() && !unbreakable) {
                text.m_130946_(" | ").m_7220_((Component)HarvestProvider.getToolText(tools, heldStack));
                if (highestTier != ToolTier.NONE) {
                    text.m_130946_(" | ");
                }
            }
            if (highestTier != ToolTier.NONE) {
                text.m_7220_((Component)HarvestProvider.getTierText(highestTier, heldStack));
            }
            tooltip.addLine((Component)text);
        }
    }

    @Override
    public void onHandleTooltip(ITooltip tooltip, ICommonAccessor accessor, IPluginConfig config) {
        this.renderComponents = false;
        if (!config.getBoolean(Options.ENABLED)) {
            return;
        }
        HarvestDisplayMode displayMode = (HarvestDisplayMode)((Object)config.getEnum(Options.DISPLAY_MODE));
        if (displayMode != HarvestDisplayMode.MODERN) {
            return;
        }
        if (this.updateId != accessor.getUpdateId()) {
            return;
        }
        List<ToolType> tools = this.toolsCache.get(this.state);
        ToolTier highestTier = this.tierCache.get(this.state);
        if (tools == null || highestTier == null || tools.isEmpty()) {
            return;
        }
        ItemStack heldStack = accessor.getPlayer().m_150109_().m_36056_();
        ITooltipLine line = tooltip.getLine(tooltip.getLineCount() - 1);
        line.with(GrowingComponent.INSTANCE);
        this.toolComponents.clear();
        for (ToolType tool : tools) {
            ToolComponent component;
            if (tool == UNBREAKABLE) {
                component = new ToolComponent(null, false);
            } else {
                ItemStack icon = tool.getIcon(highestTier);
                Boolean matches = null;
                if (this.state.m_60834_()) {
                    Item item;
                    matches = tool.itemPredicate.test(heldStack);
                    if (highestTier != ToolTier.NONE && (item = heldStack.m_41720_()) instanceof TieredItem) {
                        TieredItem tiered = (TieredItem)item;
                        ToolTier heldTier = ToolTier.get(tiered.m_43314_());
                        matches = matches != false && heldTier != null && heldTier.isBetterThanOrEqualTo(highestTier);
                    }
                }
                component = new ToolComponent(icon, matches);
            }
            line.with(component);
            this.toolComponents.add(component);
        }
        this.renderComponents = true;
    }

    @Override
    public void onAfterTooltipRender(PoseStack matrices, Rectangle rect, ICommonAccessor accessor, IPluginConfig config) {
        if (!this.renderComponents) {
            return;
        }
        for (ToolComponent component : this.toolComponents) {
            component.actuallyRender(matrices, rect.y + rect.height - 13);
        }
    }

    @NotNull
    private MutableComponent getHarvestableSymbol(IBlockAccessor accessor, boolean unbreakable) {
        return unbreakable || !accessor.getPlayer().m_36298_(this.state) ? Component.m_237113_((String)"\u2718").m_130940_(ChatFormatting.RED) : Component.m_237113_((String)"\u2714").m_130940_(ChatFormatting.GREEN);
    }

    @NotNull
    private static MutableComponent getToolText(List<ToolType> tools, ItemStack heldStack) {
        MutableComponent toolText = Component.m_237119_();
        Iterator<ToolType> toolIter = tools.iterator();
        while (toolIter.hasNext()) {
            ToolType tool = toolIter.next();
            if (tool == UNBREAKABLE) continue;
            toolText.m_7220_((Component)tool.text.m_6881_().m_130940_(tool.itemPredicate.test(heldStack) ? ChatFormatting.GREEN : ChatFormatting.RED));
            if (!toolIter.hasNext()) continue;
            toolText.m_130946_(", ");
        }
        return toolText;
    }

    @NotNull
    private static MutableComponent getTierText(ToolTier highestTier, ItemStack heldStack) {
        MutableComponent tierText = I18n.m_118936_((String)highestTier.tlKey()) ? Component.m_237115_((String)highestTier.tlKey()) : Component.m_237113_((String)String.valueOf(highestTier.index));
        Item item = heldStack.m_41720_();
        if (item instanceof TieredItem) {
            TieredItem tiered = (TieredItem)item;
            ToolTier heldTier = ToolTier.get(tiered.m_43314_());
            tierText.m_130940_(heldTier != null && heldTier.isBetterThanOrEqualTo(highestTier) ? ChatFormatting.GREEN : ChatFormatting.RED);
        } else {
            tierText.m_130940_(ChatFormatting.RED);
        }
        return tierText;
    }

    static {
        UNBREAKABLE = new ToolType();
    }
}

