/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import java.text.DecimalFormat;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipLine;
import mcp.mobius.waila.api.component.ArmorComponent;
import mcp.mobius.waila.api.component.HealthComponent;
import mcp.mobius.waila.api.component.PositionComponent;
import mcp.mobius.waila.api.component.SpacingComponent;
import mcp.mobius.waila.api.component.TextureComponent;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public enum EntityAttributesProvider implements IEntityComponentProvider,
IDataProvider<Entity>
{
    INSTANCE;

    private static final DecimalFormat DECIMAL;

    private int addSpacing(ITooltipLine line, int i) {
        if (i > 0) {
            line.with(new SpacingComponent(3, 0));
            return i - 1;
        }
        return 0;
    }

    private void addHealth(ITooltipLine line, LivingEntity entity, CompoundTag data, boolean showAbsorption) {
        MutableComponent component = Component.m_237113_((String)DECIMAL.format(entity.m_21223_()));
        if (showAbsorption && data.m_128441_("abs")) {
            component.m_7220_((Component)Component.m_237113_((String)("+" + DECIMAL.format(data.m_128457_("abs")))).m_130940_(ChatFormatting.GOLD));
        }
        line.with(new TextureComponent(GuiComponent.f_93098_, 8, 8, 52, 0, 9, 9, 256, 256)).with((Component)component.m_130946_("/" + DECIMAL.format(entity.m_21233_())).m_130940_(ChatFormatting.RED));
    }

    private void addArmor(ITooltipLine line, LivingEntity entity) {
        line.with(new TextureComponent(GuiComponent.f_93098_, 8, 8, 34, 9, 9, 9, 256, 256)).with((Component)Component.m_237113_((String)String.valueOf(entity.m_21230_())));
    }

    @Override
    public void appendHead(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        Object t = accessor.getEntity();
        if (!(t instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity = (LivingEntity)t;
        boolean compact = config.getBoolean(Options.ENTITY_COMPACT);
        boolean showHealth = config.getBoolean(Options.ENTITY_HEALTH);
        boolean showAbsorption = config.getBoolean(Options.ENTITY_ABSORPTION);
        boolean showArmor = config.getBoolean(Options.ENTITY_ARMOR) && entity.m_21230_() > 0;
        CompoundTag data = accessor.getData().raw();
        if (compact) {
            ITooltipLine line = tooltip.addLine();
            int i = 0;
            if (showHealth) {
                i = this.addSpacing(line, i);
                this.addHealth(line, entity, data, showAbsorption);
                ++i;
            }
            if (showArmor) {
                i = this.addSpacing(line, i);
                this.addArmor(line, entity);
                ++i;
            }
        } else {
            int maxPerLine = config.getInt(Options.ENTITY_ICON_PER_LINE);
            if (showHealth) {
                float absorption;
                float f = absorption = data.m_128441_("abs") ? data.m_128457_("abs") : 0.0f;
                if (entity.m_21233_() + absorption > (float)config.getInt(Options.ENTITY_LONG_HEALTH_MAX)) {
                    this.addHealth(tooltip.addLine(), entity, data, showAbsorption);
                } else {
                    tooltip.addLine(new HealthComponent(entity.m_21223_(), entity.m_21233_(), maxPerLine, false));
                    if (showAbsorption && absorption > 0.0f) {
                        tooltip.addLine(new HealthComponent(absorption, 0.0f, maxPerLine, true));
                    }
                }
            }
            if (showArmor) {
                if (entity.m_21230_() > config.getInt(Options.ENTITY_LONG_ARMOR_MAX)) {
                    this.addArmor(tooltip.addLine(), entity);
                } else {
                    tooltip.addLine(new ArmorComponent(entity.m_21230_(), maxPerLine));
                }
            }
        }
    }

    @Override
    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(Options.ENTITY_POSITION)) {
            tooltip.addLine(new PositionComponent((Position)accessor.getEntity().m_20182_()));
        }
    }

    @Override
    public void appendData(IDataWriter data, IServerAccessor<Entity> accessor, IPluginConfig config) {
        Entity entity = accessor.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (config.getBoolean(Options.ENTITY_ABSORPTION) && living.m_6103_() > 0.0f) {
                data.raw().m_128350_("abs", living.m_6103_());
            }
        }
    }

    static {
        DECIMAL = new DecimalFormat("0.##");
    }
}

