/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.MangrovePropaguleBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public enum PlantProvider implements IBlockComponentProvider
{
    INSTANCE;


    private static void addMaturityTooltip(ITooltip tooltip, float growthValue) {
        if ((growthValue *= 100.0f) < 100.0f) {
            tooltip.addLine(new PairComponent((Component)Component.m_237115_((String)"tooltip.waila.crop_growth"), (Component)Component.m_237113_((String)String.format("%.0f%%", Float.valueOf(growthValue)))));
        } else {
            tooltip.addLine(new PairComponent((Component)Component.m_237115_((String)"tooltip.waila.crop_growth"), (Component)Component.m_237115_((String)"tooltip.waila.crop_mature")));
        }
    }

    private static void addGrowableTooltip(ITooltip tooltip, String translationKey, boolean growable) {
        tooltip.addLine(new PairComponent((Component)Component.m_237115_((String)translationKey), (Component)(growable ? Component.m_237115_((String)"tooltip.waila.true") : Component.m_237115_((String)"tooltip.waila.false"))));
    }

    private static void addCropGrowableTooltip(ITooltip tooltip, IBlockAccessor accessor) {
        int lightLevel = accessor.getWorld().m_45524_(accessor.getPosition(), 0);
        PlantProvider.addGrowableTooltip(tooltip, "tooltip.waila.crop_growable", lightLevel >= 9);
    }

    private static void addTreeGrowableTooltip(ITooltip tooltip, IBlockAccessor accessor) {
        boolean growable;
        int lightLevel = accessor.getWorld().m_45524_(accessor.getPosition(), 0);
        boolean bl = growable = lightLevel >= 9;
        if (accessor.getBlock() instanceof MangrovePropaguleBlock && ((Boolean)accessor.getBlockState().m_61143_((Property)MangrovePropaguleBlock.f_221443_)).booleanValue()) {
            growable = false;
        }
        PlantProvider.addGrowableTooltip(tooltip, "tooltip.waila.tree_growable", growable);
    }

    @Override
    @Nullable
    public ITooltipComponent getIcon(IBlockAccessor accessor, IPluginConfig config) {
        if (accessor.getBlock() == Blocks.f_50092_) {
            return new ItemComponent((ItemLike)Items.f_42405_);
        }
        if (accessor.getBlock() == Blocks.f_50444_) {
            return new ItemComponent((ItemLike)Items.f_42732_);
        }
        return null;
    }

    @Override
    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(Options.PLANT_CROP_PROGRESS)) {
            Block block = accessor.getBlock();
            if (block instanceof CropBlock) {
                CropBlock crop = (CropBlock)block;
                PlantProvider.addMaturityTooltip(tooltip, (float)((Integer)accessor.getBlockState().m_61143_((Property)crop.m_7959_())).intValue() / (float)crop.m_7419_());
            } else if (accessor.getBlock() == Blocks.f_50190_ || accessor.getBlock() == Blocks.f_50189_) {
                PlantProvider.addMaturityTooltip(tooltip, (float)((Integer)accessor.getBlockState().m_61143_((Property)BlockStateProperties.f_61409_)).intValue() / 7.0f);
            } else if (accessor.getBlock() == Blocks.f_50262_) {
                PlantProvider.addMaturityTooltip(tooltip, (float)((Integer)accessor.getBlockState().m_61143_((Property)BlockStateProperties.f_61406_)).intValue() / 2.0f);
            } else if (accessor.getBlock() == Blocks.f_50685_) {
                PlantProvider.addMaturityTooltip(tooltip, (float)((Integer)accessor.getBlockState().m_61143_((Property)BlockStateProperties.f_61407_)).intValue() / 3.0f);
            } else if (accessor.getBlock() == Blocks.f_50200_) {
                PlantProvider.addMaturityTooltip(tooltip, (float)((Integer)accessor.getBlockState().m_61143_((Property)BlockStateProperties.f_61407_)).intValue() / 3.0f);
            }
        }
        if (config.getBoolean(Options.PLANT_CROP_GROWABLE) && (accessor.getBlock() instanceof CropBlock || accessor.getBlock() instanceof StemBlock) && IModInfo.get(accessor.getBlock()).getId().equals("minecraft")) {
            PlantProvider.addCropGrowableTooltip(tooltip, accessor);
        }
        if (config.getBoolean(Options.PLANT_TREE_GROWABLE) && accessor.getBlock() instanceof SaplingBlock && IModInfo.get(accessor.getBlock()).getId().equals("minecraft")) {
            PlantProvider.addTreeGrowableTooltip(tooltip, accessor);
        }
    }
}

