/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.api.reactor.ReactantType;
import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.compat.patchouli.PatchouliCompat;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.AbstractMultiblockScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonIcons;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.MultiblockReactor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorFluidAccessPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.ReactorVariant;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.ButtonState;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractButtonControl;
import it.zerono.mods.zerocore.lib.client.gui.control.Button;
import it.zerono.mods.zerocore.lib.client.gui.control.GaugeBar;
import it.zerono.mods.zerocore.lib.client.gui.control.Panel;
import it.zerono.mods.zerocore.lib.client.gui.control.Picture;
import it.zerono.mods.zerocore.lib.client.gui.control.Static;
import it.zerono.mods.zerocore.lib.client.gui.control.SwitchPictureButton;
import it.zerono.mods.zerocore.lib.client.gui.databind.BindingGroup;
import it.zerono.mods.zerocore.lib.client.gui.databind.IBinding;
import it.zerono.mods.zerocore.lib.client.gui.databind.MonoConsumerBinding;
import it.zerono.mods.zerocore.lib.client.gui.databind.MultiConsumerBinding;
import it.zerono.mods.zerocore.lib.client.gui.layout.AnchoredLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.FixedLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.Sprite;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import it.zerono.mods.zerocore.lib.client.text.BindableTextComponent;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.geometry.Point;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.fluid.FluidHelper;
import it.zerono.mods.zerocore.lib.item.inventory.PlayerInventoryUsage;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import it.zerono.mods.zerocore.lib.multiblock.variant.IMultiblockVariant;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fluids.FluidStack;

public class ReactorFluidAccessPortScreen
extends AbstractMultiblockScreen<MultiblockReactor, ReactorFluidAccessPortEntity, ModTileContainer<ReactorFluidAccessPortEntity>> {
    private static final Component TEXT_EMPTY = Component.m_237115_((String)"gui.bigreactors.generic.empty").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE);
    private static final int VBARPANEL_WIDTH = 18;
    private static final int VBARPANEL_HEIGHT = 84;
    private final BindingGroup _bindings = new BindingGroup();
    private final SwitchPictureButton _btnInputDirection = new SwitchPictureButton((ModContainerScreen)this, "directionInput", false, "direction");
    private final SwitchPictureButton _btnOutputDirection = new SwitchPictureButton((ModContainerScreen)this, "directionOutput", false, "direction");
    private final Button _btnDumpFuel = new Button((ModContainerScreen)this, "dumpFuel", "");
    private final Button _btnDumpWaste = new Button((ModContainerScreen)this, "dumpWaste", "");
    private final GaugeBar _fuelTank = this.liquidBar("fuelTank", ReactorFluidAccessPortEntity.TANK_CAPACITY);
    private final GaugeBar _wasteTank = this.liquidBar("wasteTank", ReactorFluidAccessPortEntity.TANK_CAPACITY);

    public ReactorFluidAccessPortScreen(ModTileContainer<ReactorFluidAccessPortEntity> container, Inventory inventory, Component title) {
        super(container, inventory, PlayerInventoryUsage.None, title, ReactorFluidAccessPortScreen.mainTextureFromVariant((IMultiblockVariant)((ReactorFluidAccessPortEntity)container.getTileEntity()).getMultiblockVariant().orElse(ReactorVariant.Basic)));
    }

    @Override
    protected void onScreenCreate() {
        this.addPatchouliHelpButton(PatchouliCompat.HANDBOOK_ID, ExtremeReactors.newID("reactor/part-fluidaccessport"), 1);
        super.onScreenCreate();
        Panel panel = new Panel((ModContainerScreen)this, "fluidaccessport");
        panel.setLayoutEngineHint(FixedLayoutEngine.hint((int)0, (int)0));
        panel.setDesiredDimension(this.getGuiWidth(), this.getGuiHeight() - 21);
        panel.setLayoutEngine((ILayoutEngine)((AnchoredLayoutEngine)new AnchoredLayoutEngine().setHorizontalMargin(36)).setVerticalMargin(13));
        this.addControl((IControl)panel);
        this.setButtonSpritesAndOverlayForState((AbstractButtonControl)this._btnInputDirection, ButtonState.Default, CommonIcons.ButtonInputDirection);
        this.setButtonSpritesAndOverlayForState((AbstractButtonControl)this._btnInputDirection, ButtonState.Active, CommonIcons.ButtonInputDirectionActive);
        this._btnInputDirection.Activated.subscribe(this::onInputActivated);
        this._btnInputDirection.setTooltips(new Component[]{Component.m_237115_((String)"gui.bigreactors.reactor.fluidaccessport.directioninput.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), CodeHelper.TEXT_EMPTY_LINE, Component.m_237115_((String)"gui.bigreactors.reactor.fluidaccessport.directioninput.line2")});
        this.setButtonSpritesAndOverlayForState((AbstractButtonControl)this._btnOutputDirection, ButtonState.Default, CommonIcons.ButtonOutputDirection);
        this.setButtonSpritesAndOverlayForState((AbstractButtonControl)this._btnOutputDirection, ButtonState.Active, CommonIcons.ButtonOutputDirectionActive);
        this._btnOutputDirection.Activated.subscribe(this::onOutputActivated);
        this._btnOutputDirection.setTooltips(new Component[]{Component.m_237115_((String)"gui.bigreactors.reactor.fluidaccessport.directionoutput.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), CodeHelper.TEXT_EMPTY_LINE, Component.m_237115_((String)"gui.bigreactors.reactor.fluidaccessport.directionoutput.line2")});
        this.addBinding((Function<ModTileContainer<ReactorFluidAccessPortEntity>, Value>)((Function<ModTileContainer, IoDirection>)c -> ((ReactorFluidAccessPortEntity)c.getTileEntity()).getIoDirection()), (Consumer<Value>)((Consumer<IoDirection>)value -> {
            this._btnInputDirection.setActive(value.isInput());
            this._btnOutputDirection.setActive(value.isOutput());
        }));
        this._btnDumpFuel.setPadding(0);
        this._btnDumpFuel.setIconForState(CommonIcons.ButtonDumpFuel.get(), ButtonState.Default);
        this._btnDumpFuel.setIconForState(CommonIcons.ButtonDumpFuelActive.get(), ButtonState.Active, ButtonState.ActiveHighlighted, new ButtonState[]{ButtonState.DefaultHighlighted});
        this._btnDumpFuel.Clicked.subscribe(this::onDumpFuel);
        this._btnDumpFuel.setTooltips(new Component[]{Component.m_237115_((String)"gui.bigreactors.reactor.fluidaccessport.dumpfuel.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), CodeHelper.TEXT_EMPTY_LINE, Component.m_237115_((String)"gui.bigreactors.reactor.fluidaccessport.dumpfuel.line2"), Component.m_237115_((String)"gui.bigreactors.reactor.fluidaccessport.dumpfuel.line3"), Component.m_237115_((String)"gui.bigreactors.reactor.fluidaccessport.dumpfuel.line4")});
        this._btnDumpWaste.setPadding(0);
        this._btnDumpWaste.setIconForState(CommonIcons.ButtonDumpWaste.get(), ButtonState.Default);
        this._btnDumpWaste.setIconForState(CommonIcons.ButtonDumpWasteActive.get(), ButtonState.Active, ButtonState.ActiveHighlighted, new ButtonState[]{ButtonState.DefaultHighlighted});
        this._btnDumpWaste.Clicked.subscribe(this::onDumpWaste);
        this._btnDumpWaste.setTooltips(new Component[]{Component.m_237115_((String)"gui.bigreactors.reactor.fluidaccessport.dumpwaste.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), CodeHelper.TEXT_EMPTY_LINE, Component.m_237115_((String)"gui.bigreactors.reactor.fluidaccessport.dumpwaste.line2"), Component.m_237115_((String)"gui.bigreactors.reactor.fluidaccessport.dumpwaste.line3"), Component.m_237115_((String)"gui.bigreactors.reactor.fluidaccessport.dumpwaste.line4")});
        panel.addControl((IControl)this.buttonsPanel((IControl)this._btnInputDirection, (IControl)this._btnOutputDirection, (IControl)this._btnDumpFuel, (IControl)this._btnDumpWaste));
        MutableComponent tankCapacity = Component.m_237113_((String)String.format("%d mB", ReactorFluidAccessPortEntity.TANK_CAPACITY)).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE);
        Panel tanksPanel = new Panel((ModContainerScreen)this);
        tanksPanel.setDesiredDimension(47, 84);
        tanksPanel.setLayoutEngineHint((ILayoutEngine.ILayoutEngineHint)AnchoredLayoutEngine.Anchor.TopRight);
        tanksPanel.setLayoutEngine((ILayoutEngine)((HorizontalLayoutEngine)((HorizontalLayoutEngine)new HorizontalLayoutEngine().setZeroMargins()).setVerticalAlignment(VerticalAlignment.Top)).setHorizontalAlignment(HorizontalAlignment.Left));
        panel.addControl((IControl)tanksPanel);
        BindableTextComponent fuelFluidName = new BindableTextComponent(name -> name);
        BindableTextComponent fuelAmount = new BindableTextComponent(amount -> Component.m_237113_((String)String.format("%d mB", amount)).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
        BindableTextComponent fuelStoredPercentage = new BindableTextComponent(percentage -> Component.m_237113_((String)String.format("%d", (int)(percentage * 100.0))).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
        Panel p = this.vBarPanel();
        this.addBarIcon(CommonIcons.FuelReactantIcon, p).useTooltipsFrom((IControl)this._fuelTank);
        this._fuelTank.setTooltips((List)ImmutableList.of((Object)Component.m_237115_((String)"gui.bigreactors.reactor.fluidaccessport.fueltank.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.controller.coreheatbar.line2").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.fluidaccessport.fueltank.line3a").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE).m_7220_((Component)Component.m_237115_((String)"gui.bigreactors.reactor.fluidaccessport.fueltank.line3b")), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.fluidaccessport.fueltank.line4a").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE).m_7220_((Component)Component.m_237115_((String)"gui.bigreactors.reactor.fluidaccessport.fueltank.line4b")), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)Component.m_237115_((String)"gui.bigreactors.reactor.fluidaccessport.fueltank.line5"), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.fluidaccessport.fueltank.line6")), (List)ImmutableList.of((Object)fuelFluidName, (Object)fuelAmount, (Object)tankCapacity, (Object)fuelStoredPercentage));
        this.addBinding((ModTileContainer<ReactorFluidAccessPortEntity> c) -> FluidHelper.getFluidName((FluidStack)this.getFluidStack(ReactantType.Fuel)), new Consumer[]{v -> {
            FluidStack stack = this.getFluidStack(ReactantType.Fuel);
            if (stack.isEmpty()) {
                this._fuelTank.setBarSprite(Sprite.EMPTY);
                this._fuelTank.setBarSpriteTint(Colour.WHITE);
            } else {
                this._fuelTank.setBarSprite(ModRenderHelper.getFlowingFluidSprite((FluidStack)stack));
                this._fuelTank.setBarSpriteTint(ModRenderHelper.getFluidTintColour((FluidStack)stack));
            }
        }, fuelFluidName});
        Consumer[] consumerArray = new Consumer[2];
        consumerArray[0] = arg_0 -> ((GaugeBar)this._fuelTank).setValue(arg_0);
        consumerArray[1] = fuelAmount;
        this.addBinding((ModTileContainer<ReactorFluidAccessPortEntity> c) -> this.getFluidAmount(ReactantType.Fuel), consumerArray);
        this.addBinding((ModTileContainer<ReactorFluidAccessPortEntity> c) -> this.getFluidStoredPercentage(ReactantType.Fuel), new Consumer[]{v -> {}, fuelStoredPercentage});
        p.addControl((IControl)this._fuelTank);
        tanksPanel.addControl((IControl)p);
        tanksPanel.addControl((IControl)this.vSeparatorPanel());
        BindableTextComponent wasteFluidName = new BindableTextComponent(name -> name);
        BindableTextComponent wasteAmount = new BindableTextComponent(amount -> Component.m_237113_((String)String.format("%d mB", amount)).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
        BindableTextComponent wasteStoredPercentage = new BindableTextComponent(percentage -> Component.m_237113_((String)String.format("%d", (int)(percentage * 100.0))).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
        p = this.vBarPanel();
        this.addBarIcon(CommonIcons.WasteReactantIcon, p).useTooltipsFrom((IControl)this._wasteTank);
        this._wasteTank.setTooltips((List)ImmutableList.of((Object)Component.m_237115_((String)"gui.bigreactors.reactor.fluidaccessport.wastetank.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.fluidaccessport.wastetank.line2").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.fluidaccessport.wastetank.line3a").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE).m_7220_((Component)Component.m_237115_((String)"gui.bigreactors.reactor.fluidaccessport.wastetank.line3b")), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.fluidaccessport.wastetank.line4a").m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE).m_7220_((Component)Component.m_237115_((String)"gui.bigreactors.reactor.fluidaccessport.wastetank.line4b")), (Object)CodeHelper.TEXT_EMPTY_LINE, (Object)Component.m_237115_((String)"gui.bigreactors.reactor.fluidaccessport.wastetank.line5"), (Object)Component.m_237115_((String)"gui.bigreactors.reactor.fluidaccessport.wastetank.line6")), (List)ImmutableList.of((Object)wasteFluidName, (Object)wasteAmount, (Object)tankCapacity, (Object)wasteStoredPercentage));
        this.addBinding((ModTileContainer<ReactorFluidAccessPortEntity> c) -> FluidHelper.getFluidName((FluidStack)this.getFluidStack(ReactantType.Waste)), new Consumer[]{v -> {
            FluidStack stack = this.getFluidStack(ReactantType.Waste);
            if (stack.isEmpty()) {
                this._wasteTank.setBarSprite(Sprite.EMPTY);
                this._wasteTank.setBarSpriteTint(Colour.WHITE);
            } else {
                this._wasteTank.setBarSprite(ModRenderHelper.getFlowingFluidSprite((FluidStack)stack));
                this._wasteTank.setBarSpriteTint(ModRenderHelper.getFluidTintColour((FluidStack)stack));
            }
        }, wasteFluidName});
        Consumer[] consumerArray2 = new Consumer[2];
        consumerArray2[0] = arg_0 -> ((GaugeBar)this._wasteTank).setValue(arg_0);
        consumerArray2[1] = wasteAmount;
        this.addBinding((ModTileContainer<ReactorFluidAccessPortEntity> c) -> this.getFluidAmount(ReactantType.Waste), consumerArray2);
        this.addBinding((ModTileContainer<ReactorFluidAccessPortEntity> c) -> this.getFluidStoredPercentage(ReactantType.Waste), new Consumer[]{v -> {}, wasteStoredPercentage});
        p.addControl((IControl)this._wasteTank);
        tanksPanel.addControl((IControl)p);
    }

    @Override
    protected void onDataUpdated() {
        super.onDataUpdated();
        this._bindings.update();
    }

    private void onInputActivated(SwitchPictureButton button) {
        this.sendCommandToServer(CommonConstants.COMMAND_SET_INPUT);
    }

    private void onOutputActivated(SwitchPictureButton button) {
        this.sendCommandToServer(CommonConstants.COMMAND_SET_OUTPUT);
    }

    private void onDumpFuel(Button button, Integer mouseButton) {
        CompoundTag options = new CompoundTag();
        options.m_128379_("void", Screen.m_96638_());
        this.sendCommandToServer(CommonConstants.COMMAND_DUMP_FUEL, options);
    }

    private void onDumpWaste(Button button, Integer integer) {
        CompoundTag options = new CompoundTag();
        options.m_128379_("void", Screen.m_96638_());
        this.sendCommandToServer(CommonConstants.COMMAND_DUMP_WASTE, options);
    }

    private <Value> void addBinding(Function<ModTileContainer<ReactorFluidAccessPortEntity>, Value> supplier, Consumer<Value> consumer) {
        this._bindings.addBinding((IBinding)new MonoConsumerBinding((Object)((ModTileContainer)this.m_6262_()), supplier, consumer));
    }

    @SafeVarargs
    private final <Value> void addBinding(Function<ModTileContainer<ReactorFluidAccessPortEntity>, Value> supplier, Consumer<Value> ... consumers) {
        this._bindings.addBinding((IBinding)new MultiConsumerBinding((Object)((ModTileContainer)this.m_6262_()), supplier, (Consumer[])consumers));
    }

    private FluidStack getFluidStack(ReactantType type) {
        return ((ReactorFluidAccessPortEntity)this.getTileEntity()).getFluidStackHandler(type).getFluidInTank(0);
    }

    private int getFluidAmount(ReactantType type) {
        return this.getFluidStack(type).getAmount();
    }

    private double getFluidStoredPercentage(ReactantType type) {
        return (double)this.getFluidAmount(type) / (double)ReactorFluidAccessPortEntity.TANK_CAPACITY;
    }

    private Panel buttonsPanel(IControl setInput, IControl setOutput, IControl dumpFuel, IControl dumpWaste) {
        Panel p = new Panel((ModContainerScreen)this);
        p.setDesiredDimension(38, 56);
        p.setLayoutEngineHint((ILayoutEngine.ILayoutEngineHint)AnchoredLayoutEngine.Anchor.TopLeft);
        p.setCustomBackgroundPainter((panel, matrix) -> {
            Point xy = panel.controlToScreen(0, 18);
            ISprite border = CommonIcons.ImageButtonBorder.get();
            int z = (int)panel.getGui().getZLevel();
            ModRenderHelper.paintSprite((PoseStack)matrix, (ISprite)border, (int)xy.X, (int)xy.Y, (int)z, (int)18, (int)18);
            ModRenderHelper.paintSprite((PoseStack)matrix, (ISprite)border, (int)(xy.X + 20), (int)xy.Y, (int)z, (int)18, (int)18);
            ModRenderHelper.paintSprite((PoseStack)matrix, (ISprite)border, (int)xy.X, (int)(xy.Y + 20), (int)z, (int)18, (int)18);
            ModRenderHelper.paintSprite((PoseStack)matrix, (ISprite)border, (int)(xy.X + 20), (int)(xy.Y + 20), (int)z, (int)18, (int)18);
        });
        setInput.setLayoutEngineHint(FixedLayoutEngine.hint((int)1, (int)19, (int)16, (int)16));
        p.addControl(setInput);
        setOutput.setLayoutEngineHint(FixedLayoutEngine.hint((int)21, (int)19, (int)16, (int)16));
        p.addControl(setOutput);
        dumpFuel.setLayoutEngineHint(FixedLayoutEngine.hint((int)1, (int)39, (int)16, (int)16));
        p.addControl(dumpFuel);
        dumpWaste.setLayoutEngineHint(FixedLayoutEngine.hint((int)21, (int)39, (int)16, (int)16));
        p.addControl(dumpWaste);
        return p;
    }

    private GaugeBar liquidBar(String name, double maxValue) {
        GaugeBar bar = new GaugeBar((ModContainerScreen)this, name, maxValue, CommonIcons.BarBackground.get());
        bar.setDesiredDimension(18, 66);
        bar.setBackground(CommonIcons.BarBackground.get());
        bar.setPadding(1);
        return bar;
    }

    private Panel vSeparatorPanel() {
        Panel p = new Panel((ModContainerScreen)this);
        Static s = new Static((ModContainerScreen)this, 1, 84);
        p.setDesiredDimension(11, 84);
        p.setLayoutEngine((ILayoutEngine)new FixedLayoutEngine());
        s.setColor(Colour.BLACK);
        s.setLayoutEngineHint(FixedLayoutEngine.hint((int)5, (int)0, (int)1, (int)84));
        p.addControl((IControl)s);
        return p;
    }

    private Panel vBarPanel() {
        Panel p = new Panel((ModContainerScreen)this);
        p.setDesiredDimension(18, 84);
        p.setLayoutEngine((ILayoutEngine)((VerticalLayoutEngine)new VerticalLayoutEngine().setZeroMargins()).setControlsSpacing(2));
        return p;
    }

    private IControl addBarIcon(NonNullSupplier<ISprite> icon, Panel parent) {
        return this.addBarIcon(icon, 16, 16, parent);
    }

    private IControl addBarIcon(NonNullSupplier<ISprite> icon, int width, int height, Panel parent) {
        Picture c = new Picture((ModContainerScreen)this, this.nextGenericName(), (ISprite)icon.get(), width, height);
        c.setDesiredDimension(width, height);
        parent.addControl((IControl)c);
        return c;
    }
}

