/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.model.TurbineRotorModelBuilder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor.CachedTranslations;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor.ShaftSection;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorShaftState;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.TurbineVariant;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraftforge.common.util.NonNullConsumer;

public class RotorDescriptor
implements NonNullConsumer<PoseStack> {
    final Direction RotorDirection;
    final int Length;
    final ShaftSection[] Sections;
    final Matrix4f Translation;
    final Supplier<BakedModel> ShaftModel;
    final Supplier<BakedModel> BladeModel;
    final BiConsumer<PoseStack, Float> InitMatrix;
    private final Vector3f _initRotorDirectionVector;
    private final Matrix4f _initTranslate1;
    private final Matrix4f _initTranslate2;

    public static Builder builder(TurbineVariant variant, Direction rotorDirection, int length) {
        return new Builder(variant, rotorDirection, length);
    }

    public void accept(PoseStack stack) {
        stack.m_85850_().m_85861_().m_27644_(this.Translation);
    }

    private RotorDescriptor(TurbineVariant variant, Direction rotorDirection, int length, List<ShaftSection> sections) {
        this.RotorDirection = rotorDirection;
        this.Length = length;
        this.Sections = sections.toArray(new ShaftSection[0]);
        this.Translation = CachedTranslations.getFor(rotorDirection);
        switch (variant) {
            case Basic: {
                this.ShaftModel = TurbineRotorModelBuilder.BASIC_SHAFT;
                this.BladeModel = TurbineRotorModelBuilder.BASIC_BLADE;
                break;
            }
            case Reinforced: {
                this.ShaftModel = TurbineRotorModelBuilder.REINFORCED_SHAFT;
                this.BladeModel = TurbineRotorModelBuilder.REINFORCED_BLADE;
                break;
            }
            default: {
                this.BladeModel = ModRenderHelper::getMissingModel;
                this.ShaftModel = this.BladeModel;
            }
        }
        this._initRotorDirectionVector = this.RotorDirection.m_122432_();
        float rotationOffsetX = 0.0f == this._initRotorDirectionVector.m_122239_() ? 0.5f : 0.0f;
        float rotationOffsetY = 0.0f == this._initRotorDirectionVector.m_122260_() ? 0.5f : 0.0f;
        float rotationOffsetZ = 0.0f == this._initRotorDirectionVector.m_122269_() ? 0.5f : 0.0f;
        this._initTranslate1 = Matrix4f.m_27653_((float)rotationOffsetX, (float)rotationOffsetY, (float)rotationOffsetZ);
        this._initTranslate2 = Matrix4f.m_27653_((float)(-rotationOffsetX), (float)(-rotationOffsetY), (float)(-rotationOffsetZ));
        this.InitMatrix = this::initMatrix;
    }

    private void initMatrix(PoseStack stack, float rotorAngle) {
        PoseStack.Pose entry = stack.m_85850_();
        Matrix4f matrix = entry.m_85861_();
        Matrix3f normal = entry.m_85864_();
        Quaternion rotation = this._initRotorDirectionVector.m_122240_(rotorAngle);
        matrix.m_27644_(this._initTranslate1);
        matrix.m_27646_(rotation);
        normal.m_8171_(rotation);
        matrix.m_27644_(this._initTranslate2);
    }

    public static class Builder {
        private final TurbineVariant _variant;
        private final Direction _rotorDirection;
        private final int _length;
        private final List<ShaftSection> _shaft;

        public RotorDescriptor build() {
            return new RotorDescriptor(this._variant, this._rotorDirection, this._length, this._shaft);
        }

        public Builder section(RotorShaftState state, NonNullConsumer<ShaftSection.Builder> consumer) {
            ShaftSection.Builder builder = ShaftSection.builder(state);
            consumer.accept((Object)builder);
            this._shaft.add(builder.build());
            return this;
        }

        private Builder(TurbineVariant variant, Direction rotorDirection, int length) {
            this._variant = variant;
            this._rotorDirection = rotorDirection;
            this._length = length;
            this._shaft = Lists.newArrayList();
        }
    }
}

