/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import it.zerono.mods.extremereactors.config.Config;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.TurbinePartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.IMultiblockTurbineVariant;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.world.level.block.state.BlockBehaviour;

public enum TurbineVariant implements IMultiblockTurbineVariant
{
    Basic(Builder.create(5, 10).setTranslationKey("variant.bigreactors.turbine.basic").setBlockPropertiesFixer(bp -> bp.m_60913_(3.0f, 6.0f)).setPartEnergyCapacity(10000).setEnergyGenerationEfficiency(0.75f).setMaxEnergyExtractionRate(50000.0).setMaxChargerRate(500.0).setRadiationAttenuation(0.9f).setResidualRadiationAttenuation(0.1f).setMaxPermittedFlow(1000).setBaseFluidPerBlade(15).setRotorDragCoefficient(0.01f).setMaxRotorSpeed(1000.0f).setRotorBladeMass(8).setRotorShaftMass(8).setPartFluidCapacity(250).setMaxFluidCapacity(10000).setPartCompatibilityTest(TurbineVariant::isBasicPart)),
    Reinforced(Builder.create(1000).setTranslationKey("variant.bigreactors.turbine.reinforced").setBlockPropertiesFixer(bp -> bp.m_60913_(6.0f, 6.0f)).setPartEnergyCapacity(20000).setEnergyGenerationEfficiency(0.85f).setMaxEnergyExtractionRate(5000000.0).setMaxChargerRate(5000.0).setRadiationAttenuation(0.75f).setResidualRadiationAttenuation(0.15f).setMaxPermittedFlow(2000).setBaseFluidPerBlade(25).setRotorDragCoefficient(0.01f).setMaxRotorSpeed(2000.0f).setRotorBladeMass(10).setRotorShaftMass(10).setPartFluidCapacity(500).setMaxFluidCapacity(300000));

    private static final Set<TurbinePartType> BASIC_INVALID_PARTS;
    private final String _translationKey;
    private final int _maxX;
    private final int _maxY;
    private final int _maxZ;
    private final int _minParts;
    private final int _partEnergyCapacity;
    private final float _energyGenerationEfficiency;
    private final WideAmount _maxEnergyExtractionRate;
    private final double _maxChargerRate;
    private final int _partFluidCapacity;
    private final int _maxFluidCapacity;
    private final float _vaporGenerationEfficiency;
    private final float _radiationAttenuation;
    private final float _residualRadiationAttenuation;
    private final int _rotorShaftMass;
    private final int _rotorBladeMass;
    private final float _maxRotorSpeed;
    private final float _rotorDragCoefficient;
    private final int _baseFluidPerBlade;
    private final int _maxPermittedFlow;
    private final Function<BlockBehaviour.Properties, BlockBehaviour.Properties> _blockPropertiesFixer;
    private final Predicate<TurbinePartType> _partTest;

    public boolean isPartCompatible(TurbinePartType partType) {
        return this._partTest.test(partType);
    }

    public static TurbineVariant from(IMultiblockTurbineVariant variant) {
        return (TurbineVariant)variant;
    }

    public int getId() {
        return this.ordinal();
    }

    public String getName() {
        return CodeHelper.neutralLowercase((String)this.name());
    }

    public String getTranslationKey() {
        return this._translationKey;
    }

    public BlockBehaviour.Properties getBlockProperties() {
        return this._blockPropertiesFixer.apply(this.getDefaultBlockProperties());
    }

    public int getMaximumXSize() {
        return Math.min((Integer)Config.COMMON.turbine.maxTurbineSize.get(), this._maxX);
    }

    public int getMaximumZSize() {
        return Math.min((Integer)Config.COMMON.turbine.maxTurbineSize.get(), this._maxZ);
    }

    public int getMaximumYSize() {
        return Math.min((Integer)Config.COMMON.turbine.maxTurbineHeight.get(), this._maxY);
    }

    public int getMinimumPartsCount() {
        return this._minParts;
    }

    @Override
    public int getPartEnergyCapacity() {
        return this._partEnergyCapacity;
    }

    @Override
    public float getEnergyGenerationEfficiency() {
        return this._energyGenerationEfficiency;
    }

    @Override
    public WideAmount getMaxEnergyExtractionRate() {
        return this._maxEnergyExtractionRate;
    }

    @Override
    public double getChargerMaxRate() {
        return this._maxChargerRate;
    }

    @Override
    public float getRadiationAttenuation() {
        return this._radiationAttenuation;
    }

    @Override
    public float getResidualRadiationAttenuation() {
        return this._residualRadiationAttenuation;
    }

    @Override
    public int getRotorShaftMass() {
        return this._rotorShaftMass;
    }

    @Override
    public int getRotorBladeMass() {
        return this._rotorBladeMass;
    }

    @Override
    public float getMaxRotorSpeed() {
        return this._maxRotorSpeed;
    }

    @Override
    public float getRotorDragCoefficient() {
        return this._rotorDragCoefficient;
    }

    @Override
    public int getBaseFluidPerBlade() {
        return this._baseFluidPerBlade;
    }

    @Override
    public int getMaxPermittedFlow() {
        return this._maxPermittedFlow;
    }

    @Override
    public int getPartFluidCapacity() {
        return this._partFluidCapacity;
    }

    @Override
    public int getMaxFluidCapacity() {
        return this._maxFluidCapacity;
    }

    @Override
    public float getVaporGenerationEfficiency() {
        return this._vaporGenerationEfficiency;
    }

    private TurbineVariant(Builder builder) {
        this._translationKey = builder._translationKey;
        this._blockPropertiesFixer = null != builder._blockPropertiesFixer ? builder._blockPropertiesFixer : bp -> bp;
        this._maxX = builder._maxX;
        this._maxY = builder._maxY;
        this._maxZ = builder._maxZ;
        this._minParts = builder._minParts;
        this._partEnergyCapacity = builder._partEnergyCapacity;
        this._energyGenerationEfficiency = builder._energyGenerationEfficiency;
        this._maxEnergyExtractionRate = WideAmount.asImmutable((double)builder._maxEnergyExtractionRate);
        this._maxChargerRate = builder._maxChargerRate;
        this._radiationAttenuation = builder._radiationAttenuation;
        this._residualRadiationAttenuation = builder._residualRadiationAttenuation;
        this._partFluidCapacity = builder._partFluidCapacity;
        this._maxFluidCapacity = builder._maxFluidCapacity;
        this._vaporGenerationEfficiency = builder._vaporGenerationEfficiency;
        this._rotorShaftMass = builder._rotorShaftMass;
        this._rotorBladeMass = builder._rotorBladeMass;
        this._maxRotorSpeed = builder._maxRotorSpeed;
        this._rotorDragCoefficient = builder._rotorDragCoefficient;
        this._baseFluidPerBlade = builder._baseFluidPerBlade;
        this._maxPermittedFlow = builder._maxPermittedFlow;
        this._partTest = builder._partTest;
    }

    private static boolean isBasicPart(TurbinePartType partType) {
        return !BASIC_INVALID_PARTS.contains((Object)partType);
    }

    static {
        BASIC_INVALID_PARTS = Sets.immutableEnumSet((Enum)TurbinePartType.ComputerPort, (Enum[])new TurbinePartType[0]);
    }

    private static final class Builder {
        private String _translationKey = "";
        private final int _maxX;
        private final int _maxY;
        private final int _maxZ;
        private int _minParts;
        private int _partEnergyCapacity;
        private float _energyGenerationEfficiency;
        private double _maxEnergyExtractionRate;
        private double _maxChargerRate;
        private int _partFluidCapacity;
        private int _maxFluidCapacity;
        private float _vaporGenerationEfficiency;
        private float _radiationAttenuation;
        private float _residualRadiationAttenuation;
        private int _rotorShaftMass;
        private int _rotorBladeMass;
        private float _maxRotorSpeed;
        private float _rotorDragCoefficient;
        private int _baseFluidPerBlade;
        private int _maxPermittedFlow;
        private Function<BlockBehaviour.Properties, BlockBehaviour.Properties> _blockPropertiesFixer;
        private Predicate<TurbinePartType> _partTest;

        public static Builder create(int maxSize) {
            return new Builder(maxSize, maxSize, maxSize);
        }

        public static Builder create(int maxWidth, int maxHeight) {
            return new Builder(maxWidth, maxHeight, maxWidth);
        }

        public static Builder create(int maxX, int maxY, int maxZ) {
            return new Builder(maxX, maxY, maxZ);
        }

        public Builder setTranslationKey(String key) {
            this._translationKey = Objects.requireNonNull(key);
            return this;
        }

        public Builder setMinimumPartsCount(int count) {
            Preconditions.checkArgument((count >= 26 ? 1 : 0) != 0);
            this._minParts = count;
            return this;
        }

        public Builder setPartEnergyCapacity(int capacity) {
            Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0);
            this._partEnergyCapacity = capacity;
            return this;
        }

        public Builder setEnergyGenerationEfficiency(float efficiency) {
            this._energyGenerationEfficiency = efficiency;
            return this;
        }

        public Builder setMaxEnergyExtractionRate(double rate) {
            Preconditions.checkArgument((rate > 0.0 ? 1 : 0) != 0);
            this._maxEnergyExtractionRate = rate;
            return this;
        }

        public Builder setMaxChargerRate(double rate) {
            Preconditions.checkArgument((rate > 0.0 ? 1 : 0) != 0);
            this._maxChargerRate = rate;
            return this;
        }

        public Builder setRadiationAttenuation(float attenuation) {
            Preconditions.checkArgument((attenuation > 0.0f && attenuation < 1.0f ? 1 : 0) != 0);
            this._radiationAttenuation = attenuation;
            return this;
        }

        public Builder setResidualRadiationAttenuation(float attenuation) {
            Preconditions.checkArgument((attenuation > 0.0f && attenuation < 1.0f ? 1 : 0) != 0);
            this._residualRadiationAttenuation = attenuation;
            return this;
        }

        public Builder setPartFluidCapacity(int capacity) {
            Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0);
            this._partFluidCapacity = capacity;
            return this;
        }

        public Builder setMaxFluidCapacity(int capacity) {
            Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0);
            this._maxFluidCapacity = capacity;
            return this;
        }

        public Builder setVaporGenerationEfficiency(float efficiency) {
            Preconditions.checkArgument((efficiency > 0.0f && efficiency < 1.0f ? 1 : 0) != 0);
            this._vaporGenerationEfficiency = efficiency;
            return this;
        }

        public Builder setBlockPropertiesFixer(Function<BlockBehaviour.Properties, BlockBehaviour.Properties> fixer) {
            this._blockPropertiesFixer = fixer;
            return this;
        }

        public Builder setPartCompatibilityTest(Predicate<TurbinePartType> test) {
            this._partTest = test;
            return this;
        }

        public Builder setRotorShaftMass(int mass) {
            this._rotorShaftMass = mass;
            return this;
        }

        public Builder setRotorBladeMass(int mass) {
            this._rotorBladeMass = mass;
            return this;
        }

        public Builder setMaxRotorSpeed(float speed) {
            this._maxRotorSpeed = speed;
            return this;
        }

        public Builder setRotorDragCoefficient(float coefficient) {
            this._rotorDragCoefficient = coefficient;
            return this;
        }

        public Builder setBaseFluidPerBlade(int fluidPerBlade) {
            this._baseFluidPerBlade = fluidPerBlade;
            return this;
        }

        public Builder setMaxPermittedFlow(int maxFlow) {
            this._maxPermittedFlow = maxFlow;
            return this;
        }

        private Builder(int maxX, int maxY, int maxZ) {
            this._maxX = maxX;
            this._maxY = maxY;
            this._maxZ = maxZ;
            this._minParts = 27;
            this._blockPropertiesFixer = null;
            this._partTest = turbinePartType -> true;
        }
    }
}

