/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wire_post;

import commoble.morered.MoreRed;
import commoble.morered.api.ChanneledPowerSupplier;
import commoble.morered.api.MoreRedAPI;
import commoble.morered.util.DirectionHelper;
import commoble.morered.wire_post.AbstractPostBlock;
import commoble.morered.wire_post.BundledCablePostBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class BundledCableRelayPlateBlockEntity
extends BundledCablePostBlockEntity
implements ChanneledPowerSupplier {
    protected final LazyOptional<ChanneledPowerSupplier> powerHolder = LazyOptional.of(() -> this);

    public BundledCableRelayPlateBlockEntity(BlockEntityType<? extends BundledCableRelayPlateBlockEntity> type, BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends BundledCablePostBlockEntity>)type, pos, state);
    }

    public BundledCableRelayPlateBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends BundledCableRelayPlateBlockEntity>)((BlockEntityType)MoreRed.instance().bundledCableRelayPlateBeType.get()), pos, state);
    }

    @Override
    public int getPowerOnChannel(Level world, BlockPos wirePos, BlockState wireState, Direction wireFace, int channel) {
        BlockState thisState = this.m_58900_();
        return wireFace == null || thisState.m_60734_() instanceof AbstractPostBlock && wireFace == thisState.m_61143_((Property)AbstractPostBlock.DIRECTION_OF_ATTACHMENT) ? this.getPower(channel) : 0;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == MoreRedAPI.CHANNELED_POWER_CAPABILITY) {
            return this.powerHolder;
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.powerHolder.invalidate();
    }

    @Override
    public byte[] getStrongestNeighborPower() {
        BlockState state = this.m_58900_();
        Block block = state.m_60734_();
        if (!(block instanceof AbstractPostBlock)) {
            return new byte[16];
        }
        BlockPos pos = this.m_58899_();
        Direction attachmentDirection = (Direction)state.m_61143_((Property)AbstractPostBlock.DIRECTION_OF_ATTACHMENT);
        byte[] result = new byte[16];
        for (int orthagonal = 0; orthagonal < 4; ++orthagonal) {
            int secondarySide = DirectionHelper.uncompressSecondSide(attachmentDirection.ordinal(), orthagonal);
            Direction orthagonalDirection = Direction.m_122376_((int)secondarySide);
            BlockPos neighborPos = pos.m_121945_(orthagonalDirection);
            BlockEntity te = this.f_58857_.m_7702_(neighborPos);
            if (te == null) continue;
            te.getCapability(MoreRedAPI.CHANNELED_POWER_CAPABILITY, orthagonalDirection.m_122424_()).ifPresent(power -> {
                for (int channel = 0; channel < 16; ++channel) {
                    result[channel] = (byte)Math.max(result[channel], power.getPowerOnChannel(this.f_58857_, pos, state, attachmentDirection, channel) - 1);
                }
            });
        }
        return result;
    }
}

