/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api.util;

import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.ITinkerable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AugmentUtils {
    public static void addAugment(ItemStack stack, Augment augment, int slot) {
        ITinkerable tinkerable;
        Item item = stack.m_41720_();
        if (item instanceof ITinkerable && slot < (tinkerable = (ITinkerable)item).getAugmentSlots() && tinkerable.getTinkerableTier() >= augment.getTier()) {
            CompoundTag nbt = stack.m_41783_();
            if (nbt == null) {
                nbt = new CompoundTag();
                stack.m_41751_(nbt);
            }
            nbt.m_128359_("Augment-" + slot, augment.getId().toString());
        }
    }

    public static void removeAugment(ItemStack stack, int slot) {
        ITinkerable tinkerable;
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            return;
        }
        Item item = stack.m_41720_();
        if (item instanceof ITinkerable && slot < (tinkerable = (ITinkerable)item).getAugmentSlots() && nbt.m_128441_("Augment-" + slot)) {
            nbt.m_128473_("Augment-" + slot);
        }
    }

    public static Augment getAugment(ItemStack stack, int slot) {
        ITinkerable tinkerable;
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            return null;
        }
        Item item = stack.m_41720_();
        if (item instanceof ITinkerable && slot < (tinkerable = (ITinkerable)item).getAugmentSlots() && nbt.m_128441_("Augment-" + slot)) {
            String name = nbt.m_128461_("Augment-" + slot);
            return MysticalAgricultureAPI.getAugmentRegistry().getAugmentById(new ResourceLocation(name));
        }
        return null;
    }

    public static List<Augment> getAugments(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        ArrayList<Augment> augments = new ArrayList<Augment>();
        if (nbt == null) {
            return augments;
        }
        Item item = stack.m_41720_();
        if (item instanceof ITinkerable) {
            ITinkerable tinkerable = (ITinkerable)item;
            int slots = tinkerable.getAugmentSlots();
            for (int i = 0; i < slots; ++i) {
                Augment augment = AugmentUtils.getAugment(stack, i);
                if (augment == null) continue;
                augments.add(augment);
            }
        }
        return augments;
    }

    public static List<Augment> getArmorAugments(Player player) {
        NonNullList armor = player.m_150109_().f_35975_;
        ArrayList<Augment> augments = new ArrayList<Augment>();
        for (ItemStack stack : armor) {
            augments.addAll(AugmentUtils.getAugments(stack));
        }
        return augments;
    }

    public static ChatFormatting getColorForTier(int tier) {
        return switch (tier) {
            case 1 -> CropTier.ONE.getTextColor();
            case 2 -> CropTier.TWO.getTextColor();
            case 3 -> CropTier.THREE.getTextColor();
            case 4 -> CropTier.FOUR.getTextColor();
            case 5 -> CropTier.FIVE.getTextColor();
            default -> ChatFormatting.GRAY;
        };
    }

    public static Component getTooltipForTier(int tier) {
        return Component.m_237113_((String)String.valueOf(tier)).m_130940_(AugmentUtils.getColorForTier(tier));
    }
}

