/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.ingredient;

import com.blakebr0.mysticalagriculture.api.util.MobSoulUtils;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.blakebr0.mysticalagriculture.item.SoulJarItem;
import com.blakebr0.mysticalagriculture.registry.MobSoulTypeRegistry;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class FilledSoulJarIngredient
extends Ingredient {
    private ItemStack[] stacks;
    private IntList stacksPacked;

    public FilledSoulJarIngredient() {
        super(Stream.empty());
    }

    public ItemStack[] m_43908_() {
        if (this.stacks == null) {
            this.initMatchingStacks();
        }
        return this.stacks;
    }

    public IntList m_43931_() {
        if (this.stacksPacked == null) {
            if (this.stacks == null) {
                this.initMatchingStacks();
            }
            this.stacksPacked = new IntArrayList(this.stacks.length);
            Arrays.stream(this.stacks).forEach(s -> this.stacksPacked.add(StackedContents.m_36496_((ItemStack)s)));
            this.stacksPacked.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.stacksPacked;
    }

    public boolean test(ItemStack stack) {
        if (stack != null) {
            if (this.stacks == null) {
                this.initMatchingStacks();
            }
            return stack.m_41720_() instanceof SoulJarItem && MobSoulUtils.getSouls(stack) > 0.0;
        }
        return false;
    }

    public boolean m_43947_() {
        return !(this.stacks != null && this.stacks.length != 0 || this.stacksPacked != null && !this.stacksPacked.isEmpty());
    }

    public JsonElement m_43942_() {
        JsonArray json = new JsonArray();
        JsonObject obj = new JsonObject();
        obj.addProperty("item", "mysticalagriculture:soul_jar");
        json.add((JsonElement)obj);
        return json;
    }

    protected void invalidate() {
        this.stacks = null;
        this.stacksPacked = null;
    }

    public boolean isSimple() {
        return false;
    }

    private void initMatchingStacks() {
        this.stacks = (ItemStack[])MobSoulTypeRegistry.getInstance().getMobSoulTypes().stream().map(type -> MobSoulUtils.getFilledSoulJar(type, (Item)ModItems.SOUL_JAR.get())).toArray(ItemStack[]::new);
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return ModRecipeSerializers.FILLED_SOUL_JAR_INGREDIENT;
    }

    public static class Serializer
    implements IIngredientSerializer<FilledSoulJarIngredient> {
        public FilledSoulJarIngredient parse(FriendlyByteBuf buffer) {
            return new FilledSoulJarIngredient();
        }

        public FilledSoulJarIngredient parse(JsonObject json) {
            return new FilledSoulJarIngredient();
        }

        public void write(FriendlyByteBuf buffer, FilledSoulJarIngredient ingredient) {
        }
    }
}

