/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.network.message;

import com.blakebr0.cucumber.network.message.Message;
import com.blakebr0.mysticalagriculture.util.RecipeIngredientCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ReloadIngredientCacheMessage
extends Message<ReloadIngredientCacheMessage> {
    private final Map<RecipeType<?>, Map<Item, List<Ingredient>>> caches;

    public ReloadIngredientCacheMessage() {
        this.caches = Map.of();
    }

    public ReloadIngredientCacheMessage(Map<RecipeType<?>, Map<Item, List<Ingredient>>> caches) {
        this.caches = caches;
    }

    public ReloadIngredientCacheMessage read(FriendlyByteBuf buffer) {
        HashMap caches = new HashMap();
        int types = buffer.m_130242_();
        for (int i = 0; i < types; ++i) {
            RecipeType type = (RecipeType)ForgeRegistries.RECIPE_TYPES.getValue(buffer.m_130281_());
            int items = buffer.m_130242_();
            caches.put(type, new HashMap());
            for (int j = 0; j < items; ++j) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(buffer.m_130281_());
                int ingredients = buffer.m_130242_();
                for (int k = 0; k < ingredients; ++k) {
                    List cache = caches.get(type).computeIfAbsent(item, l -> new ArrayList());
                    cache.add(Ingredient.m_43940_((FriendlyByteBuf)buffer));
                }
            }
        }
        return new ReloadIngredientCacheMessage(caches);
    }

    public void write(ReloadIngredientCacheMessage message, FriendlyByteBuf buffer) {
        buffer.m_130130_(message.caches.size());
        for (Map.Entry<RecipeType<?>, Map<Item, List<Ingredient>>> entry : message.caches.entrySet()) {
            ResourceLocation type = ForgeRegistries.RECIPE_TYPES.getKey(entry.getKey());
            Map<Item, List<Ingredient>> caches = entry.getValue();
            assert (type != null);
            buffer.m_130085_(type);
            buffer.m_130130_(caches.size());
            for (Map.Entry<Item, List<Ingredient>> cache : caches.entrySet()) {
                ResourceLocation item = ForgeRegistries.ITEMS.getKey((Object)cache.getKey());
                List<Ingredient> ingredients = cache.getValue();
                assert (item != null);
                buffer.m_130085_(item);
                buffer.m_130130_(ingredients.size());
                for (Ingredient ingredient : ingredients) {
                    ingredient.m_43923_(buffer);
                }
            }
        }
    }

    public void onMessage(ReloadIngredientCacheMessage message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> RecipeIngredientCache.INSTANCE.setCaches(message.caches));
        context.get().setPacketHandled(true);
    }
}

