/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalcustomization.loader;

import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalagriculture.api.registry.ICropRegistry;
import com.blakebr0.mysticalcustomization.MysticalCustomization;
import com.blakebr0.mysticalcustomization.create.CropTierCreator;
import com.blakebr0.mysticalcustomization.modify.CropTierModifier;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;

public final class CropTierLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Map<CropTier, ResourceLocation> FARMLAND_MAP = new HashMap<CropTier, ResourceLocation>();
    public static final Map<CropTier, ResourceLocation> ESSENCE_MAP = new HashMap<CropTier, ResourceLocation>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onRegisterCrops(ICropRegistry registry) {
        File[] files;
        File dir = FMLPaths.CONFIGDIR.get().resolve("mysticalcustomization/tiers/").toFile();
        if (!dir.exists() && dir.mkdirs()) {
            MysticalCustomization.LOGGER.info("Created /config/mysticalcustomization/tiers/ directory");
        }
        if ((files = dir.listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".json"))) == null) {
            return;
        }
        for (File file : files) {
            InputStreamReader reader = null;
            ResourceLocation id = null;
            CropTier tier = null;
            try {
                JsonParser parser = new JsonParser();
                reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
                JsonObject json = parser.parse((Reader)reader).getAsJsonObject();
                String name = file.getName().replace(".json", "");
                id = new ResourceLocation("mysticalcustomization", name);
                tier = CropTierCreator.create(id, json);
                reader.close();
                IOUtils.closeQuietly((Reader)reader);
            }
            catch (Exception e) {
                MysticalCustomization.LOGGER.error("An error occurred while creating crop tier with id {}", id, (Object)e);
            }
            finally {
                IOUtils.closeQuietly(reader);
            }
            if (tier == null) continue;
            registry.registerTier(tier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPostRegisterCrops(ICropRegistry registry) {
        block12: {
            File file;
            block13: {
                File dir = FMLPaths.CONFIGDIR.get().resolve("mysticalcustomization/").toFile();
                if (!dir.exists() && dir.mkdirs()) {
                    MysticalCustomization.LOGGER.info("Created /config/mysticalcustomization/ directory");
                }
                if (!(file = FMLPaths.CONFIGDIR.get().resolve("mysticalcustomization/configure-tiers.json").toFile()).exists() || !file.isFile()) break block13;
                FileReader reader = null;
                try {
                    JsonParser parser = new JsonParser();
                    reader = new FileReader(file);
                    JsonObject json = parser.parse((Reader)reader).getAsJsonObject();
                    json.entrySet().forEach(entry -> {
                        String id = (String)entry.getKey();
                        JsonObject changes = ((JsonElement)entry.getValue()).getAsJsonObject();
                        CropTier tier = registry.getTierById(new ResourceLocation(id));
                        if (tier == null) {
                            String error = String.format("Invalid crop tier id provided: %s", id);
                            throw new JsonParseException(error);
                        }
                        CropTierModifier.modify(tier, changes);
                    });
                    reader.close();
                }
                catch (Exception e) {
                    try {
                        MysticalCustomization.LOGGER.error("An error occurred while reading configure-tiers.json", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Reader)reader);
                    break block12;
                }
                IOUtils.closeQuietly((Reader)reader);
                break block12;
            }
            try (FileWriter writer = new FileWriter(file);){
                JsonObject object = new JsonObject();
                GSON.toJson((JsonElement)object, (Appendable)writer);
            }
            catch (IOException e) {
                MysticalCustomization.LOGGER.error("An error occurred while creating configure-tiers.json", (Throwable)e);
            }
        }
    }

    public static void onCommonSetup() {
        FARMLAND_MAP.forEach((tier, block) -> {
            Block farmland = (Block)ForgeRegistries.BLOCKS.getValue(block);
            if (farmland instanceof FarmBlock) {
                tier.setFarmland(() -> farmland);
            } else {
                MysticalCustomization.LOGGER.error("Invalid farmland block provided");
            }
        });
        ESSENCE_MAP.forEach((tier, item) -> {
            Item essence = (Item)ForgeRegistries.ITEMS.getValue(item);
            if (essence == Items.f_41852_) {
                throw new JsonSyntaxException("Invalid essence item provided");
            }
            tier.setEssence(() -> essence);
        });
    }
}

