/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalcustomization.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.util.GsonHelper;

public final class ParsingUtils {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static int parseHex(String s, String name) {
        if (s.startsWith("#")) {
            s = s.substring(1);
        }
        try {
            return Integer.parseInt(s, 16);
        }
        catch (NumberFormatException e) {
            throw new JsonSyntaxException("Invalid color provided for color " + name);
        }
    }

    public static CompoundTag parseNBT(JsonElement json) {
        try {
            if (json.isJsonObject()) {
                return TagParser.m_129359_((String)GSON.toJson(json));
            }
            return TagParser.m_129359_((String)GsonHelper.m_13805_((JsonElement)json, (String)"nbt"));
        }
        catch (CommandSyntaxException e) {
            throw new JsonSyntaxException("Invalid NBT entry: " + e.toString());
        }
    }
}

